/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.handler;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import de.plushnikov.intellij.plugin.handler.BaseLombokHandler;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokGetterHandler
extends BaseLombokHandler {
    @Override
    protected void processClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LombokGetterHandler.$$$reportNull$$$0(0);
        }
        HashMap<PsiField, PsiMethod> fieldMethodMap = new HashMap<PsiField, PsiMethod>();
        for (PsiField psiField : psiClass.getFields()) {
            PsiField setterField;
            PsiMethod propertyGetter = PropertyUtilBase.findPropertyGetter((PsiClass)psiClass, (String)psiField.getName(), (boolean)psiField.hasModifierProperty("static"), (boolean)false);
            if (null == propertyGetter || null == (setterField = LombokGetterHandler.findFieldIfMethodIsSimpleGetter(propertyGetter)) || !setterField.equals(psiField)) continue;
            fieldMethodMap.put(psiField, propertyGetter);
        }
        LombokGetterHandler.processIntern(fieldMethodMap, psiClass, "lombok.Getter");
    }

    @Nullable
    public static PsiField findFieldIfMethodIsSimpleGetter(@NotNull PsiMethod method) {
        String fieldIdentifier;
        PsiCodeBlock methodBody;
        if (method == null) {
            LombokGetterHandler.$$$reportNull$$$0(1);
        }
        if ((methodBody = method.getBody()) == null) {
            return null;
        }
        PsiStatement @NotNull [] methodStatements = (PsiStatement[])Arrays.stream(methodBody.getStatements()).filter(Predicate.not(PsiEmptyStatement.class::isInstance)).toArray(PsiStatement[]::new);
        if (methodStatements.length != 1) {
            return null;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)ObjectUtils.tryCast((Object)methodStatements[0], PsiReturnStatement.class);
        if (returnStatement == null) {
            return null;
        }
        PsiReferenceExpression targetRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)returnStatement.getReturnValue()), PsiReferenceExpression.class);
        if (targetRef == null) {
            return null;
        }
        @Nullable PsiExpression qualifier = targetRef.getQualifierExpression();
        @Nullable PsiThisExpression thisExpression = (PsiThisExpression)ObjectUtils.tryCast((Object)qualifier, PsiThisExpression.class);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method, PsiClass.class);
        if (psiClass == null) {
            return null;
        }
        if (qualifier != null) {
            if (thisExpression == null) {
                return null;
            }
            if (thisExpression.getQualifier() != null && !thisExpression.getQualifier().isReferenceTo((PsiElement)psiClass)) {
                return null;
            }
        }
        if ((fieldIdentifier = targetRef.getReferenceName()) == null) {
            return null;
        }
        boolean isMethodStatic = method.hasModifierProperty("static");
        PsiField field = psiClass.findFieldByName(fieldIdentifier, false);
        if (field == null || !field.isWritable() || isMethodStatic != field.hasModifierProperty("static") || !field.getType().equals(method.getReturnType())) {
            return null;
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(field);
        String lombokMethodName = LombokUtils.getGetterName(field, accessorsInfo);
        if (!method.getName().equals(lombokMethodName)) {
            return null;
        }
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/handler/LombokGetterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFieldIfMethodIsSimpleGetter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

