/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.handler;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import de.plushnikov.intellij.plugin.handler.BaseLombokHandler;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokSetterHandler
extends BaseLombokHandler {
    @Override
    protected void processClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LombokSetterHandler.$$$reportNull$$$0(0);
        }
        HashMap<PsiField, PsiMethod> fieldMethodMap = new HashMap<PsiField, PsiMethod>();
        for (PsiField psiField : psiClass.getFields()) {
            PsiField setterField;
            PsiMethod propertySetter = PropertyUtilBase.findPropertySetter((PsiClass)psiClass, (String)psiField.getName(), (boolean)psiField.hasModifierProperty("static"), (boolean)false);
            if (null == propertySetter || null == (setterField = LombokSetterHandler.findFieldIfMethodIsSimpleSetter(propertySetter)) || !setterField.equals(psiField)) continue;
            fieldMethodMap.put(psiField, propertySetter);
        }
        LombokSetterHandler.processIntern(fieldMethodMap, psiClass, "lombok.Setter");
    }

    @Nullable
    public static PsiField findFieldIfMethodIsSimpleSetter(@NotNull PsiMethod method) {
        String fieldIdentifier;
        PsiClass containingClass;
        if (method == null) {
            LombokSetterHandler.$$$reportNull$$$0(1);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return null;
        }
        PsiCodeBlock methodBody = method.getBody();
        if (methodBody == null) {
            return null;
        }
        PsiStatement @NotNull [] methodStatements = (PsiStatement[])Arrays.stream(methodBody.getStatements()).filter(Predicate.not(PsiEmptyStatement.class::isInstance)).toArray(PsiStatement[]::new);
        if (methodStatements.length != 1) {
            return null;
        }
        PsiExpressionStatement assignmentStatement = (PsiExpressionStatement)ObjectUtils.tryCast((Object)methodStatements[0], PsiExpressionStatement.class);
        if (assignmentStatement == null) {
            return null;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)assignmentStatement.getExpression(), PsiAssignmentExpression.class);
        if (assignment == null || assignment.getOperationTokenType() != JavaTokenType.EQ) {
            return null;
        }
        PsiReferenceExpression sourceRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression()), PsiReferenceExpression.class);
        if (sourceRef == null || sourceRef.getQualifierExpression() != null) {
            return null;
        }
        @Nullable String paramIdentifier = sourceRef.getReferenceName();
        if (paramIdentifier == null) {
            return null;
        }
        PsiParameter parameter = method.getParameterList().getParameters()[0];
        if (!paramIdentifier.equals(parameter.getName())) {
            return null;
        }
        PsiReferenceExpression targetRef = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (targetRef == null) {
            return null;
        }
        @Nullable PsiExpression qualifier = targetRef.getQualifierExpression();
        @Nullable PsiThisExpression thisExpression = (PsiThisExpression)ObjectUtils.tryCast((Object)qualifier, PsiThisExpression.class);
        if (qualifier != null) {
            if (thisExpression == null) {
                return null;
            }
            if (thisExpression.getQualifier() != null && !thisExpression.getQualifier().isReferenceTo((PsiElement)containingClass)) {
                return null;
            }
        }
        if ((fieldIdentifier = targetRef.getReferenceName()) == null) {
            return null;
        }
        if (qualifier == null && paramIdentifier.equals(fieldIdentifier)) {
            return null;
        }
        boolean isMethodStatic = method.hasModifierProperty("static");
        PsiField field = containingClass.findFieldByName(fieldIdentifier, false);
        if (field == null || !field.isWritable() || isMethodStatic != field.hasModifierProperty("static") || !field.getType().equals(parameter.getType())) {
            return null;
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(field);
        String lombokMethodName = LombokUtils.getSetterName(field, accessorsInfo);
        if (!method.getName().equals(lombokMethodName)) {
            return null;
        }
        return field;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/handler/LombokSetterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findFieldIfMethodIsSimpleSetter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

