/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocToken;
import com.siyeh.ig.psiutils.CommentTracker;
import de.plushnikov.intellij.plugin.inspection.LombokJavaInspectionBase;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LombokGetterOrSetterMayBeUsedInspection
extends LombokJavaInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            LombokGetterOrSetterMayBeUsedInspection.$$$reportNull$$$0(0);
        }
        return new LombokGetterOrSetterMayBeUsedVisitor(holder, null);
    }

    @NotNull
    protected abstract String getTagName();

    @NotNull
    protected abstract String getJavaDocMethodMarkup();

    @NotNull
    @NonNls
    protected abstract String getAnnotationName();

    @NotNull
    @Nls
    protected abstract String getFieldErrorMessage(String var1);

    @NotNull
    @Nls
    protected abstract String getClassErrorMessage(String var1);

    protected abstract boolean processMethod(@NotNull PsiMethod var1, @NotNull List<Pair<PsiField, PsiMethod>> var2, @NotNull List<Pair<PsiField, PsiMethod>> var3);

    @NotNull
    @Nls
    protected abstract String getFixName(String var1);

    @NotNull
    @Nls
    protected abstract String getFixFamilyName();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "de/plushnikov/intellij/plugin/inspection/LombokGetterOrSetterMayBeUsedInspection", "createVisitor"));
    }

    private class LombokGetterOrSetterMayBeUsedVisitor
    extends JavaElementVisitor {
        @Nullable
        private final ProblemsHolder myHolder;
        @Nullable
        private final LombokGetterOrSetterMayBeUsedFix myLombokGetterOrSetterMayBeUsedFix;

        private LombokGetterOrSetterMayBeUsedVisitor(@Nullable ProblemsHolder holder, LombokGetterOrSetterMayBeUsedFix lombokGetterOrSetterMayBeUsedFix) {
            this.myHolder = holder;
            this.myLombokGetterOrSetterMayBeUsedFix = lombokGetterOrSetterMayBeUsedFix;
        }

        public void visitJavaFile(@NotNull PsiJavaFile psiJavaFile) {
            if (psiJavaFile == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(0);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void visitClass(@NotNull PsiClass psiClass) {
            if (psiClass == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(1);
            }
            if (psiClass.isRecord()) {
                return;
            }
            ArrayList<Pair<PsiField, PsiMethod>> instanceCandidates = new ArrayList<Pair<PsiField, PsiMethod>>();
            ArrayList<Pair<PsiField, PsiMethod>> staticCandidates = new ArrayList<Pair<PsiField, PsiMethod>>();
            for (PsiMethod method : psiClass.getMethods()) {
                LombokGetterOrSetterMayBeUsedInspection.this.processMethod(method, instanceCandidates, staticCandidates);
            }
            if (!instanceCandidates.isEmpty()) {
                void var5_7;
                PsiField[] classFields = psiClass.getFields();
                boolean bl = false;
                int alreadyAnnotatedFieldsCount = 0;
                for (PsiField classField : classFields) {
                    if (classField.hasModifierProperty("static")) {
                        ++var5_7;
                        continue;
                    }
                    if (!classField.hasAnnotation(LombokGetterOrSetterMayBeUsedInspection.this.getAnnotationName())) continue;
                    ++alreadyAnnotatedFieldsCount;
                }
                if (alreadyAnnotatedFieldsCount + instanceCandidates.size() + var5_7 == classFields.length) {
                    this.warnOrFix(psiClass, instanceCandidates);
                } else {
                    for (Pair pair : instanceCandidates) {
                        this.warnOrFix((PsiField)pair.getFirst(), (PsiMethod)pair.getSecond());
                    }
                }
            }
            for (Pair pair : staticCandidates) {
                this.warnOrFix((PsiField)pair.getFirst(), (PsiMethod)pair.getSecond());
            }
        }

        public void visitMethodForFix(@NotNull PsiMethod psiMethod) {
            ArrayList<Pair<PsiField, PsiMethod>> fieldsAndMethods;
            if (psiMethod == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(2);
            }
            if (!LombokGetterOrSetterMayBeUsedInspection.this.processMethod(psiMethod, fieldsAndMethods = new ArrayList<Pair<PsiField, PsiMethod>>(), fieldsAndMethods)) {
                return;
            }
            if (!fieldsAndMethods.isEmpty()) {
                Pair psiFieldPsiMethodPair = (Pair)fieldsAndMethods.get(0);
                this.warnOrFix((PsiField)psiFieldPsiMethodPair.getFirst(), (PsiMethod)psiFieldPsiMethodPair.getSecond());
            }
        }

        private void warnOrFix(@NotNull PsiClass psiClass, @NotNull List<Pair<PsiField, PsiMethod>> fieldsAndMethods) {
            if (psiClass == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(3);
            }
            if (fieldsAndMethods == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(4);
            }
            if (this.myHolder != null) {
                String className = psiClass.getName();
                if (StringUtil.isNotEmpty((String)className)) {
                    PsiIdentifier psiClassNameIdentifier = psiClass.getNameIdentifier();
                    LombokGetterOrSetterMayBeUsedFix fix = new LombokGetterOrSetterMayBeUsedFix(className);
                    this.myHolder.registerProblem((PsiElement)psiClass, LombokGetterOrSetterMayBeUsedInspection.this.getClassErrorMessage(className), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, psiClassNameIdentifier != null ? psiClassNameIdentifier.getTextRangeInParent() : psiClass.getTextRange(), new LocalQuickFix[]{fix});
                }
            } else if (this.myLombokGetterOrSetterMayBeUsedFix != null) {
                this.myLombokGetterOrSetterMayBeUsedFix.effectivelyDoFix(psiClass, fieldsAndMethods);
            }
        }

        private void warnOrFix(@NotNull PsiField field, @NotNull PsiMethod method) {
            if (field == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(5);
            }
            if (method == null) {
                LombokGetterOrSetterMayBeUsedVisitor.$$$reportNull$$$0(6);
            }
            if (this.myHolder != null) {
                String fieldName = field.getName();
                LombokGetterOrSetterMayBeUsedFix fix = new LombokGetterOrSetterMayBeUsedFix(fieldName);
                this.myHolder.registerProblem((PsiElement)method, LombokGetterOrSetterMayBeUsedInspection.this.getFieldErrorMessage(fieldName), new LocalQuickFix[]{fix});
            } else if (this.myLombokGetterOrSetterMayBeUsedFix != null) {
                this.myLombokGetterOrSetterMayBeUsedFix.effectivelyDoFix(field, method);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiJavaFile";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiMethod";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldsAndMethods";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/LombokGetterOrSetterMayBeUsedInspection$LombokGetterOrSetterMayBeUsedVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJavaFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodForFix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warnOrFix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LombokGetterOrSetterMayBeUsedFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        private final String myText;

        private LombokGetterOrSetterMayBeUsedFix(String text) {
            if (text == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(0);
            }
            this.myText = text;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            String string = LombokGetterOrSetterMayBeUsedInspection.this.getFixName(this.myText);
            if (string == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = LombokGetterOrSetterMayBeUsedInspection.this.getFixFamilyName();
            if (string == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(4);
            }
            if (updater == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(5);
            }
            if (element instanceof PsiMethod) {
                new LombokGetterOrSetterMayBeUsedVisitor(null, this).visitMethodForFix((PsiMethod)element);
            } else if (element instanceof PsiClass) {
                new LombokGetterOrSetterMayBeUsedVisitor(null, this).visitClass((PsiClass)element);
            }
        }

        private void effectivelyDoFix(@NotNull PsiField field, @NotNull PsiMethod method) {
            PsiClass containingClass;
            if (field == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(6);
            }
            if (method == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(7);
            }
            if (null == (containingClass = field.getContainingClass()) || field.hasModifierProperty("static") || !containingClass.hasAnnotation("lombok.Data") && !containingClass.hasAnnotation("lombok.Value") && !containingClass.hasAnnotation(LombokGetterOrSetterMayBeUsedInspection.this.getAnnotationName())) {
                field.normalizeDeclaration();
                if (!this.addLombokAnnotation((PsiModifierListOwner)field)) {
                    return;
                }
            }
            this.removeMethodAndMoveJavaDoc(field, method);
        }

        public void effectivelyDoFix(@NotNull PsiClass aClass, @NotNull List<Pair<PsiField, PsiMethod>> fieldsAndMethods) {
            if (aClass == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(8);
            }
            if (fieldsAndMethods == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(9);
            }
            if (!(aClass.hasAnnotation("lombok.Data") || aClass.hasAnnotation("lombok.Value") || aClass.hasAnnotation(LombokGetterOrSetterMayBeUsedInspection.this.getAnnotationName()) || this.addLombokAnnotation((PsiModifierListOwner)aClass))) {
                return;
            }
            for (Pair<PsiField, PsiMethod> fieldAndMethod : fieldsAndMethods) {
                PsiField field = (PsiField)fieldAndMethod.getFirst();
                PsiMethod method = (PsiMethod)fieldAndMethod.getSecond();
                this.removeMethodAndMoveJavaDoc(field, method);
            }
            for (PsiField psiField : aClass.getFields()) {
                PsiAnnotation oldAnnotation;
                if (psiField.hasModifierProperty("static") || null == (oldAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, LombokGetterOrSetterMayBeUsedInspection.this.getAnnotationName())) || !oldAnnotation.getAttributes().isEmpty()) continue;
                new CommentTracker().deleteAndRestoreComments((PsiElement)oldAnnotation);
            }
        }

        private boolean addLombokAnnotation(@NotNull PsiModifierListOwner fieldOrClass) {
            PsiModifierList modifierList;
            if (fieldOrClass == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(10);
            }
            if ((modifierList = fieldOrClass.getModifierList()) == null) {
                return false;
            }
            Project project = fieldOrClass.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiAnnotation annotation = factory.createAnnotationFromText("@" + LombokGetterOrSetterMayBeUsedInspection.this.getAnnotationName(), (PsiElement)fieldOrClass);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)annotation);
            modifierList.addAfter((PsiElement)annotation, null);
            return true;
        }

        private void removeMethodAndMoveJavaDoc(@NotNull PsiField field, @NotNull PsiMethod method) {
            if (field == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(11);
            }
            if (method == null) {
                LombokGetterOrSetterMayBeUsedFix.$$$reportNull$$$0(12);
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)field.getProject());
            CommentTracker tracker = new CommentTracker();
            PsiDocComment methodJavaDoc = method.getDocComment();
            if (methodJavaDoc != null) {
                tracker.text((PsiElement)methodJavaDoc);
                PsiDocComment fieldJavaDoc = field.getDocComment();
                List<String> methodJavaDocTokens = Arrays.stream(methodJavaDoc.getChildren()).filter(e -> e instanceof PsiDocToken).map(PsiElement::getText).filter(text -> !text.matches("\\s*\\*\\s*")).toList();
                methodJavaDocTokens = methodJavaDocTokens.subList(1, methodJavaDocTokens.size() - 1);
                String javaDocMethodText = String.join((CharSequence)"\n* ", methodJavaDocTokens);
                PsiDocTag[] methodTags = methodJavaDoc.findTagsByName(LombokGetterOrSetterMayBeUsedInspection.this.getTagName());
                if (fieldJavaDoc == null) {
                    fieldJavaDoc = javaDocMethodText.isEmpty() ? factory.createDocCommentFromText("/**\n*/") : factory.createDocCommentFromText("/**\n* -- " + LombokGetterOrSetterMayBeUsedInspection.this.getJavaDocMethodMarkup() + " --\n* " + javaDocMethodText + "\n*/");
                    for (PsiDocTag methodTag : methodTags) {
                        fieldJavaDoc.add((PsiElement)methodTag);
                    }
                    field.getParent().addBefore((PsiElement)fieldJavaDoc, (PsiElement)field);
                } else {
                    @NotNull PsiElement @NotNull [] fieldJavaDocChildren = (PsiElement[])Arrays.stream(fieldJavaDoc.getChildren()).filter(e -> e instanceof PsiDocToken).toArray(PsiElement[]::new);
                    PsiElement fieldJavaDocChild = fieldJavaDocChildren[fieldJavaDocChildren.length - 2];
                    PsiDocComment newMethodJavaDoc = factory.createDocCommentFromText("/**\n* -- " + LombokGetterOrSetterMayBeUsedInspection.this.getJavaDocMethodMarkup() + " --\n* " + javaDocMethodText + "\n*/");
                    PsiElement[] tokens = newMethodJavaDoc.getChildren();
                    for (int i = tokens.length - 2; 0 < i; --i) {
                        fieldJavaDoc.addAfter(tokens[i], fieldJavaDocChild);
                    }
                    for (PsiDocTag methodTag : methodTags) {
                        fieldJavaDoc.add((PsiElement)methodTag);
                    }
                }
                methodJavaDoc.delete();
            }
            tracker.delete((PsiElement)method);
            tracker.insertCommentsBefore((PsiElement)field);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "de/plushnikov/intellij/plugin/inspection/LombokGetterOrSetterMayBeUsedInspection$LombokGetterOrSetterMayBeUsedFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 6: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldsAndMethods";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fieldOrClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "de/plushnikov/intellij/plugin/inspection/LombokGetterOrSetterMayBeUsedInspection$LombokGetterOrSetterMayBeUsedFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "effectivelyDoFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addLombokAnnotation";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "removeMethodAndMoveJavaDoc";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

