/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemProcessingSink;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.problem.ProblemValidationSink;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.processor.clazz.ClassProcessor;
import de.plushnikov.intellij.plugin.psi.LombokLightClassBuilder;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractClassProcessor
extends AbstractProcessor
implements ClassProcessor {
    protected AbstractClassProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass) {
        if (supportedClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(1);
        }
        super(supportedClass, supportedAnnotationClass);
    }

    protected AbstractClassProcessor(@NotNull Class<? extends PsiElement> supportedClass, @NotNull String supportedAnnotationClass, @NotNull String equivalentAnnotationClass) {
        if (supportedClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(2);
        }
        if (supportedAnnotationClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(3);
        }
        if (equivalentAnnotationClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(4);
        }
        super(supportedClass, supportedAnnotationClass, equivalentAnnotationClass);
    }

    @Override
    @NotNull
    public List<? super PsiElement> process(@NotNull PsiClass psiClass, @Nullable String nameHint) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(5);
        }
        List result = Collections.emptyList();
        PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, this.getSupportedAnnotationClasses());
        if (null != psiAnnotation && this.supportAnnotationVariant(psiAnnotation) && this.noHintOrPossibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation) && this.validate(psiAnnotation, psiClass, new ProblemProcessingSink())) {
            result = new ArrayList();
            this.generatePsiElements(psiClass, psiAnnotation, result, nameHint);
        }
        List list = result;
        if (list == null) {
            AbstractClassProcessor.$$$reportNull$$$0(6);
        }
        return list;
    }

    protected final boolean noHintOrPossibleToGenerateElementNamed(@Nullable String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(8);
        }
        return nameHint == null || this.possibleToGenerateElementNamed(nameHint, psiClass, psiAnnotation);
    }

    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        Collection<String> namesOfGeneratedElements;
        if (nameHint == null) {
            AbstractClassProcessor.$$$reportNull$$$0(9);
        }
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(10);
        }
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(11);
        }
        return (namesOfGeneratedElements = this.getNamesOfPossibleGeneratedElements(psiClass, psiAnnotation)).isEmpty() || namesOfGeneratedElements.contains(nameHint);
    }

    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(12);
        }
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(13);
        }
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(14);
        }
        ArrayList<PsiAnnotation> result = new ArrayList<PsiAnnotation>();
        PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, this.getSupportedAnnotationClasses());
        if (null != psiAnnotation) {
            result.add(psiAnnotation);
        }
        ArrayList<PsiAnnotation> arrayList = result;
        if (arrayList == null) {
            AbstractClassProcessor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    protected void addClassAnnotation(Collection<PsiAnnotation> result, @NotNull PsiClass psiClass, String ... annotationFQNs) {
        PsiAnnotation psiAnnotation;
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(16);
        }
        if (null != (psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, annotationFQNs))) {
            result.add(psiAnnotation);
        }
    }

    protected void addFieldsAnnotation(Collection<PsiAnnotation> result, @NotNull PsiClass psiClass, String ... annotationFQNs) {
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(17);
        }
        for (PsiField psiField : PsiClassUtil.collectClassFieldsIntern(psiClass)) {
            PsiAnnotation psiAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, annotationFQNs);
            if (null == psiAnnotation) continue;
            result.add(psiAnnotation);
        }
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(18);
        }
        Collection<LombokProblem> result = Collections.emptyList();
        PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, (Class[])new Class[]{PsiField.class, PsiRecordComponent.class, PsiMethod.class, PsiClass.class});
        if (psiElement instanceof PsiClass) {
            ProblemValidationSink problemNewBuilder = new ProblemValidationSink();
            this.validate(psiAnnotation, (PsiClass)psiElement, problemNewBuilder);
            result = problemNewBuilder.getProblems();
        }
        List<LombokProblem> list = result;
        if (list == null) {
            AbstractClassProcessor.$$$reportNull$$$0(19);
        }
        return list;
    }

    protected Optional<PsiClass> getSupportedParentClass(@NotNull PsiClass psiClass) {
        PsiElement parentElement;
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(20);
        }
        if ((parentElement = psiClass.getParent()) instanceof PsiClass && !(parentElement instanceof LombokLightClassBuilder)) {
            return Optional.of((PsiClass)parentElement);
        }
        return Optional.empty();
    }

    @Nullable
    protected PsiAnnotation getSupportedAnnotation(@NotNull PsiClass psiParentClass) {
        if (psiParentClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(21);
        }
        return PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiParentClass, this.getSupportedAnnotationClasses());
    }

    protected abstract boolean validate(@NotNull PsiAnnotation var1, @NotNull PsiClass var2, @NotNull ProblemSink var3);

    protected abstract void generatePsiElements(@NotNull PsiClass var1, @NotNull PsiAnnotation var2, @NotNull List<? super PsiElement> var3, @Nullable String var4);

    static void validateOfParam(PsiClass psiClass, ProblemSink builder, PsiAnnotation psiAnnotation, Collection<String> ofProperty) {
        for (String fieldName : ofProperty) {
            PsiField fieldByName;
            if (StringUtil.isEmptyOrSpaces((String)fieldName) || null != (fieldByName = psiClass.findFieldByName(fieldName, false))) continue;
            String newPropertyValue = AbstractClassProcessor.calcNewPropertyValue(ofProperty, fieldName);
            builder.addWarningMessage("inspection.message.field.s.does.not.exist.field", fieldName).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "of", newPropertyValue));
        }
    }

    static void validateExcludeParam(PsiClass psiClass, ProblemSink builder, PsiAnnotation psiAnnotation, Collection<String> excludeProperty) {
        for (String fieldName : excludeProperty) {
            String newPropertyValue;
            if (StringUtil.isEmptyOrSpaces((String)fieldName)) continue;
            PsiField fieldByName = psiClass.findFieldByName(fieldName, false);
            if (null == fieldByName) {
                newPropertyValue = AbstractClassProcessor.calcNewPropertyValue(excludeProperty, fieldName);
                builder.addWarningMessage("inspection.message.field.s.does.not.exist.exclude", fieldName).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", newPropertyValue));
                continue;
            }
            if (!fieldName.startsWith("$") && !fieldByName.hasModifierProperty("static")) continue;
            newPropertyValue = AbstractClassProcessor.calcNewPropertyValue(excludeProperty, fieldName);
            builder.addWarningMessage("inspection.message.field.s.would.have.been.excluded.anyway", fieldName).withLocalQuickFixes(() -> PsiQuickFixFactory.createChangeAnnotationParameterFix(psiAnnotation, "exclude", newPropertyValue));
        }
    }

    private static String calcNewPropertyValue(Collection<String> allProperties, String fieldName) {
        String result;
        block2: {
            block3: {
                result = null;
                if (allProperties.isEmpty()) break block2;
                if (allProperties.size() > 1) break block3;
                if (allProperties.contains(fieldName)) break block2;
            }
            result = allProperties.stream().filter(((Predicate<String>)fieldName::equals).negate()).collect(Collectors.joining("\",\"", "{\"", "\"}"));
        }
        return result;
    }

    boolean shouldGenerateExtraNoArgsConstructor(@NotNull PsiClass psiClass) {
        boolean result;
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(22);
        }
        boolean bl = result = !PsiClassUtil.hasSuperClass(psiClass);
        if (result) {
            result = this.configDiscovery.getBooleanLombokConfigProperty(ConfigKey.NO_ARGS_CONSTRUCTOR_EXTRA_PRIVATE, psiClass);
        }
        if (result) {
            result = PsiAnnotationSearchUtil.isNotAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.NoArgsConstructor", "lombok.AllArgsConstructor", "lombok.RequiredArgsConstructor");
        }
        return result;
    }

    boolean readCallSuperAnnotationOrConfigProperty(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ConfigKey configKey) {
        boolean result;
        Boolean declaredAnnotationValue;
        if (psiAnnotation == null) {
            AbstractClassProcessor.$$$reportNull$$$0(23);
        }
        if (psiClass == null) {
            AbstractClassProcessor.$$$reportNull$$$0(24);
        }
        if (configKey == null) {
            AbstractClassProcessor.$$$reportNull$$$0(25);
        }
        if (null == (declaredAnnotationValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(psiAnnotation, "callSuper"))) {
            String configProperty = this.configDiscovery.getStringLombokConfigProperty(configKey, psiClass);
            result = PsiClassUtil.hasSuperClass(psiClass) && "CALL".equalsIgnoreCase(configProperty);
        } else {
            result = declaredAnnotationValue;
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 15, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equivalentAnnotationClass";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/clazz/AbstractClassProcessor";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiParentClass";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/AbstractClassProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 15: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "noHintOrPossibleToGenerateElementNamed";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addClassAnnotation";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addFieldsAnnotation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedParentClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedAnnotation";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateExtraNoArgsConstructor";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readCallSuperAnnotationOrConfigProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 15, 19 -> new IllegalStateException(string);
        };
    }
}

