/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.RequiredArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokAddNullAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WitherFieldProcessor
extends AbstractFieldProcessor {
    public WitherFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.Wither", "lombok.With");
    }

    private static RequiredArgsConstructorProcessor getRequiredArgsConstructorProcessor() {
        return LombokProcessorManager.getInstance().getRequiredArgsConstructorProcessor();
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField) {
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(1);
        }
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(2);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.buildFor(psiField);
        String generatedElementName = LombokUtils.getWitherName((PsiVariable)psiField, accessorsInfo);
        return Collections.singletonList(generatedElementName);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(3);
        }
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(5);
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onParam");
        PsiClass containingClass = psiField.getContainingClass();
        boolean valid = null != containingClass;
        valid &= WitherFieldProcessor.validateVisibility(psiAnnotation);
        valid &= WitherFieldProcessor.validName(psiField, builder);
        valid &= WitherFieldProcessor.validNonStatic(psiField, builder);
        if (valid &= WitherFieldProcessor.validNonFinalInitialized(psiField, builder)) {
            valid = WitherFieldProcessor.validIsWitherUnique(psiField, builder, this.filterToleratedElements(PsiClassUtil.collectClassMethodsIntern(containingClass)));
            valid &= containingClass.hasModifierProperty("abstract") || WitherFieldProcessor.validConstructor(containingClass, builder);
        }
        return valid;
    }

    private static boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(6);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        AccessorsInfo accessorsInfo;
        PsiMethod method;
        String methodModifier;
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(7);
        }
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(8);
        }
        if (target == null) {
            WitherFieldProcessor.$$$reportNull$$$0(9);
        }
        if ((methodModifier = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null && (method = this.createWitherMethod(psiField, methodModifier, accessorsInfo = WitherFieldProcessor.buildAccessorsInfo(psiField))) != null) {
            target.add((PsiElement)method);
        }
    }

    private static boolean validName(@NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(11);
        }
        if (psiField.getName().startsWith("$")) {
            builder.addWarningMessage("inspection.message.not.generating.wither.for.this.field.withers", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean validNonStatic(@NotNull PsiField psiField, @NotNull ProblemSink builder) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(12);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(13);
        }
        if (psiField.hasModifierProperty("static")) {
            builder.addWarningMessage("inspection.message.not.generating.wither", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "static", false, false));
            return false;
        }
        return true;
    }

    private static boolean validNonFinalInitialized(@NotNull PsiField psiField, @NotNull ProblemSink builder) {
        PsiClass psiClass;
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(14);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(15);
        }
        if (null != (psiClass = psiField.getContainingClass()) && psiField.hasModifierProperty("final") && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value") && psiField.hasInitializer() && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, "lombok.Builder.Default")) {
            builder.addWarningMessage("inspection.message.not.generating.wither.for.this.field.withers.cannot.be.generated", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", false, false));
            return false;
        }
        return true;
    }

    private static boolean validIsWitherUnique(@NotNull PsiField psiField, @NotNull ProblemSink builder, @NotNull Collection<PsiMethod> existingMethods) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(16);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(17);
        }
        if (existingMethods == null) {
            WitherFieldProcessor.$$$reportNull$$$0(18);
        }
        AccessorsInfo accessorsInfo = WitherFieldProcessor.buildAccessorsInfo(psiField);
        Collection<String> possibleWitherNames = LombokUtils.toAllWitherNames(accessorsInfo, psiField.getName(), PsiTypes.booleanType().equals((Object)psiField.getType()));
        for (String witherName : possibleWitherNames) {
            if (!PsiMethodUtil.hasSimilarMethod(existingMethods, witherName, 1)) continue;
            builder.addWarningMessage("inspection.message.not.generating.s.method.with.that.name.already.exists", witherName);
            return false;
        }
        return true;
    }

    public static boolean validConstructor(@NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(19);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(20);
        }
        if (psiClass.isRecord() || PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.AllArgsConstructor", "lombok.Value", "lombok.Builder")) {
            return true;
        }
        Collection<PsiField> constructorParameters = WitherFieldProcessor.filterFields(psiClass);
        if (PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.RequiredArgsConstructor", "lombok.Data")) {
            Collection<PsiField> requiredConstructorParameters = WitherFieldProcessor.getRequiredArgsConstructorProcessor().getRequiredFields(psiClass);
            if (constructorParameters.size() == requiredConstructorParameters.size()) {
                return true;
            }
        }
        Collection<PsiMethod> classConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
        boolean constructorExists = false;
        for (PsiMethod classConstructor : classConstructors) {
            if (classConstructor.getParameterList().getParametersCount() != constructorParameters.size()) continue;
            constructorExists = true;
            break;
        }
        if (!constructorExists) {
            builder.addWarningMessage("inspection.message.wither.needs.constructor.for.all.fields.d.parameters", constructorParameters.size());
            builder.markFailed();
        }
        return constructorExists;
    }

    private static Collection<PsiField> filterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(21);
        }
        Collection<PsiField> psiFields = PsiClassUtil.collectClassFieldsIntern(psiClass);
        ArrayList<PsiField> result = new ArrayList<PsiField>(psiFields.size());
        for (PsiField classField : psiFields) {
            String classFieldName = classField.getName();
            if (classFieldName.startsWith("$") || classField.hasModifierProperty("static") || classField.hasModifierProperty("final") && classField.hasInitializer()) continue;
            result.add(classField);
        }
        return result;
    }

    @Nullable
    public PsiMethod createWitherMethod(@NotNull PsiField psiField, @NotNull String methodModifier, @NotNull AccessorsInfo accessorsInfo) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(22);
        }
        if (methodModifier == null) {
            WitherFieldProcessor.$$$reportNull$$$0(23);
        }
        if (accessorsInfo == null) {
            WitherFieldProcessor.$$$reportNull$$$0(24);
        }
        LombokLightMethodBuilder methodBuilder = null;
        PsiClass psiFieldContainingClass = psiField.getContainingClass();
        if (psiFieldContainingClass != null) {
            String witherName = LombokUtils.getWitherName((PsiVariable)psiField, accessorsInfo);
            PsiClassType returnType = PsiClassUtil.getTypeWithGenerics(psiFieldContainingClass);
            methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), witherName).withMethodReturnType((PsiType)returnType).withContainingClass(psiFieldContainingClass).withNavigationElement((PsiElement)psiField).withModifier(methodModifier).withPureContract().withWriteAccess();
            if (accessorsInfo.isMakeFinal()) {
                methodBuilder.withModifier("final");
            }
            PsiAnnotation witherAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.experimental.Wither", "lombok.With");
            LombokCopyableAnnotations.copyOnXAnnotations(witherAnnotation, (PsiModifierList)methodBuilder.getModifierList(), "onMethod");
            String psiFieldName = psiField.getName();
            PsiType psiFieldType = psiField.getType();
            LombokLightParameter methodParameter = new LombokLightParameter(psiFieldName, psiFieldType, (PsiElement)methodBuilder);
            methodBuilder.withParameter(methodParameter);
            LombokLightModifierList methodParameterModifierList = methodParameter.getModifierList();
            LombokCopyableAnnotations.copyCopyableAnnotations(psiField, methodParameterModifierList, LombokCopyableAnnotations.BASE_COPYABLE);
            LombokCopyableAnnotations.copyOnXAnnotations(witherAnnotation, (PsiModifierList)methodParameterModifierList, "onParam");
            if (psiFieldContainingClass.hasModifierProperty("abstract")) {
                methodBuilder.withModifier("abstract");
            } else {
                String paramString = WitherFieldProcessor.getConstructorCall(psiField, psiFieldContainingClass);
                String blockText = String.format("return this.%s == %s ? this : new %s(%s);", psiFieldName, psiFieldName, returnType.getCanonicalText(), paramString);
                methodBuilder.withBodyText(blockText);
            }
            LombokAddNullAnnotations.createRelevantNonNullAnnotation(psiFieldContainingClass, methodBuilder);
        }
        return methodBuilder;
    }

    private static AccessorsInfo buildAccessorsInfo(@NotNull PsiField psiField) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(25);
        }
        return AccessorsInfo.buildFor(psiField).withFluent(false);
    }

    private static String getConstructorCall(@NotNull PsiField psiField, @NotNull PsiClass psiClass) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(26);
        }
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(27);
        }
        StringBuilder paramString = new StringBuilder();
        Collection<PsiField> psiFields = WitherFieldProcessor.filterFields(psiClass);
        for (PsiField classField : psiFields) {
            String classFieldName = classField.getName();
            if (classField.equals(psiField)) {
                paramString.append(classFieldName);
            } else {
                paramString.append("this.").append(classFieldName);
            }
            paramString.append(',');
        }
        if (paramString.length() > 1) {
            paramString.deleteCharAt(paramString.length() - 1);
        }
        return paramString.toString();
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(28);
        }
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(29);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 22: 
            case 25: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 5: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMethods";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsInfo";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/WitherFieldProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateVisibility";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "validName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "validNonStatic";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "validNonFinalInitialized";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "validIsWitherUnique";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "validConstructor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "filterFields";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "createWitherMethod";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAccessorsInfo";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstructorCall";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

