/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.method;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.psi.LombokExtensionMethod;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtensionMethodsHelper {
    private static final Logger LOG = Logger.getInstance(ExtensionMethodsHelper.class);

    public static List<PsiExtensionMethod> getExtensionMethods(@NotNull PsiClass targetClass, @NotNull String nameHint, @NotNull PsiElement place) {
        if (targetClass == null) {
            ExtensionMethodsHelper.$$$reportNull$$$0(0);
        }
        if (nameHint == null) {
            ExtensionMethodsHelper.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ExtensionMethodsHelper.$$$reportNull$$$0(2);
        }
        if (!(place instanceof PsiMethodCallExpression)) {
            return Collections.emptyList();
        }
        PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)place).getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression == null || !nameHint.equals(methodExpression.getReferenceName()) || qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        @Nullable PsiClass context = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{PsiClass.class});
        while (context != null) {
            @Nullable PsiAnnotation annotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)context, "lombok.experimental.ExtensionMethod");
            if (annotation != null) {
                Set<PsiClass> providers = PsiAnnotationUtil.getAnnotationValues(annotation, "value", PsiType.class, List.of()).stream().filter(PsiClassType.class::isInstance).map(PsiClassType.class::cast).map(PsiClassType::resolve).filter(Objects::nonNull).collect(Collectors.toSet());
                if (!providers.isEmpty()) {
                    List<PsiExtensionMethod> extensionMethods = ExtensionMethodsHelper.collectExtensionMethods(providers, (PsiMethodCallExpression)place, targetClass);
                    extensionMethods.stream().map(method -> MethodSignatureBackedByPsiMethod.create((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY)).distinct().filter(methodSignature -> !targetClass.getVisibleSignatures().contains(methodSignature)).forEach(arg_0 -> ExtensionMethodsHelper.lambda$getExtensionMethods$2((List)result, arg_0));
                }
            }
            context = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)context, (Class[])new Class[]{PsiClass.class});
        }
        return result;
    }

    private static List<PsiExtensionMethod> collectExtensionMethods(Set<PsiClass> providers, PsiMethodCallExpression callExpression, PsiClass targetClass) {
        ArrayList<PsiExtensionMethod> psiMethods = new ArrayList<PsiExtensionMethod>();
        providers.forEach(providerClass -> ExtensionMethodsHelper.providerData(providerClass).forEach(function -> ContainerUtil.addIfNotNull((Collection)psiMethods, (Object)((PsiExtensionMethod)function.apply(targetClass, callExpression)))));
        return psiMethods;
    }

    public static List<BiFunction<PsiClass, PsiMethodCallExpression, PsiExtensionMethod>> providerData(PsiClass providerClass) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)providerClass, () -> CachedValueProvider.Result.create(ExtensionMethodsHelper.createProviderCandidates(providerClass), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static List<BiFunction<PsiClass, PsiMethodCallExpression, PsiExtensionMethod>> createProviderCandidates(PsiClass providerClass) {
        ArrayList<BiFunction<PsiClass, PsiMethodCallExpression, PsiExtensionMethod>> result = new ArrayList<BiFunction<PsiClass, PsiMethodCallExpression, PsiExtensionMethod>>();
        for (PsiMethod providerStaticMethod : PsiClassUtil.collectClassStaticMethodsIntern(providerClass)) {
            PsiParameter[] parameters;
            if (!providerStaticMethod.hasModifierProperty("public") || (parameters = providerStaticMethod.getParameterList().getParameters()).length <= 0 || parameters[0].getType() instanceof PsiPrimitiveType) continue;
            result.add((targetClass, call) -> ExtensionMethodsHelper.createLightMethodBySignature(providerStaticMethod, targetClass, call));
        }
        return result;
    }

    private static PsiExtensionMethod createLightMethodBySignature(PsiMethod staticMethod, PsiClass targetClass, PsiMethodCallExpression callExpression) {
        PsiClassType[] thrownTypes;
        PsiMethodCallExpression staticMethodCall;
        if (!staticMethod.getName().equals(callExpression.getMethodExpression().getReferenceName())) {
            return null;
        }
        PsiClass providerClass = Objects.requireNonNull(staticMethod.getContainingClass());
        try {
            StringBuilder args = new StringBuilder(Objects.requireNonNull(callExpression.getMethodExpression().getQualifierExpression()).getText());
            Object[] expressions = callExpression.getArgumentList().getExpressions();
            if (expressions.length > 0) {
                args.append(", ");
            }
            args.append(StringUtil.join((Object[])expressions, expression -> expression.getText(), (String)","));
            staticMethodCall = (PsiMethodCallExpression)JavaPsiFacade.getElementFactory((Project)staticMethod.getProject()).createExpressionFromText(providerClass.getQualifiedName() + "." + staticMethod.getName() + "(" + String.valueOf(args) + ")", (PsiElement)callExpression);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
        JavaResolveResult result = staticMethodCall.resolveMethodGenerics();
        if (!(result instanceof MethodCandidateInfo)) {
            return null;
        }
        PsiMethod method = ((MethodCandidateInfo)result).getElement();
        if (!method.equals(staticMethod) || !((MethodCandidateInfo)result).isApplicable()) {
            return null;
        }
        PsiSubstitutor substitutor = result.getSubstitutor();
        LombokExtensionMethod lightMethod = new LombokExtensionMethod(staticMethod);
        lightMethod.addModifiers(new String[]{"public"});
        PsiParameter @NotNull [] parameters = staticMethod.getParameterList().getParameters();
        if (targetClass.isInterface()) {
            lightMethod.addModifier("default");
        }
        lightMethod.setMethodReturnType(substitutor.substitute(staticMethod.getReturnType()));
        int length = parameters.length;
        for (int i = 1; i < length; ++i) {
            PsiParameter parameter = parameters[i];
            LombokLightParameter lombokLightParameter = new LombokLightParameter(parameter.getName(), substitutor.substitute(parameter.getType()), (PsiElement)lightMethod, (Language)JavaLanguage.INSTANCE);
            lombokLightParameter.setParent((PsiElement)lightMethod);
            lightMethod.addParameter((PsiParameter)lombokLightParameter);
        }
        for (PsiClassType thrownType : thrownTypes = staticMethod.getThrowsList().getReferencedTypes()) {
            lightMethod.addException((PsiClassType)substitutor.substitute((PsiType)thrownType));
        }
        Object[] staticMethodTypeParameters = staticMethod.getTypeParameters();
        HashSet initialTypeParameters = ContainerUtil.newHashSet((Object[])staticMethodTypeParameters);
        Arrays.stream(staticMethodTypeParameters).filter(typeParameter -> PsiTypesUtil.mentionsTypeParameters((PsiType)substitutor.substitute(typeParameter), (Set)initialTypeParameters)).forEach(lightMethod::addTypeParameter);
        lightMethod.setNavigationElement((PsiElement)staticMethod);
        lightMethod.setContainingClass(targetClass);
        return lightMethod;
    }

    private static /* synthetic */ void lambda$getExtensionMethods$2(List result, MethodSignatureBackedByPsiMethod methodSignature) {
        result.add((PsiExtensionMethod)methodSignature.getMethod());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "targetClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "nameHint";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "place";
                break;
            }
        }
        objectArray[1] = "de/plushnikov/intellij/plugin/processor/method/ExtensionMethodsHelper";
        objectArray[2] = "getExtensionMethods";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

