/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler.ui;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.lineProfiler.data.LinesGroup;
import com.intellij.profiler.lineProfiler.ui.LineMarker;
import com.intellij.profiler.lineProfiler.ui.LineTooltip;
import com.intellij.profiler.lineProfiler.ui.NavigationPopup;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\rJ\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u0017J\u0016\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0017J-\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/profiler/lineProfiler/ui/HighlighterState;", "", "lines", "Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "<init>", "(Lcom/intellij/profiler/lineProfiler/data/LinesGroup;)V", "getLines", "()Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "selectedInternal", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "canShowTooltip", "", "getCanShowTooltip", "()Z", "setCanShowTooltip", "(Z)V", "tooltip", "Lcom/intellij/profiler/lineProfiler/ui/LineTooltip;", "navigationPopup", "Lcom/intellij/profiler/lineProfiler/ui/NavigationPopup;", "setSelected", "", "line", "level", "selected", "isSelected", "hideToolTip", "showToolTip", "e", "Ljava/awt/event/MouseEvent;", "hideNavigationPopup", "showNavigationPopup", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "marker", "Lcom/intellij/profiler/lineProfiler/ui/LineMarker;", "showNavigationPopup$intellij_profiler_lineProfiler", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nLineHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineHighlighter.kt\ncom/intellij/profiler/lineProfiler/ui/HighlighterState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,371:1\n1#2:372\n*E\n"})
public final class HighlighterState {
    @NotNull
    private final LinesGroup lines;
    @NotNull
    private final HashMap<Integer, Integer> selectedInternal;
    private boolean canShowTooltip;
    @Nullable
    private LineTooltip tooltip;
    @Nullable
    private NavigationPopup navigationPopup;

    public HighlighterState(@NotNull LinesGroup lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        this.lines = lines;
        this.selectedInternal = new HashMap();
        this.canShowTooltip = true;
    }

    @NotNull
    public final LinesGroup getLines() {
        return this.lines;
    }

    public final boolean getCanShowTooltip() {
        return this.canShowTooltip;
    }

    public final void setCanShowTooltip(boolean bl) {
        this.canShowTooltip = bl;
    }

    public final void setSelected(int line, int level, boolean selected) {
        if (line < 0) {
            return;
        }
        Integer n = this.selectedInternal.getOrDefault(line, 0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
        int current = ((Number)n).intValue();
        ((Map)this.selectedInternal).put(line, selected ? current | level : current & ~level);
    }

    public final boolean isSelected(int line) {
        boolean bl;
        Integer n = this.selectedInternal.get(line);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it > 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void hideToolTip() {
        LineTooltip lineTooltip = this.tooltip;
        if (lineTooltip != null) {
            lineTooltip.hide();
        }
        this.tooltip = null;
    }

    public final void showToolTip(int line, @NotNull MouseEvent e) {
        LineTooltip lineTooltip;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LineTooltip current = this.tooltip;
        if (current != null && current.getLine() != line) {
            this.hideToolTip();
        }
        if ((lineTooltip = this.tooltip) == null) {
            LineTooltip lineTooltip2;
            LineTooltip it = lineTooltip2 = new LineTooltip(line, this.lines);
            boolean bl = false;
            this.tooltip = it;
            lineTooltip = lineTooltip2;
        }
        LineTooltip tooltip = lineTooltip;
        tooltip.show(e);
    }

    public final void hideNavigationPopup() {
        ActionsKt.runInEdt$default(null, () -> HighlighterState.hideNavigationPopup$lambda$2(this), (int)1, null);
    }

    public final void showNavigationPopup$intellij_profiler_lineProfiler(int line, @NotNull Project project, @NotNull Editor editor, @NotNull LineMarker marker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        this.canShowTooltip = false;
        this.hideNavigationPopup();
        NavigationPopup popup = new NavigationPopup(line, project, this);
        ActionsKt.runInEdt$default(null, () -> HighlighterState.showNavigationPopup$lambda$3(this, popup, marker, editor), (int)1, null);
    }

    private static final Unit hideNavigationPopup$lambda$2(HighlighterState this$0) {
        NavigationPopup navigationPopup = this$0.navigationPopup;
        if (navigationPopup != null) {
            navigationPopup.hide();
        }
        this$0.navigationPopup = null;
        return Unit.INSTANCE;
    }

    private static final Unit showNavigationPopup$lambda$3(HighlighterState this$0, NavigationPopup $popup, LineMarker $marker, Editor $editor) {
        this$0.navigationPopup = $popup;
        EditorGutter editorGutter = $editor.getGutter();
        Intrinsics.checkNotNull((Object)editorGutter, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        $popup.show($marker, (EditorGutterComponentEx)editorGutter);
        return Unit.INSTANCE;
    }
}

