/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javaee.model.JpsApplicationServersTable;
import org.jetbrains.jps.javaee.model.JpsJavaeeExtensionReference;
import org.jetbrains.jps.javaee.model.JpsJavaeeExtensionService;
import org.jetbrains.jps.javaee.model.JpsJavaeeFacetClassesPackagingElement;
import org.jetbrains.jps.javaee.model.JpsJavaeeFacetResourcesPackagingElement;
import org.jetbrains.jps.javaee.model.app.EarArtifactType;
import org.jetbrains.jps.javaee.model.app.impl.JpsJavaeeAppModuleExtensionSerializer;
import org.jetbrains.jps.javaee.model.ejb.EjbArtifactType;
import org.jetbrains.jps.javaee.model.ejb.impl.JpsEjbModuleExtensionSerializer;
import org.jetbrains.jps.javaee.model.impl.JpsApplicationServersTableReference;
import org.jetbrains.jps.javaee.model.impl.JpsJavaeeModuleExtensionSerializerBase;
import org.jetbrains.jps.javaee.model.web.WebArtifactType;
import org.jetbrains.jps.javaee.model.web.impl.JpsWebModuleExtensionSerializer;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.serialization.JpsGlobalExtensionSerializer;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.JpsPathMapper;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactDummyPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactPropertiesSerializer;
import org.jetbrains.jps.model.serialization.artifact.JpsPackagingElementSerializer;
import org.jetbrains.jps.model.serialization.facet.JpsFacetConfigurationSerializer;
import org.jetbrains.jps.model.serialization.library.JpsLibraryTableSerializer;

public class JpsJavaeeModelSerializerExtension
extends JpsModelSerializerExtension {
    private static final String APP_SERVER_LIBRARIES_LEVEL = "application_server_libraries";

    public JpsElementReference<? extends JpsCompositeElement> createLibraryTableReference(String tableLevel) {
        if (tableLevel.equals(APP_SERVER_LIBRARIES_LEVEL)) {
            return JpsJavaeeExtensionService.getInstance().createApplicationServersTableReference();
        }
        return null;
    }

    public String getLibraryTableLevelId(JpsElementReference<? extends JpsCompositeElement> reference) {
        if (reference instanceof JpsApplicationServersTableReference) {
            return APP_SERVER_LIBRARIES_LEVEL;
        }
        return null;
    }

    @NotNull
    public List<? extends JpsFacetConfigurationSerializer<?>> getFacetConfigurationSerializers() {
        List<JpsJavaeeModuleExtensionSerializerBase> list = Arrays.asList(new JpsJavaeeModuleExtensionSerializerBase[]{new JpsWebModuleExtensionSerializer(), new JpsEjbModuleExtensionSerializer(), new JpsJavaeeAppModuleExtensionSerializer()});
        if (list == null) {
            JpsJavaeeModelSerializerExtension.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsGlobalExtensionSerializer> getGlobalExtensionSerializers() {
        List<ApplicationServersSerializer> list = Collections.singletonList(new ApplicationServersSerializer());
        if (list == null) {
            JpsJavaeeModelSerializerExtension.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsPackagingElementSerializer<?>> getPackagingElementSerializers() {
        List<JpsPackagingElementSerializer> list = Arrays.asList(new JpsPackagingElementSerializer[]{new JpsJavaeeFacetResourcesPackagingElementSerializer(), new JpsJavaeeFacetClassesPackagingElementSerializer()});
        if (list == null) {
            JpsJavaeeModelSerializerExtension.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public List<? extends JpsArtifactPropertiesSerializer<?>> getArtifactTypePropertiesSerializers() {
        List<JpsArtifactDummyPropertiesSerializer> list = Arrays.asList(new JpsArtifactDummyPropertiesSerializer("exploded-war", (JpsArtifactType)WebArtifactType.EXPLODED), new JpsArtifactDummyPropertiesSerializer("war", (JpsArtifactType)WebArtifactType.WAR), new JpsArtifactDummyPropertiesSerializer("exploded-ejb", (JpsArtifactType)EjbArtifactType.EXPLODED), new JpsArtifactDummyPropertiesSerializer("ejb-jar", (JpsArtifactType)EjbArtifactType.JAR), new JpsArtifactDummyPropertiesSerializer("exploded-ear", (JpsArtifactType)EarArtifactType.EXPLODED), new JpsArtifactDummyPropertiesSerializer("ear", (JpsArtifactType)EarArtifactType.EAR));
        if (list == null) {
            JpsJavaeeModelSerializerExtension.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/jps/javaee/model/impl/JpsJavaeeModelSerializerExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetConfigurationSerializers";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalExtensionSerializers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagingElementSerializers";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactTypePropertiesSerializers";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class ApplicationServersSerializer
    extends JpsGlobalExtensionSerializer {
        private ApplicationServersSerializer() {
            super("javaeeAppServers.xml", "AppserversManager");
        }

        public void loadExtension(@NotNull JpsGlobal element, @NotNull Element componentTag) {
            Element libraryTable;
            if (element == null) {
                ApplicationServersSerializer.$$$reportNull$$$0(0);
            }
            if (componentTag == null) {
                ApplicationServersSerializer.$$$reportNull$$$0(1);
            }
            if ((libraryTable = componentTag.getChild("LibraryTable")) != null) {
                JpsApplicationServersTable serversTable = JpsJavaeeExtensionService.getInstance().getOrCreateApplicationServersTable(element);
                JpsLibraryTableSerializer.loadLibraries((Element)libraryTable, (JpsPathMapper)element.getPathMapper(), (JpsLibraryCollection)serversTable.getLibraryCollection());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "componentTag";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/jps/javaee/model/impl/JpsJavaeeModelSerializerExtension$ApplicationServersSerializer";
            objectArray[2] = "loadExtension";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class JpsJavaeeFacetResourcesPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsJavaeeFacetResourcesPackagingElement> {
        private JpsJavaeeFacetResourcesPackagingElementSerializer() {
            super("javaee-facet-resources", JpsJavaeeFacetResourcesPackagingElement.class);
        }

        public JpsJavaeeFacetResourcesPackagingElement load(Element element) {
            String facetId = element.getAttributeValue("facet");
            return JpsJavaeeExtensionService.getInstance().createFacetResourcesPackagingElement(JpsJavaeeExtensionService.getInstance().createReference(facetId));
        }
    }

    private static final class JpsJavaeeFacetClassesPackagingElementSerializer
    extends JpsPackagingElementSerializer<JpsJavaeeFacetClassesPackagingElement> {
        private JpsJavaeeFacetClassesPackagingElementSerializer() {
            super("javaee-facet-classes", JpsJavaeeFacetClassesPackagingElement.class);
        }

        public JpsJavaeeFacetClassesPackagingElement load(Element element) {
            String facetId = element.getAttributeValue("facet");
            JpsJavaeeExtensionReference reference = JpsJavaeeExtensionService.getInstance().createReference(facetId);
            return JpsJavaeeExtensionService.getInstance().createFacetClassesPackagingElement(reference);
        }
    }
}

