/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.Objects;

public abstract class ExampleSentence {
    protected final String example;

    public ExampleSentence(String example) {
        this.example = Objects.requireNonNull(example);
        int markerStart = example.indexOf("<marker>");
        int markerEnd = example.indexOf("</marker>");
        if (markerStart != -1 && markerEnd == -1) {
            throw new IllegalArgumentException("Example contains <marker> but lacks </marker>:" + example);
        }
        if (markerStart == -1 && markerEnd != -1) {
            throw new IllegalArgumentException("Example contains </marker> but lacks <marker>:" + example);
        }
        if (markerStart > markerEnd) {
            throw new IllegalArgumentException("Example <marker> comes before </marker>:" + example);
        }
    }

    public static String cleanMarkersInExample(String str) {
        return str.replace("<marker>", "").replace("</marker>", "");
    }

    public String getExample() {
        return this.example;
    }

    public String toString() {
        return this.example;
    }
}

