/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomHtmlElementIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspectionBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssReplaceHtmlTagReferenceWithSelectorSuffixIntentionAction;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public final class CssInvalidHtmlTagReferenceInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidHtmlTagReferenceInspection.$$$reportNull$$$0(0);
        }
        return new UnknownTagVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssInvalidHtmlTagReferenceInspection", "buildVisitor"));
    }

    private static class UnknownTagVisitor
    extends CssElementVisitor {
        private final ProblemsHolder myHolder;

        UnknownTagVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitCssSelector(CssSelector selector) {
        }

        @Override
        public void visitCssSimpleSelector(CssSimpleSelector selector) {
            String tagName = selector.getElementName();
            PsiElement element = selector.getNameIdentifier();
            if (element == null || CssUtil.containsStrangeCharacter(tagName) || tagName.isEmpty()) {
                return;
            }
            if (!CssDescriptorsUtil.isPossibleSelector(tagName, selector)) {
                String message = CssBundle.message("css.selector.matches.unknown.element", tagName);
                ArrayList<LocalQuickFix> quickFixes = new ArrayList<LocalQuickFix>(CssDescriptorsUtil.getQuickFixesForUnknownSimpleSelector(tagName, selector, this.myHolder.isOnTheFly()));
                quickFixes.add((LocalQuickFix)new AddCustomHtmlElementIntentionAction(HtmlUnknownTagInspectionBase.TAG_KEY, tagName, XmlAnalysisBundle.message((String)"html.quickfix.add.custom.html.tag", (Object[])new Object[]{tagName})));
                quickFixes.add(new CssReplaceHtmlTagReferenceWithSelectorSuffixIntentionAction(tagName, CssSelectorSuffixType.ID));
                quickFixes.add(new CssReplaceHtmlTagReferenceWithSelectorSuffixIntentionAction(tagName, CssSelectorSuffixType.CLASS));
                LocalQuickFix[] fixes = quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                this.myHolder.registerProblem(element, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
            }
        }
    }
}

