/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.el.providers;

import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.ElLiteralCustomReferenceProvider;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELLiteralExpression;
import com.intellij.javaee.el.psi.ELSliceExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.references.ELJavaTypeReference;
import com.intellij.javaee.el.references.VariableELReference;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;

public final class ElReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            ElReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(ELExpression.class), new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (element instanceof ELVariable) {
                    PsiElement parent = element.getParent();
                    if (!(parent instanceof ELFunctionCallExpression)) {
                        PsiReference[] psiReferenceArray = new PsiReference[1];
                        VariableELReference variableELReference = psiReferenceArray[0] = ElReferenceContributor.isJavaTypeReference(element) ? new ELJavaTypeReference((ELExpression)element) : new VariableELReference((ELExpression)element);
                        if (psiReferenceArray == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return psiReferenceArray;
                    }
                } else if (element instanceof ELLiteralExpression) {
                    PsiReference[] psiReferenceArray = ElReferenceContributor.getLiteralExpressionReferences((ELLiteralExpression)element);
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javaee/el/providers/ElReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javaee/el/providers/ElReferenceContributor$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4 -> new IllegalStateException(string);
                };
            }
        });
    }

    private static boolean isJavaTypeReference(PsiElement element) {
        PsiJavaFile javaFile = (PsiJavaFile)element.getContainingFile().getViewProvider().getPsi((Language)JavaLanguage.INSTANCE);
        if (javaFile == null) {
            return false;
        }
        PsiImportList importList = javaFile.getImportList();
        if (importList == null) {
            return false;
        }
        return ContainerUtil.exists((Object[])importList.getImportStatements(), it -> {
            String name = it.getQualifiedName();
            return name != null && name.endsWith(element.getText());
        });
    }

    private static PsiReference[] getLiteralExpressionReferences(ELLiteralExpression expression) {
        if (ElReferenceContributor.isStringLiteralExpression(expression)) {
            for (ElLiteralCustomReferenceProvider provider : ElLiteralCustomReferenceProvider.EP_NAME.getExtensionList()) {
                if (!provider.accept(expression)) continue;
                return provider.createReferences(expression);
            }
        }
        PsiElement parent = expression.getParent();
        ELSliceExpression sliceParent = null;
        while (!(parent instanceof ELExpressionHolder)) {
            if (parent instanceof ELSliceExpression) {
                sliceParent = (ELSliceExpression)parent;
                break;
            }
            if (parent instanceof ELExpression) break;
            parent = parent.getParent();
        }
        if (sliceParent != null && expression.getText().length() > 2) {
            VariableELReference elReference = new VariableELReference(expression);
            return new PsiReference[]{elReference};
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isStringLiteralExpression(ELLiteralExpression expression) {
        return expression.getTypeClass() == String.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javaee/el/providers/ElReferenceContributor", "registerReferenceProviders"));
    }
}

