/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions.diagnostic;

import com.intellij.database.ConnDatabaseNotifications;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.dataSource.DataSourceModelStorageImpl;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.BasicPaths;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class PrepareIntrospectionDiagnostic
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PrepareIntrospectionDiagnostic.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PrepareIntrospectionDiagnostic.$$$reportNull$$$0(1);
        }
        @NotNull DataContext dataContext = e.getDataContext();
        JBIterable<DbElement> selected = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext);
        e.getPresentation().setEnabledAndVisible(selected.isNotEmpty());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DataContext dataContext;
        JBIterable<DbElement> selected;
        DbDataSource dataSource;
        if (e == null) {
            PrepareIntrospectionDiagnostic.$$$reportNull$$$0(2);
        }
        if ((dataSource = (DbDataSource)(selected = DatabaseContextFun.getSelectedDbElementsExpandingGroups(dataContext = e.getDataContext())).map(DbElement::getDataSource).unique().single()) == null) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.single", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
            return;
        }
        LocalDataSource lds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)dataSource);
        if (lds == null) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.database", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
            return;
        }
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)lds.getModel(), BasicModModel.class);
        if (model == null) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.introspected", (Object[])new Object[0]), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
            return;
        }
        Set elements = selected.map(DbElement::getDelegate).filterMap(d -> {
            BasicElement basicElement;
            if (d instanceof LocalDataSource) {
                @NotNull LocalDataSource source = (LocalDataSource)d;
                DasModel patt4675$temp = source.getModel();
                if (patt4675$temp instanceof BasicModModel) {
                    BasicModModel modModel = (BasicModModel)patt4675$temp;
                    basicElement = modModel.getRoot();
                } else {
                    basicElement = null;
                }
            } else {
                basicElement = (BasicElement)ObjectUtils.tryCast((Object)d, BasicElement.class);
            }
            return basicElement;
        }).toSet();
        final Ref res2 = Ref.create();
        try {
            File dir = FileUtil.createTempDirectory((String)"introspection-diagnostic", (String)("-" + dataSource.getName()), (boolean)true);
            res2.set((Object)new File(dir, "dataSource.txt"));
            PrepareIntrospectionDiagnostic.writeDataSourceInfo(lds, (File)res2.get());
            PrepareIntrospectionDiagnostic.serialise(lds, model, elements, new File(dir, "model.xml"));
            this.writeIntrospectorInfo(dataSource.getProject(), lds, elements, new File(dir, "introspector.txt"));
            RevealFileAction.openFile((File)((File)res2.get()));
        }
        catch (Throwable th) {
            JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(StringUtil.notNullize((String)th.getMessage(), (String)th.getClass().getSimpleName()), MessageType.ERROR, null).createBalloon().show(JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext()), Balloon.Position.above);
        }
        ConnDatabaseNotifications.DATABASE_VIEW_GROUP().createNotification(DatabaseBundle.message((String)"action.DatabaseView.Tools.PrepareIntrospectionDiagnostic.collected", (Object[])new Object[0]), "<a href=\"view\">" + ((File)res2.get()).getParentFile().getAbsolutePath() + "</a>", NotificationType.INFORMATION).setListener((NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                RevealFileAction.openFile((File)((File)res2.get()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/database/actions/diagnostic/PrepareIntrospectionDiagnostic$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).setDisplayId("PrepareIntrospectionDiagnostic.finished").notify(dataSource.getProject());
    }

    protected void writeIntrospectorInfo(Project project, LocalDataSource lds, Set<BasicElement> elements, File file) {
        SearchPath path = ObjectPaths.searchPathOf((DasObject)((DasObject)ContainerUtil.getFirstItem(elements)));
        DatabaseSessionManager.getFacade(project, (DatabaseConnectionPoint)lds, DatabaseCredentials.getInstance(), path, false, new ErrorHandler(), (DatabaseDepartment)DGDepartment.INTROSPECTION).runSync(connection2 -> {
            DBIntrospector introspector = DBIntrospectorFactory.createIntrospector((Project)project, (ModelFactory)ModelFactory.BLACK_HOLE, (LocalDataSource)lds);
            try {
                introspector.attachToDB((DatabaseConnectionCore)connection2);
                String info2 = introspector.collectDiagnosticInfo((Iterable)elements);
                if (info2 != null) {
                    try {
                        FileUtil.writeToFile((File)file, (String)info2);
                    }
                    catch (IOException exception) {
                        ExceptionUtil.rethrow((Throwable)exception);
                    }
                }
            }
            finally {
                introspector.detachFromDB();
            }
            return null;
        });
    }

    private static void writeDataSourceInfo(LocalDataSource dataSource, File file) throws IOException {
        try (PrintWriter p2 = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));){
            p2.println(DataSourceUtil.formatDataSourceInfoString(dataSource));
            p2.println("JDBC Introspector: " + dataSource.useJdbcIntrospector());
            p2.print("Driver properties set: " + StringUtil.join(dataSource.getDriverProperties().keySet(), (String)", "));
            DatabaseDriver driver = dataSource.getDatabaseDriver();
            if (driver != null) {
                p2.println("Driver id: " + driver.getId());
                p2.println("Class" + driver.getDriverClass());
                for (DatabaseDriver.ArtifactRef artifact : driver.getArtifacts()) {
                    p2.println("Artifact: " + artifact.getId() + ":" + String.valueOf(artifact.getArtifactVersion()) + "[" + artifact.getChannel() + "]");
                }
                for (SimpleClasspathElement element : driver.getAdditionalClasspathElements()) {
                    for (String url : element.getClassesRootUrls()) {
                        p2.println("Lib: " + url);
                    }
                }
                for (SimpleClasspathElement element : driver.getNativeLibraryPaths()) {
                    for (String url : element.getClassesRootUrls()) {
                        p2.println("Native Lib: " + url);
                    }
                }
            }
        }
    }

    private static void serialise(LocalDataSource dataSource, BasicModModel model, Set<BasicElement> elements, File file) throws IOException {
        BasicModModel target = PrepareIntrospectionDiagnostic.retainedModel(model, elements);
        DataSourceModelStorageImpl.Companion.writeModel(file, (DasModel)target, dataSource.getName(), dataSource.getIntrospectionScope());
    }

    @NotNull
    static BasicModModel retainedModel(BasicModModel model, Set<BasicElement> elements) {
        Set paths = ContainerUtil.map2Set(elements, BasicPaths::of);
        BasicModModel target = ModelLightCopier.copy((BasicModel)model, (ModelFactory)ModelFactory.BLACK_HOLE, (boolean)false, (boolean)false);
        target.modify(BasicModRoot.class, r -> PrepareIntrospectionDiagnostic.retain((BasicModElement)r, paths));
        BasicModModel basicModModel = target;
        if (basicModModel == null) {
            PrepareIntrospectionDiagnostic.$$$reportNull$$$0(3);
        }
        return basicModModel;
    }

    private static boolean retain(BasicModElement node, Set<ObjectPath> paths) {
        if (paths.contains(BasicPaths.of((BasicElement)node))) {
            return true;
        }
        for (ModFamily f : node.getFamilies()) {
            f.remove(c2 -> !PrepareIntrospectionDiagnostic.retain(c2, paths));
        }
        return node.hasChildren();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/diagnostic/PrepareIntrospectionDiagnostic";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/diagnostic/PrepareIntrospectionDiagnostic";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "retainedModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

