/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.AttachFailedException;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.Attached;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerErrorWithContext;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.api.ReadingData;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.ultimate.AttachFailed;
import com.intellij.profiler.ultimate.AttachResult;
import com.intellij.profiler.ultimate.AttachedToAlreadyRunningProcessCommunicator;
import com.intellij.profiler.ultimate.Canceled;
import com.intellij.profiler.ultimate.JavaProfilerErrorContext;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.JavaProfilerTroubleshooter;
import com.intellij.profiler.ultimate.NativeAgentAttachKt;
import com.intellij.profiler.ultimate.ProfilerProcessCommunicator;
import com.intellij.profiler.ultimate.Success;
import com.intellij.profiler.ultimate.TimeOut;
import com.intellij.profiler.ultimate.VMAgentAttachKt;
import com.intellij.profiler.ultimate.async.AgentConfiguration;
import com.intellij.profiler.ultimate.async.configurations.AgentOptions;
import com.intellij.profiler.ultimate.async.extractor.AsyncProfilerExtractor;
import com.intellij.profiler.ultimate.async.troubleshooting.AsyncProfilerTroubleshooter;
import com.intellij.profiler.ultimate.async.troubleshooting.report.LogErrorAsyncProfilerErrorReporter;
import com.intellij.profiler.ultimate.async.troubleshooting.report.StatisticsAsyncProfilerErrorReporter;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import sun.tools.attach.HotSpotVirtualMachine;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 6*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00016B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001dH\u0014J$\u0010#\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001d2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020&0%H\u0014J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\rH\u0016JH\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u001d2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020,2\u000e\b\u0002\u0010.\u001a\b\u0012\u0004\u0012\u00020&0/2\u0014\b\u0002\u00100\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020&0%H\u0002J\b\u00101\u001a\u00020&H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u00102\u001a\u000203X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess;", "TargetProcess", "Lcom/intellij/profiler/api/ProfilerTargetProcess;", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "project", "Lcom/intellij/openapi/project/Project;", "communicator", "Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "agentConfiguration", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "attachedTimestamp", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/profiler/ultimate/ProfilerProcessCommunicator;Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;Lcom/intellij/profiler/ultimate/async/AgentConfiguration;J)V", "getProfilerConfiguration", "()Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "getAgentConfiguration$intellij_profiler_ultimate", "()Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "getAttachedTimestamp", "()J", "troubleshooter", "Lcom/intellij/profiler/ultimate/JavaProfilerTroubleshooter;", "getTroubleshooter", "()Lcom/intellij/profiler/ultimate/JavaProfilerTroubleshooter;", "tryReopenDump", "", "attempts", "", "waitBetweenAttemptsMs", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doStop", "targetProcessId", "doSuspend", "onSuspend", "Lkotlin/Function1;", "", "doResume", "threadId", "executeStop", "pid", "oldState", "Lcom/intellij/profiler/api/ProfilerState;", "newState", "beforeCommand", "Lkotlin/Function0;", "afterCommand", "onTerminateCalled", "helpId", "", "getHelpId", "()Ljava/lang/String;", "Companion", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nAsyncProfilerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AsyncProfilerProcess.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,256:1\n24#2:257\n24#2:258\n24#2:259\n24#2:260\n14#2:261\n*S KotlinDebug\n*F\n+ 1 AsyncProfilerProcess.kt\ncom/intellij/profiler/ultimate/async/AsyncProfilerProcess\n*L\n99#1:257\n105#1:258\n66#1:259\n91#1:260\n232#1:261\n*E\n"})
public final class AsyncProfilerProcess<TargetProcess extends ProfilerTargetProcess>
extends JavaProfilerProcess<TargetProcess> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProfilerConfigurationState profilerConfiguration;
    @NotNull
    private final AgentConfiguration agentConfiguration;
    private final long attachedTimestamp;
    @NotNull
    private final JavaProfilerTroubleshooter troubleshooter;
    @NotNull
    private final String helpId;
    @NotNull
    private static final Logger staticLogger;
    private static final int TERMINATE_AGENT_TIMEOUT = 5000;

    /*
     * WARNING - void declaration
     */
    public AsyncProfilerProcess(@NotNull Project project, @NotNull ProfilerProcessCommunicator<TargetProcess> communicator, @NotNull ProfilerConfigurationState profilerConfiguration, @NotNull AgentConfiguration agentConfiguration, long attachedTimestamp) {
        void $this$troubleshooter_u24lambda_u242;
        AsyncProfilerTroubleshooter asyncProfilerTroubleshooter;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(communicator, (String)"communicator");
        Intrinsics.checkNotNullParameter((Object)profilerConfiguration, (String)"profilerConfiguration");
        Intrinsics.checkNotNullParameter((Object)agentConfiguration, (String)"agentConfiguration");
        super(project, communicator, agentConfiguration);
        this.profilerConfiguration = profilerConfiguration;
        this.agentConfiguration = agentConfiguration;
        this.attachedTimestamp = attachedTimestamp;
        AsyncProfilerTroubleshooter asyncProfilerTroubleshooter2 = asyncProfilerTroubleshooter = new AsyncProfilerTroubleshooter((Function0<? extends File>)((Function0)() -> AsyncProfilerProcess.troubleshooter$lambda$0(this)));
        AsyncProfilerProcess asyncProfilerProcess = this;
        boolean bl = false;
        $this$troubleshooter_u24lambda_u242.addErrorReporter(new LogErrorAsyncProfilerErrorReporter(() -> AsyncProfilerProcess.troubleshooter$lambda$2$lambda$1((AsyncProfilerTroubleshooter)$this$troubleshooter_u24lambda_u242), null, 2, null));
        $this$troubleshooter_u24lambda_u242.addErrorReporter(new StatisticsAsyncProfilerErrorReporter());
        asyncProfilerProcess.troubleshooter = asyncProfilerTroubleshooter;
        this.helpId = "procedures.profiler";
    }

    @NotNull
    public ProfilerConfigurationState getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    public final AgentConfiguration getAgentConfiguration$intellij_profiler_ultimate() {
        return this.agentConfiguration;
    }

    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    @Override
    @NotNull
    public JavaProfilerTroubleshooter getTroubleshooter() {
        return this.troubleshooter;
    }

    @RequiresBackgroundThread
    public final boolean tryReopenDump(int attempts, long waitBetweenAttemptsMs, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.changeStateAndNotifyAsync((ProfilerState)ReadingData.INSTANCE);
        File dumpFile = this.agentConfiguration.getResultSnapshot().getDumpFile();
        int i = 1;
        if (i <= attempts) {
            while (true) {
                TimeUnit.MILLISECONDS.sleep(waitBetweenAttemptsMs);
                ProfilerState result = this.readPreparedDumpAndReportStatistics(dumpFile, indicator);
                if (result instanceof DataReady) {
                    this.changeStateAndNotifyAsync(result);
                    return true;
                }
                if (i == attempts) break;
                ++i;
            }
        }
        return false;
    }

    @Override
    protected boolean doStop(int targetProcessId) {
        Function0 beforeCommand = () -> AsyncProfilerProcess.doStop$lambda$3(this);
        this.executeStop(targetProcessId, (ProfilerState)Attached.INSTANCE, (ProfilerState)ReadingData.INSTANCE, (Function0<Unit>)beforeCommand, (Function1<ProgressIndicator, Unit>)((Function1)arg_0 -> AsyncProfilerProcess.doStop$lambda$4(this, targetProcessId, arg_0)));
        return true;
    }

    @Override
    protected boolean doSuspend(int targetProcessId, @NotNull Function1<? super ProgressIndicator, Unit> onSuspend) {
        Intrinsics.checkNotNullParameter(onSuspend, (String)"onSuspend");
        AsyncProfilerProcess $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AsyncProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("doSuspend, file: " + this.agentConfiguration.getResultSnapshot().getDumpFile().getAbsolutePath());
        this.executeStop(targetProcessId, (ProfilerState)Attached.INSTANCE, (ProfilerState)ReadingData.INSTANCE, (Function0<Unit>)((Function0)AsyncProfilerProcess::doSuspend$lambda$5), onSuspend);
        return true;
    }

    @Override
    public boolean doResume(int targetProcessId, long threadId) {
        AsyncProfilerProcess $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AsyncProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("doResume, file: " + this.agentConfiguration.getResultSnapshot().getDumpFile().getAbsolutePath());
        String command = this.agentConfiguration.getOptions().agentArgs(true, new AgentOptions.MainCommand.Resume(threadId), this.agentConfiguration.getResultSnapshot().getDumpFile(), this.agentConfiguration.getLogFile(), AsyncProfilerExtractor.dbgHelpOption());
        ApplicationManager.getApplication().executeOnPooledThread(() -> AsyncProfilerProcess.doResume$lambda$6(targetProcessId, this, command));
        return true;
    }

    private final void executeStop(int pid, ProfilerState oldState, ProfilerState newState, Function0<Unit> beforeCommand, Function1<? super ProgressIndicator, Unit> afterCommand) {
        if (oldState != null && this.getState() != oldState) {
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> AsyncProfilerProcess.executeStop$lambda$10(this, beforeCommand, newState, pid, afterCommand));
    }

    static /* synthetic */ void executeStop$default(AsyncProfilerProcess asyncProfilerProcess, int n, ProfilerState profilerState, ProfilerState profilerState2, Function0 function0, Function1 function1, int n2, Object object) {
        if ((n2 & 8) != 0) {
            function0 = AsyncProfilerProcess::executeStop$lambda$7;
        }
        if ((n2 & 0x10) != 0) {
            function1 = AsyncProfilerProcess::executeStop$lambda$8;
        }
        asyncProfilerProcess.executeStop(n, profilerState, profilerState2, (Function0<Unit>)function0, (Function1<ProgressIndicator, Unit>)function1);
    }

    protected void onTerminateCalled() {
        if (this.getState().isActive()) {
            Disposer.dispose((Disposable)this.getCommunicator());
            Integer n = this.getCommunicator().getTargetProcessId();
            if (n == null) {
                return;
            }
            int pid = n;
            com.intellij.profiler.ultimate.async.AsyncProfilerProcess$Companion.doAttachAgent$default(Companion, pid, this.agentConfiguration.getAgentPath(), "stop", 5000, null, 16, null);
        }
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    private static final File troubleshooter$lambda$0(AsyncProfilerProcess this$0) {
        return this$0.agentConfiguration.getLogFile();
    }

    private static final Logger troubleshooter$lambda$2$lambda$1(AsyncProfilerTroubleshooter $this_apply) {
        AsyncProfilerTroubleshooter $this$thisLogger$iv = $this_apply;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AsyncProfilerTroubleshooter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final Unit doStop$lambda$3(AsyncProfilerProcess this$0) {
        Disposer.dispose((Disposable)this$0.getCommunicator());
        return Unit.INSTANCE;
    }

    private static final Unit doStop$lambda$4(AsyncProfilerProcess this$0, int $targetProcessId, ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        File dumpFile = this$0.agentConfiguration.getResultSnapshot().getDumpFile();
        AsyncProfilerProcess $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(AsyncProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.info("doStop, targetPid: " + $targetProcessId + ", dumpFile: " + dumpFile.getAbsolutePath());
        ProfilerState readResult = this$0.readPreparedDumpAndReportStatistics(dumpFile, indicator);
        this$0.changeStateAndNotifyAsync(readResult);
        return Unit.INSTANCE;
    }

    private static final Unit doSuspend$lambda$5() {
        return Unit.INSTANCE;
    }

    private static final void doResume$lambda$6(int $targetProcessId, AsyncProfilerProcess this$0, String $command) {
        AttachResult result = AsyncProfilerProcess.Companion.doAttachAgent($targetProcessId, this$0.agentConfiguration.getAgentPath(), $command, -1, (ProgressIndicator)new EmptyProgressIndicator());
        if (!(result instanceof Success)) {
            return;
        }
        this$0.changeStateAndNotifyAsync((ProfilerState)Attached.INSTANCE);
    }

    private static final Unit executeStop$lambda$7() {
        return Unit.INSTANCE;
    }

    private static final Unit executeStop$lambda$8(ProgressIndicator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit executeStop$lambda$10$lambda$9(Function0 $beforeCommand, AsyncProfilerProcess this$0, ProfilerState $newState, int $pid, Function1 $afterCommand, ProgressIndicator indicator) {
        String message;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        $beforeCommand.invoke();
        this$0.changeStateAndNotifyAsync($newState);
        AttachResult result = AsyncProfilerProcess.Companion.doAttachAgent($pid, this$0.agentConfiguration.getAgentPath(), AgentOptions.MainCommand.Stop.INSTANCE.getCommandName(), -1, indicator);
        if (result instanceof Canceled) {
            return Unit.INSTANCE;
        }
        AttachResult attachResult = result;
        if (attachResult instanceof AttachFailed) {
            Object[] objectArray = new Object[]{((AttachFailed)result).getMessage()};
            v0 = CommonProfilerBundleKt.profilerMessage((String)"profiler.error.cantStop", (Object[])objectArray);
        } else {
            v0 = message = attachResult instanceof TimeOut ? CommonProfilerBundleKt.profilerMessage((String)"profiler.error.timeout", (Object[])new Object[0]) : null;
        }
        if (message != null) {
            this$0.changeStateAndNotifyAsync((ProfilerState)new ProfilerError(message));
            return Unit.INSTANCE;
        }
        $afterCommand.invoke((Object)indicator);
        return Unit.INSTANCE;
    }

    private static final void executeStop$lambda$10(AsyncProfilerProcess this$0, Function0 $beforeCommand, ProfilerState $newState, int $pid, Function1 $afterCommand) {
        this$0.runUnderDumpReadIndicator(arg_0 -> AsyncProfilerProcess.executeStop$lambda$10$lambda$9($beforeCommand, this$0, $newState, $pid, $afterCommand, arg_0));
    }

    public static final /* synthetic */ Logger access$getStaticLogger$cp() {
        return staticLogger;
    }

    public static final /* synthetic */ ProfilerProcessCommunicator access$getCommunicator(AsyncProfilerProcess $this) {
        return $this.getCommunicator();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AsyncProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        staticLogger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J4\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess$Companion;", "", "<init>", "()V", "attach", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/profiler/ultimate/async/AsyncProfilerProcess;", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "targetProcess", "profilerConfiguration", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "agentConfiguration", "Lcom/intellij/profiler/ultimate/async/AgentConfiguration;", "timeoutInMilliseconds", "", "project", "Lcom/intellij/openapi/project/Project;", "doAttachAgent", "Lcom/intellij/profiler/ultimate/AttachResult;", "targetPid", "agentPath", "", "agentOptions", "timeout", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "TERMINATE_AGENT_TIMEOUT", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Promise<AsyncProfilerProcess<AttachableTargetProcess>> attach(@NotNull AttachableTargetProcess targetProcess, @NotNull ProfilerConfigurationState profilerConfiguration, @NotNull AgentConfiguration agentConfiguration, int timeoutInMilliseconds, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
            Intrinsics.checkNotNullParameter((Object)profilerConfiguration, (String)"profilerConfiguration");
            Intrinsics.checkNotNullParameter((Object)agentConfiguration, (String)"agentConfiguration");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            AsyncPromise result = new AsyncPromise();
            String string = CommonProfilerBundleKt.profilerMessage((String)"attach.task.title", (Object[])new Object[0]);
            PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.DEAF;
            new Task.Backgroundable(project, targetProcess, agentConfiguration, profilerConfiguration, timeoutInMilliseconds, (AsyncPromise<AsyncProfilerProcess<AttachableTargetProcess>>)result, string, performInBackgroundOption){
                final /* synthetic */ Project $project;
                final /* synthetic */ AttachableTargetProcess $targetProcess;
                final /* synthetic */ AgentConfiguration $agentConfiguration;
                final /* synthetic */ ProfilerConfigurationState $profilerConfiguration;
                final /* synthetic */ int $timeoutInMilliseconds;
                final /* synthetic */ AsyncPromise<AsyncProfilerProcess<AttachableTargetProcess>> $result;
                {
                    this.$project = $project;
                    this.$targetProcess = $targetProcess;
                    this.$agentConfiguration = $agentConfiguration;
                    this.$profilerConfiguration = $profilerConfiguration;
                    this.$timeoutInMilliseconds = $timeoutInMilliseconds;
                    this.$result = $result;
                    super($project, $super_call_param$1, true, $super_call_param$2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    Object[] objectArray = new Object[]{this.$targetProcess.getFullName()};
                    indicator.setText(CommonProfilerBundleKt.profilerMessage((String)"attach.task.text", (Object[])objectArray));
                    String dbgHelpOption = AsyncProfilerExtractor.dbgHelpOption();
                    String attachOptions = this.$agentConfiguration.getOptions().agentArgs(true, AgentOptions.MainCommand.Start.INSTANCE, this.$agentConfiguration.getResultSnapshot().getDumpFile(), this.$agentConfiguration.getLogFile(), dbgHelpOption);
                    String agentPath = this.$agentConfiguration.getAgentPath();
                    AsyncProfilerProcess.access$getStaticLogger$cp().info("attach profiler to running process: agent:" + agentPath + ", options:" + attachOptions);
                    AttachedToAlreadyRunningProcessCommunicator communicator = new AttachedToAlreadyRunningProcessCommunicator(this.$targetProcess);
                    AsyncProfilerProcess<TargetProcess> process = new AsyncProfilerProcess<TargetProcess>(this.$project, communicator, this.$profilerConfiguration, this.$agentConfiguration, System.currentTimeMillis());
                    AttachResult attachResult = com.intellij.profiler.ultimate.async.AsyncProfilerProcess$Companion.access$doAttachAgent(AsyncProfilerProcess.Companion, this.$targetProcess.getPid(), agentPath, attachOptions, this.$timeoutInMilliseconds, indicator);
                    AsyncPromise<AsyncProfilerProcess<AttachableTargetProcess>> asyncPromise = this.$result;
                    AgentConfiguration agentConfiguration = this.$agentConfiguration;
                    AttachableTargetProcess attachableTargetProcess = this.$targetProcess;
                    AsyncPromise<AsyncProfilerProcess<AttachableTargetProcess>> asyncPromise2 = this.$result;
                    boolean $i$f$catchError = false;
                    try {
                        ProfilerState state;
                        boolean bl = false;
                        if (attachResult instanceof AttachFailed && (state = process.getTroubleshooter().analyzeAndReport(new JavaProfilerErrorContext((JavaProfilerProcess)process, agentConfiguration.getResultSnapshot().getDumpFile(), indicator, AsyncProfilerProcess.access$getCommunicator(process), attachOptions, System.currentTimeMillis() - process.getStartTimeMs(), ((AttachFailed)attachResult).getMessage(), true))) instanceof ProfilerErrorWithContext) {
                            throw new AttachFailedException(((ProfilerErrorWithContext)state).getReason());
                        }
                        Throwable exception = NativeAgentAttachKt.tryCreateException(attachResult, attachableTargetProcess);
                        if (exception != null) {
                            throw exception;
                        }
                        asyncPromise2.setResult(process);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable e$iv) {
                        void $this$catchError$iv;
                        $this$catchError$iv.setError(e$iv);
                        Object var15_16 = null;
                    }
                }
            }.queue();
            return (Promise)result;
        }

        private final AttachResult doAttachAgent(int targetPid, String agentPath, String agentOptions, int timeout, ProgressIndicator indicator) {
            if (SystemInfo.isWindows) {
                AttachResult attachResult;
                Throwable error2 = VMAgentAttachKt.safeVMAttach(targetPid, (Function1<? super HotSpotVirtualMachine, Unit>)((Function1)arg_0 -> Companion.doAttachAgent$lambda$0(agentPath, agentOptions, arg_0)));
                if (error2 != null) {
                    String string;
                    Object message = error2.getMessage();
                    Throwable cause = error2.getCause();
                    if (cause != null) {
                        message = (String)message + "\n" + cause.getMessage();
                    }
                    if ((string = message) == null) {
                        string = "No message";
                    }
                    attachResult = new AttachFailed(string);
                } else {
                    attachResult = Success.INSTANCE;
                }
                return attachResult;
            }
            return NativeAgentAttachKt.attachAgentUsingNativeJattach(targetPid, agentPath, agentOptions, timeout, indicator);
        }

        static /* synthetic */ AttachResult doAttachAgent$default(Companion companion, int n, String string, String string2, int n2, ProgressIndicator progressIndicator, int n3, Object object) {
            if ((n3 & 0x10) != 0) {
                progressIndicator = null;
            }
            return companion.doAttachAgent(n, string, string2, n2, progressIndicator);
        }

        private static final Unit doAttachAgent$lambda$0(String $agentPath, String $agentOptions, HotSpotVirtualMachine vm) {
            Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
            String OLD_JVM_RESPONSE = "0";
            String NEW_JVM_RESPONSE = "return code: 0";
            String response = VMAgentAttachKt.loadAgentWithoutCheck(vm, $agentPath, $agentOptions);
            if (!Intrinsics.areEqual((Object)response, (Object)OLD_JVM_RESPONSE) && !Intrinsics.areEqual((Object)response, (Object)NEW_JVM_RESPONSE)) {
                throw new IllegalStateException("Can't attach agent: '" + response + "'");
            }
            return Unit.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

