/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.database.script.PersistenceConsoleProvider;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.facet.FacetManager;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.engine.HibernateConsole;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.jpa.ConsoleTarget;
import com.intellij.jpa.JpaConsoleProvider;
import com.intellij.jpa.JpaConsoleUtils;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.view.editor.PersistencePackageAsVirtualFileImpl;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class HibernateConsoleProvider
extends PersistenceConsoleProvider {
    HibernateConsoleProvider() {
    }

    public boolean hasRunners(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            return false;
        }
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        if (!(facet instanceof HibernateFacet)) {
            return false;
        }
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        return unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit) && facet.getQlLanguage() != null && HibernateConsoleProvider.isAvailable(facet.getModule());
    }

    private static boolean isAvailable(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"org.hibernate.cfg.Configuration");
    }

    public boolean hasRunners(@NotNull PsiElement element, @Nullable Editor editor) {
        PsiFile file;
        if (element == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(1);
        }
        if (!((file = element.getContainingFile()) instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !HibernateConsoleProvider.isAvailable(module)) {
            return false;
        }
        Collection hibernateFacets = FacetManager.getInstance((Module)module).getFacetsByType(HibernateFacetType.getInstance().getId());
        if (hibernateFacets.isEmpty()) {
            return false;
        }
        return JpaConsoleProvider.findQlFile((PsiFile)file, (PsiElement)element) != null;
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull DataContext dataContext) {
        boolean enable;
        Project project;
        if (dataContext == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(2);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        if (!(facet instanceof HibernateFacet)) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT.getData(dataContext);
        boolean bl = enable = unit != null && unit.isValid() && JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit) && facet.getQlLanguage() != null && HibernateConsoleProvider.isAvailable(facet.getModule());
        if (!enable) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(5);
            }
            return list;
        }
        PersistencePackagePointer unitFile = PersistencePackageAsVirtualFileImpl.findFile((PersistencePackage)unit, (PersistenceFacet)facet);
        if (unitFile == null) {
            List<PersistenceConsoleProvider.Runner> list = Collections.emptyList();
            if (list == null) {
                HibernateConsoleProvider.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add((PersistenceConsoleProvider.Runner)new MyRunner(project, unitFile));
        HibernateConsoleProvider.addDefaultRunners(result, project, unitFile, null);
        ArrayList<PersistenceConsoleProvider.Runner> arrayList = result;
        if (arrayList == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static void addDefaultRunners(Collection<PersistenceConsoleProvider.Runner> result, Project project, PersistencePackagePointer unit, QlScriptModel queryText) {
        for (HibernateConsole console : HibernateConsole.getActiveConsoles(project)) {
            if (!((PersistencePackagePointer)console.getTarget()).equals(unit)) continue;
            result.add((PersistenceConsoleProvider.Runner)new JpaConsoleProvider.MyConsoleRunner((JpaConsoleBase)console, (ScriptModel)queryText));
        }
    }

    @NotNull
    public List<PersistenceConsoleProvider.Runner> getRunners(@NotNull PsiElement element, Editor editor) {
        if (element == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(8);
        }
        List list = (List)ReadAction.nonBlocking(() -> HibernateConsoleProvider.getRunnersInner(element)).withDocumentsCommitted(element.getProject()).inSmartMode(element.getProject()).executeSynchronously();
        if (list == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static List<PersistenceConsoleProvider.Runner> getRunnersInner(@NotNull PsiElement element) {
        QlScriptModel model;
        if (element == null) {
            HibernateConsoleProvider.$$$reportNull$$$0(10);
        }
        if (!element.isValid()) {
            return Collections.emptyList();
        }
        PsiFile file = element.getContainingFile();
        if (!(file instanceof QlFile || JamCommonUtil.isPlainJavaFile((PsiElement)file) || JamCommonUtil.isPlainXmlFile((PsiElement)file))) {
            return Collections.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null || !HibernateConsoleProvider.isAvailable(module)) {
            return Collections.emptyList();
        }
        Collection hibernateFacets = FacetManager.getInstance((Module)module).getFacetsByType(HibernateFacetType.getInstance().getId());
        if (hibernateFacets.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PersistencePackagePointer> unitFiles = new ArrayList<PersistencePackagePointer>();
        for (PersistenceFacet facet : PersistenceCommonUtil.getAllPersistenceFacetsWithDependencies((Module)module)) {
            if (facet.getQlLanguage() == null) continue;
            for (PersistencePackage unit : facet.getPersistenceUnits()) {
                if (!JpaConsoleProvider.canOpenConsoleInSeparatedProcess((PersistencePackage)unit)) continue;
                ContainerUtil.addIfNotNull(unitFiles, (Object)PersistencePackageAsVirtualFileImpl.findFile((PersistencePackage)unit, (PersistenceFacet)facet));
            }
        }
        if (unitFiles.isEmpty()) {
            return Collections.emptyList();
        }
        QlFile qlFile = JpaConsoleProvider.findQlFile((PsiFile)file, (PsiElement)element);
        QlScriptModel qlScriptModel = model = qlFile == null ? null : JpaConsoleProvider.createScriptModel((PsiFile)file, (QlFile)qlFile);
        if (model == null || model.statements().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PersistenceConsoleProvider.Runner> result = new ArrayList<PersistenceConsoleProvider.Runner>();
        result.add((PersistenceConsoleProvider.Runner)new MyQueryRunner(module.getProject(), unitFiles, model));
        for (PersistencePackagePointer unit : unitFiles) {
            HibernateConsoleProvider.addDefaultRunners(result, module.getProject(), unit, model);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/HibernateConsoleProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/HibernateConsoleProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasRunners";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRunners";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRunnersInner";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 9 -> new IllegalStateException(string);
        };
    }

    private static class MyRunner
    extends JpaConsoleProvider.MyRunner {
        private final PersistencePackagePointer myUnitFile;

        MyRunner(Project project, PersistencePackagePointer unitFile) {
            super(project, unitFile);
            this.myUnitFile = unitFile;
        }

        public String getDisplayName() {
            return HibernateBundle.message("hibernate.console", new Object[0]);
        }

        public Icon getIcon() {
            return JavaUltimateIcons.Javaee.Hibernate;
        }

        protected void runInner(@NotNull ConsoleRunConfiguration configuration) {
            ConsoleTarget target;
            if (configuration == null) {
                MyRunner.$$$reportNull$$$0(0);
            }
            if ((target = JpaConsoleUtils.suggestAssignDatasourceIfNeeded((PersistencePackagePointer)this.myUnitFile)) == null) {
                return;
            }
            ((HibernateConsole)((Object)HibernateConsole.newConsole(target.getPersistencePackage()).withRunConfiguration(configuration).build())).showConsole(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/hibernate/HibernateConsoleProvider$MyRunner", "runInner"));
        }
    }

    private static class MyQueryRunner
    extends JpaConsoleProvider.MyQueryRunner {
        MyQueryRunner(Project project, List<PersistencePackagePointer> unitFiles, QlScriptModel model) {
            super(project, unitFiles, model);
        }

        public String getDisplayName() {
            return HibernateBundle.message("hibernate.console", new Object[0]);
        }

        public Icon getIcon() {
            return JavaUltimateIcons.Javaee.Hibernate;
        }

        public String getSubRunnersTitle() {
            return HibernateBundle.message("hibernate.console.session.factories.text", new Object[0]);
        }

        protected void runInner(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, @NotNull QlScriptModel model) {
            ConsoleTarget target;
            if (unit == null) {
                MyQueryRunner.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                MyQueryRunner.$$$reportNull$$$0(1);
            }
            if (model == null) {
                MyQueryRunner.$$$reportNull$$$0(2);
            }
            if ((target = JpaConsoleUtils.suggestAssignDatasourceIfNeeded((PersistencePackagePointer)unit)) == null) {
                return;
            }
            String text = (String)model.statements().transform(ScriptModelUtilCore.TO_QUERY).first();
            HibernateConsole console = (HibernateConsole)((Object)HibernateConsole.newConsole(target.getPersistencePackage()).withRunConfiguration(configuration).withQuery((CharSequence)text).build());
            console.showConsole(true);
            if (console.beforeExecuteQueries((ScriptModel)model)) {
                console.executeQueries((ScriptModel)model);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
            }
            objectArray[1] = "com/intellij/hibernate/HibernateConsoleProvider$MyQueryRunner";
            objectArray[2] = "runInner";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

