/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.highlighting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.hibernate.HibernateBundle;
import com.intellij.hibernate.facet.HibernateFacet;
import com.intellij.hibernate.facet.HibernateFacetConfiguration;
import com.intellij.hibernate.facet.HibernateFacetType;
import com.intellij.hibernate.model.HibernateDescriptorsConstants;
import com.intellij.hibernate.model.xml.config.HibernateConfiguration;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HibernateConfigDomFacetInspection
extends BasicDomElementsInspection<HibernateConfiguration> {
    public HibernateConfigDomFacetInspection() {
        super(HibernateConfiguration.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<HibernateConfiguration> element, @NotNull DomElementAnnotationHolder holder) {
        VirtualFile virtualFile;
        if (element == null) {
            HibernateConfigDomFacetInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HibernateConfigDomFacetInspection.$$$reportNull$$$0(1);
        }
        if ((virtualFile = element.getFile().getVirtualFile()) == null) {
            return;
        }
        boolean found = false;
        Module[] modulesToLookAt = this.getModules(element.getModule());
        if (modulesToLookAt.length == 0) {
            return;
        }
        List<HibernateFacet> facets = HibernateConfigDomFacetInspection.collectFacets(modulesToLookAt);
        for (HibernateFacet facet : facets) {
            for (ConfigFile configFile : facet.getDescriptors()) {
                if (HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA != configFile.getMetaData() || !virtualFile.equals(configFile.getVirtualFile())) continue;
                found = true;
            }
        }
        if (!found) {
            for (HibernateFacet facet : facets) {
                if (!facet.getPersistenceUnits().contains(((HibernateConfiguration)element.getRootElement()).getSessionFactory())) continue;
                found = true;
                break;
            }
        }
        if (facets.isEmpty()) {
            holder.createProblem(element, HighlightSeverity.WARNING, HibernateBundle.message("warning.cfg.xml.not.in.any.facet", new Object[0]), new LocalQuickFix[]{new AddFacetFix(modulesToLookAt)});
        } else if (!found) {
            holder.createProblem(element, HighlightSeverity.WARNING, HibernateBundle.message("warning.cfg.xml.not.in.any.facet", new Object[0]), new LocalQuickFix[]{new AddToFacetConfigurationFix(modulesToLookAt)});
        }
    }

    public Module @NotNull [] getModules(@Nullable Module elementModule) {
        if (elementModule == null) {
            if (Module.EMPTY_ARRAY == null) {
                HibernateConfigDomFacetInspection.$$$reportNull$$$0(2);
            }
            return Module.EMPTY_ARRAY;
        }
        Module[] moduleArray = JamCommonUtil.getAllDependentModules((Module)elementModule);
        if (moduleArray == null) {
            HibernateConfigDomFacetInspection.$$$reportNull$$$0(3);
        }
        return moduleArray;
    }

    private static List<HibernateFacet> collectFacets(Module[] modulesToLookAt) {
        return ContainerUtil.concat((Object[])modulesToLookAt, module -> FacetManager.getInstance((Module)module).getFacetsByType(HibernateFacet.ID));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFileElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class AddFacetFix
    extends AddToFacetConfigurationFix {
        AddFacetFix(Module[] modules) {
            super(modules);
        }

        @Override
        @NotNull
        public String getName() {
            String string = HibernateBundle.message("name.fix.create.facet.and.add.to.facet.configuration", new Object[0]);
            if (string == null) {
                AddFacetFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddFacetFix", "getName"));
        }
    }

    private static class AddToFacetConfigurationFix
    extends IntentionAndQuickFixAction {
        private final Module[] myModules;

        AddToFacetConfigurationFix(Module[] modules) {
            this.myModules = modules;
        }

        @NotNull
        public String getName() {
            String string = HibernateBundle.message("name.fix.add.to.facet.configuration", new Object[0]);
            if (string == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = HibernateBundle.message("hibernate.quickfix.family", new Object[0]);
            if (string == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(2);
            }
            this.doFix(project, psiFile.getVirtualFile(), editor);
        }

        private void doFix(Project project, VirtualFile file, Editor editor) {
            String url = file.getUrl();
            List<HibernateFacet> facets = HibernateConfigDomFacetInspection.collectFacets(this.myModules);
            if (this.myModules.length == 1 && (facets.isEmpty() || facets.size() == 1)) {
                AddToFacetConfigurationFix.doAddToFacet(this.myModules[0], facets.isEmpty() ? null : facets.get(0), url);
            } else {
                ArrayList<HibernateFacet> items = new ArrayList<HibernateFacet>();
                ContainerUtil.addAll(items, (Object[])this.myModules);
                items.addAll(facets);
                for (HibernateFacet facet : facets) {
                    items.remove(facet.getModule());
                }
                items.sort((o1, o2) -> Comparing.compare((Comparable)((Object)AddToFacetConfigurationFix.getItemName(o1)), (Comparable)((Object)AddToFacetConfigurationFix.getItemName(o2))));
                JBPopupFactory.getInstance().createPopupChooserBuilder(items).setTitle(HibernateBundle.message("popup.title.choose.module.and.facet", new Object[0])).setMovable(true).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, o, index) -> {
                    label.setIcon(o instanceof Module ? ModuleType.get((Module)((Module)o)).getIcon() : ((Facet)o).getType().getIcon());
                    label.setText(AddToFacetConfigurationFix.getItemName(o));
                })).setItemChosenCallback(o -> {
                    Module module = o instanceof Module ? (Module)o : ((Facet)o).getModule();
                    HibernateFacet facet = o instanceof Module ? null : (HibernateFacet)((Object)((Object)o));
                    AddToFacetConfigurationFix.doAddToFacet(module, facet, url);
                }).setNamerForFiltering(o -> AddToFacetConfigurationFix.getItemName(o)).createPopup().showCenteredInCurrentWindow(project);
            }
        }

        @NlsSafe
        private static String getItemName(Object o) {
            return o instanceof Module ? ((Module)o).getName() : ((Facet)o).getModule().getName() + "/" + ((Facet)o).getName();
        }

        private static void doAddToFacet(@NotNull Module module, @Nullable HibernateFacet facet, String url) {
            if (module == null) {
                AddToFacetConfigurationFix.$$$reportNull$$$0(3);
            }
            WriteCommandAction.writeCommandAction((Project)module.getProject()).withName(HibernateBundle.message("name.fix.add.to.facet.configuration.action", new Object[0])).run(() -> {
                HibernateFacet chosenFacet = facet != null ? facet : (HibernateFacet)FacetManager.getInstance((Module)module).addFacet((FacetType)HibernateFacetType.getInstance(), HibernateFacetType.getInstance().getDefaultFacetName(), null);
                ((HibernateFacetConfiguration)chosenFacet.getConfiguration()).getDescriptorsConfiguration().addConfigFile(HibernateDescriptorsConstants.HIBERNATE_CONFIGURATION_META_DATA, url);
            });
            DomElementAnnotationsManager.getInstance((Project)module.getProject()).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)module.getProject()).restart();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddToFacetConfigurationFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/hibernate/highlighting/HibernateConfigDomFacetInspection$AddToFacetConfigurationFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doAddToFacet";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

