/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.beans;

import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCdiBeanDescriptor<T extends PsiMember>
implements CdiBeanDescriptor<T> {
    @NotNull
    public abstract T getAnnotatedItem();

    @Nullable
    protected abstract PsiClass getDefaultDeploymentType();

    @Override
    public Set<PsiClass> getQualifiers() {
        PsiClass defaultAnnotationClass;
        HashSet<PsiClass> bindingTypes = new HashSet<PsiClass>();
        Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(this.getModule()));
        Object[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
        if (annotations.length > 0) {
            bindingTypes.addAll(ContainerUtil.map2Set((Object[])annotations, psiAnnotation -> this.getAnnotationClass(psiAnnotation.getQualifiedName())));
        }
        if (!CdiAnnoConstants.SPECIALIZES_ANNOTATION.isAnnotated(this.getAnnotatedItem(), 1) && (defaultAnnotationClass = this.getAnnotationClass(CdiAnnoConstants.DEFAULT_ANNOTATION.fqnFromAnnotated(this.getAnnotatedItem()))) != null) {
            bindingTypes.add(defaultAnnotationClass);
        }
        return bindingTypes;
    }

    @Override
    @Nullable
    public PsiClass getScopeType() {
        Module module = this.getModule();
        if (module != null) {
            Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module));
            PsiAnnotation[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
            if (annotations.length > 0) {
                return this.getAnnotationClass(annotations[0].getQualifiedName());
            }
        }
        return this.getAnnotationClass(CdiAnnoConstants.DEPENDENT_ANNOTATION.fqn(this.getAnnotatedItem()));
    }

    @Override
    @Nullable
    public PsiClass getDeploymentType() {
        Module module = this.getModule();
        if (module != null) {
            Collection<String> qualifiedNames = CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module));
            PsiAnnotation[] annotations = AnnotationUtil.findAnnotations(this.getAnnotatedItem(), qualifiedNames);
            if (annotations.length > 0) {
                return this.getAnnotationClass(annotations[0].getQualifiedName());
            }
        }
        return this.getDefaultDeploymentType();
    }

    @Override
    @NotNull
    public Set<PsiClass> getStereotypes() {
        HashSet<PsiClass> stereotypes = new HashSet<PsiClass>();
        Module module = this.getModule();
        if (module != null) {
            Collection<PsiClass> stereotypeAnnotationClasses = CdiCommonUtils.getStereotypeAnnotationClasses(module);
            T annotatedItem = this.getAnnotatedItem();
            for (PsiClass psiClass : stereotypeAnnotationClasses) {
                if (!AnnotationUtil.isAnnotated(annotatedItem, (String)psiClass.getQualifiedName(), (int)1)) continue;
                stereotypes.add(psiClass);
            }
        }
        HashSet<PsiClass> hashSet = stereotypes;
        if (hashSet == null) {
            AbstractCdiBeanDescriptor.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @Nullable
    protected PsiClass getAnnotationClass(@Nullable String annotation) {
        if (annotation == null) {
            return null;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.getAnnotatedItem().getProject());
        Module module = this.getModule();
        GlobalSearchScope scope = module == null ? GlobalSearchScope.allScope((Project)this.getAnnotatedItem().getProject()) : GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        return psiFacade.findClass(annotation, scope);
    }

    @Nullable
    protected Module getModule() {
        return ModuleUtilCore.findModuleForPsiElement(this.getAnnotatedItem());
    }

    @Override
    public T getIdentifyingElement() {
        return this.getAnnotatedItem();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/beans/AbstractCdiBeanDescriptor", "getStereotypes"));
    }
}

