/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.dsm.DsmBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class BaseClassesAnalysisAction
extends BaseAnalysisAction {
    protected BaseClassesAnalysisAction(@NlsContexts.DialogTitle String title, @Nls(capitalization=Nls.Capitalization.Title) String analysisNoun) {
        super(title, analysisNoun);
    }

    protected abstract void analyzeClasses(@NotNull Project var1, @NotNull AnalysisScope var2, @NotNull ProgressIndicator var3);

    protected void analyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, DsmBundle.message("analyzing.project", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                CompileScope compileScope;
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                indicator.setText(DsmBundle.message("checking.class.files", new Object[0]));
                if (project.isDisposed()) {
                    return;
                }
                CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
                int scopeType = scope.getScopeType();
                if (scopeType == 9) {
                    compileScope = compilerManager.createFilesCompileScope(scope.getFiles().toArray(VirtualFile.EMPTY_ARRAY));
                } else if (scopeType == 2 || scopeType == 3) {
                    PsiElement element = scope.getElement();
                    assert (element != null);
                    compileScope = compilerManager.createFilesCompileScope(new VirtualFile[]{((PsiFileSystemItem)element).getVirtualFile()});
                } else {
                    compileScope = compilerManager.createModulesCompileScope(BaseClassesAnalysisAction.getScopeModules(scope).toArray(Module.EMPTY_ARRAY), false);
                }
                boolean upToDate = compilerManager.isUpToDate(compileScope);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    if (!upToDate) {
                        int i = Messages.showYesNoCancelDialog((Project)this.getProject(), (String)DsmBundle.message("recompile.confirmation.message", new Object[0]), (String)DsmBundle.message("project.is.out.of.date", new Object[0]), (Icon)Messages.getWarningIcon());
                        if (i == 2) {
                            return;
                        }
                        if (i == 0) {
                            BaseClassesAnalysisAction.this.compileAndAnalyze(project, scope);
                        } else {
                            BaseClassesAnalysisAction.this.doAnalyze(project, scope);
                        }
                    } else {
                        BaseClassesAnalysisAction.this.doAnalyze(project, scope);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/analysis/BaseClassesAnalysisAction$1", "run"));
            }
        });
    }

    @NotNull
    public static Set<Module> getScopeModules(@NotNull AnalysisScope scope) {
        if (scope == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(2);
        }
        int scopeType = scope.getScopeType();
        HashSet<Module> result = new HashSet<Module>();
        Project project = scope.getProject();
        if (scopeType == 4) {
            Module module = scope.getModule();
            if (module != null) {
                result.add(module);
            }
        } else if (scopeType == 7) {
            result.addAll(scope.getModules());
        } else if (scopeType == 3) {
            PsiElement element = scope.getElement();
            if (element != null) {
                VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
                BaseClassesAnalysisAction.getContainingModule(vFile, project, result);
            }
        } else if (scopeType == 2) {
            PsiElement element = scope.getElement();
            if (element != null) {
                VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
                Module[] modules = ModuleManager.getInstance((Project)project).getModules();
                BaseClassesAnalysisAction.getModulesContainedInDirectory(modules, vFile, result);
                BaseClassesAnalysisAction.getContainingModule(vFile, project, result);
            }
        } else if (scopeType == 9) {
            Set files = scope.getFiles();
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            for (VirtualFile vFile : files) {
                BaseClassesAnalysisAction.getModulesContainedInDirectory(modules, vFile, result);
                BaseClassesAnalysisAction.getContainingModule(vFile, project, result);
            }
        } else {
            result.addAll(Arrays.asList(ModuleManager.getInstance((Project)project).getModules()));
        }
        HashSet<Module> hashSet = result;
        if (hashSet == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private static void getContainingModule(VirtualFile vFile, @NotNull Project project, @NotNull Set<? super Module> result) {
        ProjectFileIndex fileIndex;
        Module module;
        if (project == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(4);
        }
        if (result == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(5);
        }
        if ((module = (Module)ReadAction.compute(() -> BaseClassesAnalysisAction.lambda$getContainingModule$0(fileIndex = ProjectFileIndex.getInstance((Project)project), vFile))) != null) {
            result.add((Module)module);
        }
    }

    private static void getModulesContainedInDirectory(Module[] modules, VirtualFile directory, @NotNull Set<? super Module> result) {
        if (result == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(6);
        }
        if (!directory.isDirectory()) {
            return;
        }
        block0: for (Module module : modules) {
            VirtualFile[] roots;
            for (VirtualFile root : roots = ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)root, (boolean)false)) continue;
                result.add((Module)module);
                continue block0;
            }
        }
    }

    private void doAnalyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        if (project == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(8);
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, DsmBundle.message("analyzing.project", new Object[0]), true){

            public Task.NotificationInfo getNotificationInfo() {
                return new Task.NotificationInfo("Analysis", DsmBundle.message("notification.title.0.analysis.finished", this.getTitle()), "");
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                BaseClassesAnalysisAction.this.analyzeClasses(project, scope, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/analysis/BaseClassesAnalysisAction$2", "run"));
            }
        });
    }

    private void compileAndAnalyze(@NotNull Project project, @NotNull AnalysisScope scope) {
        if (project == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            BaseClassesAnalysisAction.$$$reportNull$$$0(10);
        }
        if (project.isDisposed()) {
            return;
        }
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        compilerManager.make(compilerManager.createProjectCompileScope(project), (aborted, errors, __, __2) -> {
            if (aborted || errors != 0) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> this.doAnalyze(project, scope));
        });
    }

    private static /* synthetic */ Module lambda$getContainingModule$0(ProjectFileIndex fileIndex, VirtualFile vFile) throws RuntimeException {
        return fileIndex.getModuleForFile(vFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/BaseClassesAnalysisAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/BaseClassesAnalysisAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getScopeModules";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModulesContainedInDirectory";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doAnalyze";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compileAndAnalyze";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

