/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.DsmPsiNode;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class ClassNode
implements DsmPsiNode {
    @NotNull
    public final String className;
    @Nullable
    private final Object myContainer;
    private String myPackageName;
    private volatile Icon myIcon;

    @VisibleForTesting
    public ClassNode(@NotNull String className, Module module) {
        if (className == null) {
            ClassNode.$$$reportNull$$$0(0);
        }
        this.className = className;
        this.myContainer = module;
    }

    ClassNode(@NotNull String className, @NotNull OrderEntry orderEntry) {
        if (className == null) {
            ClassNode.$$$reportNull$$$0(1);
        }
        if (orderEntry == null) {
            ClassNode.$$$reportNull$$$0(2);
        }
        if (!(orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry || orderEntry instanceof ModuleOrderEntry)) {
            throw new IllegalArgumentException(String.valueOf(orderEntry.getClass()));
        }
        this.className = className;
        this.myContainer = orderEntry;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassNode other = (ClassNode)o;
        if (!this.className.equals(other.className)) {
            return false;
        }
        if (this.myContainer == null) {
            return other.myContainer == null;
        }
        if (other.myContainer == null) {
            return false;
        }
        return this.myContainer.getClass().equals(other.myContainer.getClass()) && this.getContainerName().equals(other.getContainerName());
    }

    public int hashCode() {
        return 31 * this.className.hashCode() + this.getContainerName().hashCode();
    }

    public Icon getContainerIcon() {
        if (this.myContainer instanceof Module || this.myContainer instanceof ModuleOrderEntry) {
            return AllIcons.Nodes.Module;
        }
        if (this.myContainer instanceof LibraryOrderEntry) {
            return PlatformIcons.LIBRARY_ICON;
        }
        Object object = this.myContainer;
        if (object instanceof JdkOrderEntry) {
            Icon icon;
            JdkOrderEntry orderEntry = (JdkOrderEntry)object;
            Sdk jdk = orderEntry.getJdk();
            if (jdk == null) {
                return null;
            }
            SdkTypeId sdkTypeId = jdk.getSdkType();
            if (sdkTypeId instanceof SdkType) {
                SdkType sdkType = (SdkType)sdkTypeId;
                icon = sdkType.getIcon();
            } else {
                icon = null;
            }
            return icon;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        PsiClass psiClass = this.getElement();
        return psiClass == null ? null : psiClass.getContainingFile();
    }

    @Nullable
    public PsiClass getElement() {
        Project project = this.getProject();
        if (project == null) {
            return null;
        }
        return DumbService.isDumb((Project)project) ? null : JavaPsiFacade.getInstance((Project)project).findClass(this.className, Objects.requireNonNull(this.getScope()));
    }

    public Icon getIcon() {
        if (this.myIcon == null) {
            ReadAction.nonBlocking(() -> {
                PsiClass element = this.getElement();
                if (element != null) {
                    return element.getIcon(0);
                }
                return null;
            }).coalesceBy(new Object[]{this}).finishOnUiThread(ModalityState.nonModal(), icon -> {
                this.myIcon = icon;
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
            return JavaFileType.INSTANCE.getIcon();
        }
        return this.myIcon;
    }

    private GlobalSearchScope getScope() {
        Object object = this.myContainer;
        if (object instanceof Module) {
            Module module = (Module)object;
            return module.getModuleScope();
        }
        object = this.myContainer;
        if (object instanceof OrderEntry) {
            OrderEntry orderEntry = (OrderEntry)object;
            return orderEntry.getOwnerModule().getModuleWithDependenciesAndLibrariesScope(true);
        }
        return null;
    }

    private Project getProject() {
        Object object = this.myContainer;
        if (object instanceof Module) {
            Module module = (Module)object;
            return module.getProject();
        }
        object = this.myContainer;
        if (object instanceof OrderEntry) {
            OrderEntry orderEntry = (OrderEntry)object;
            return orderEntry.getOwnerModule().getProject();
        }
        return null;
    }

    public String getPackageName() {
        if (this.myPackageName != null) {
            return this.myPackageName;
        }
        int dotIndex = this.className.lastIndexOf(".");
        this.myPackageName = dotIndex >= 0 ? this.className.substring(0, dotIndex) : "<default>";
        return this.myPackageName;
    }

    @Nullable
    public Module getModule() {
        Module module;
        Object object = this.myContainer;
        return object instanceof Module ? (module = (Module)object) : null;
    }

    @Nullable
    public OrderEntry getOrderEntry() {
        OrderEntry orderEntry;
        Object object = this.myContainer;
        return object instanceof OrderEntry ? (orderEntry = (OrderEntry)object) : null;
    }

    @NotNull
    public String getContainerName() {
        Object object = this.myContainer;
        if (object instanceof Module) {
            Module module = (Module)object;
            String string = module.getName();
            if (string == null) {
                ClassNode.$$$reportNull$$$0(3);
            }
            return string;
        }
        object = this.myContainer;
        if (object instanceof ModuleOrderEntry) {
            ModuleOrderEntry orderEntry = (ModuleOrderEntry)object;
            String string = orderEntry.getModuleName();
            if (string == null) {
                ClassNode.$$$reportNull$$$0(4);
            }
            return string;
        }
        object = this.myContainer;
        if (object instanceof JdkOrderEntry) {
            JdkOrderEntry orderEntry = (JdkOrderEntry)object;
            String string = (String)ObjectUtils.notNull((Object)orderEntry.getJdkName(), (Object)"");
            if (string == null) {
                ClassNode.$$$reportNull$$$0(5);
            }
            return string;
        }
        object = this.myContainer;
        if (object instanceof LibraryOrderEntry) {
            LibraryOrderEntry orderEntry = (LibraryOrderEntry)object;
            String string = (String)ObjectUtils.notNull((Object)orderEntry.getLibraryName(), (Object)"");
            if (string == null) {
                ClassNode.$$$reportNull$$$0(6);
            }
            return string;
        }
        return "";
    }

    public String getShortClassName() {
        int dotIndex = this.className.lastIndexOf(".");
        return dotIndex >= 0 ? this.className.substring(dotIndex + 1) : this.className;
    }

    public String toString() {
        return this.className + " - " + this.getContainerName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dsm/model/classes/ClassNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dsm/model/classes/ClassNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

