/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.blockingCallsDetection.ContextType;
import com.intellij.codeInspection.blockingCallsDetection.ElementContext;
import com.intellij.codeInspection.blockingCallsDetection.NonBlockingContextChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBaseNonBlockingScopeInspection;
import com.intellij.reactivestreams.inspections.ReactiveStreamsBlockingScopeCheckResult;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;

public class ReactiveStreamsNonBlockingMethodChecker
implements NonBlockingContextChecker {
    public boolean isApplicable(@NotNull PsiFile file) {
        if (file == null) {
            ReactiveStreamsNonBlockingMethodChecker.$$$reportNull$$$0(0);
        }
        return ReactiveStreamsUtils.hasReactiveStreamsFor(file);
    }

    public ContextType computeContextType(@NotNull ElementContext elementContext) {
        UCallExpression callExpression;
        if (elementContext == null) {
            ReactiveStreamsNonBlockingMethodChecker.$$$reportNull$$$0(1);
        }
        if ((callExpression = AnalysisUastUtil.getUCallExpression((PsiElement)elementContext.getElement())) == null) {
            return ContextType.Blocking.INSTANCE;
        }
        boolean isNonBlockingContext = ReactiveStreamsBaseNonBlockingScopeInspection.isCalledInNonBlockingContext(callExpression) instanceof ReactiveStreamsBlockingScopeCheckResult.NonBlocking;
        return isNonBlockingContext ? ContextType.NonBlocking.INSTANCE : ContextType.Blocking.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/reactivestreams/inspections/ReactiveStreamsNonBlockingMethodChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "computeContextType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

