/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.inspections;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.reactivestreams.inspections.InternalCountStrategy;
import com.intellij.reactivestreams.inspections.InternalReplacementStrategy;
import com.intellij.reactivestreams.intention.IntentionUtilKt;
import com.intellij.reactivestreams.uast.ex.FunctionalObjectsUtil;
import com.intellij.reactivestreams.uast.ex.UCallExpressionContext;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/reactivestreams/inspections/ReactiveStreamsThrowInOperatorQuickfix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "replacementStrategy", "Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;", "countStrategy", "Lcom/intellij/reactivestreams/inspections/InternalCountStrategy;", "<init>", "(Lcom/intellij/reactivestreams/inspections/InternalReplacementStrategy;Lcom/intellij/reactivestreams/inspections/InternalCountStrategy;)V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.reactivestreams.core"})
final class ReactiveStreamsThrowInOperatorQuickfix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final InternalReplacementStrategy replacementStrategy;
    @NotNull
    private final InternalCountStrategy countStrategy;

    public ReactiveStreamsThrowInOperatorQuickfix(@NotNull InternalReplacementStrategy replacementStrategy, @NotNull InternalCountStrategy countStrategy) {
        Intrinsics.checkNotNullParameter((Object)replacementStrategy, (String)"replacementStrategy");
        Intrinsics.checkNotNullParameter((Object)countStrategy, (String)"countStrategy");
        this.replacementStrategy = replacementStrategy;
        this.countStrategy = countStrategy;
    }

    @NotNull
    public String getFamilyName() {
        return this.countStrategy.getQuickFixMessage(this.replacementStrategy.getText());
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        UThrowExpression uThrowExpression = (UThrowExpression)UastUtils.findContaining((PsiElement)element, UThrowExpression.class);
        if (uThrowExpression == null) {
            return;
        }
        UThrowExpression throwExpression = uThrowExpression;
        UFunctionalObject uFunctionalObject = UFunctionalObject.Companion.fromSuitableParent((UElement)throwExpression, ReactiveStreamsThrowInOperatorQuickfix::applyFix$lambda$0);
        if (uFunctionalObject == null) {
            return;
        }
        UFunctionalObject functionalObject = uFunctionalObject;
        this.countStrategy.invoke(functionalObject, throwExpression, (Function1<? super UThrowExpression, Unit>)((Function1)arg_0 -> ReactiveStreamsThrowInOperatorQuickfix.applyFix$lambda$1(this, project, functionalObject, arg_0)));
    }

    private static final UCallExpressionContext applyFix$lambda$0(UElement funcObj) {
        Intrinsics.checkNotNullParameter((Object)funcObj, (String)"funcObj");
        UElement uElement = funcObj.getUastParent();
        UCallExpression uCallExpression = uElement instanceof UCallExpression ? (UCallExpression)uElement : null;
        return uCallExpression != null ? FunctionalObjectsUtil.asContext(uCallExpression) : null;
    }

    private static final Unit applyFix$lambda$1(ReactiveStreamsThrowInOperatorQuickfix this$0, Project $project, UFunctionalObject $functionalObject, UThrowExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.replacementStrategy.replace(it, $project, $functionalObject)) {
            IntentionUtilKt.fail((UElement)it, "cannot replace throw statement");
            throw new KotlinNothingValueException();
        }
        return Unit.INSTANCE;
    }
}

