/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.debugger.streams;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.debugger.streams.FluxElementDescriptor;
import com.intellij.reactivestreams.reactor.debugger.streams.ReactorChildEvaluator;
import com.intellij.reactivestreams.reactor.debugger.streams.ReactorChildEvaluatorKt;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/reactivestreams/reactor/debugger/streams/FluxChildEvaluator;", "Lcom/intellij/reactivestreams/reactor/debugger/streams/ReactorChildEvaluator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "tryToBuildChildren", "", "parentObject", "Lcom/sun/jdi/ObjectReference;", "builder", "Lcom/intellij/debugger/ui/tree/render/ChildrenBuilder;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContext;", "addChildren", "array", "Lcom/sun/jdi/ArrayReference;", "loadedCount", "", "intellij.reactivestreams.reactor"})
@SourceDebugExtension(value={"SMAP\nReactorChildEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorChildEvaluator.kt\ncom/intellij/reactivestreams/reactor/debugger/streams/FluxChildEvaluator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1563#2:201\n1634#2,3:202\n*S KotlinDebug\n*F\n+ 1 ReactorChildEvaluator.kt\ncom/intellij/reactivestreams/reactor/debugger/streams/FluxChildEvaluator\n*L\n145#1:201\n145#1:202,3\n*E\n"})
public final class FluxChildEvaluator
extends ReactorChildEvaluator {
    @NotNull
    private final Project project;

    public FluxChildEvaluator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    public void tryToBuildChildren(@NotNull ObjectReference parentObject, @NotNull ChildrenBuilder builder, @NotNull EvaluationContext evaluationContext) {
        Intrinsics.checkNotNullParameter((Object)parentObject, (String)"parentObject");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        int chunkSize = this.getSettings().getStreamChunkSize();
        Pair<DebugProcess, VirtualMachineProxyImpl> pair = this.getDebugProcessAndVmProxy(evaluationContext);
        if (pair == null) {
            return;
        }
        Pair<DebugProcess, VirtualMachineProxyImpl> pair2 = pair;
        DebugProcess debugProcess = (DebugProcess)pair2.component1();
        VirtualMachineProxyImpl proxy = (VirtualMachineProxyImpl)pair2.component2();
        ValueDescriptor descriptor = builder.getParentDescriptor();
        Integer n = (Integer)descriptor.getUserData(ReactorChildEvaluatorKt.access$getLOADED_CHILD_COUNT_KEY$p());
        int alreadyLoadedCount = n != null ? n : 0;
        ObjectReference objectReference = this.invokeMethod(debugProcess, evaluationContext, parentObject, "skip", CollectionsKt.listOf((Object)proxy.mirrorOf(alreadyLoadedCount)));
        if (objectReference == null) {
            return;
        }
        ObjectReference skipResult = objectReference;
        ObjectReference objectReference2 = this.invokeMethod(debugProcess, evaluationContext, skipResult, "take", CollectionsKt.listOf((Object)proxy.mirrorOf(chunkSize)));
        if (objectReference2 == null) {
            return;
        }
        ObjectReference takenResult = objectReference2;
        ObjectReference objectReference3 = this.invokeMethod(debugProcess, evaluationContext, takenResult, "collectList", CollectionsKt.emptyList());
        if (objectReference3 == null) {
            return;
        }
        ObjectReference monoListResult = objectReference3;
        ObjectReference objectReference4 = this.convertToFutureAndGetResult(monoListResult, evaluationContext);
        if (objectReference4 == null) {
            return;
        }
        ObjectReference getResult = objectReference4;
        ObjectReference objectReference5 = this.invokeMethod(debugProcess, evaluationContext, getResult, "toArray", CollectionsKt.emptyList());
        ArrayReference arrayReference = objectReference5 instanceof ArrayReference ? (ArrayReference)objectReference5 : null;
        if (arrayReference == null) {
            return;
        }
        ArrayReference arrayResult = arrayReference;
        if (arrayResult.length() == 0) {
            DebuggerTreeNode debuggerTreeNode = builder.getNodeManager().createMessageNode(ReactorCoreBundle.message("debug.expression.result.empty.flux", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)debuggerTreeNode, (String)"createMessageNode(...)");
            DebuggerTreeNode node = debuggerTreeNode;
            builder.addChildren(CollectionsKt.listOf((Object)node), true);
            return;
        }
        this.addChildren(arrayResult, builder, evaluationContext, alreadyLoadedCount);
        descriptor.putUserData(ReactorChildEvaluatorKt.access$getLOADED_CHILD_COUNT_KEY$p(), (Object)(alreadyLoadedCount + arrayResult.length()));
    }

    /*
     * WARNING - void declaration
     */
    private final void addChildren(ArrayReference array, ChildrenBuilder builder, EvaluationContext evaluationContext, int loadedCount) {
        void $this$mapTo$iv$iv;
        AtomicInteger initialIndex = new AtomicInteger(loadedCount);
        List<Value> list = array.getValues();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getValues(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Value value = (Value)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = initialIndex.getAndIncrement();
            Intrinsics.checkNotNull((Object)it);
            FluxElementDescriptor descriptor = new FluxElementDescriptor(this.project, n, (Value)it);
            NodeManager nodeManager = builder.getNodeManager();
            Intrinsics.checkNotNull((Object)nodeManager, (String)"null cannot be cast to non-null type com.intellij.debugger.ui.impl.watch.NodeManagerImpl");
            collection.add(((NodeManagerImpl)nodeManager).createNode((NodeDescriptor)descriptor, evaluationContext));
        }
        List children = (List)destination$iv$iv;
        builder.setChildren(children);
        if (array.length() == this.getSettings().getStreamChunkSize()) {
            builder.tooManyChildren(-1);
        }
    }
}

