/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections;

import com.intellij.codeInspection.AnalysisUastUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.Language;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.reactivestreams.reactor.ReactorCoreBundle;
import com.intellij.reactivestreams.reactor.inspections.ReactorUastInspectionBase;
import com.intellij.reactivestreams.reactor.intention.ReactorFinishStepVerifierQuickFix;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import com.intellij.uast.UastHintedVisitorAdapter;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public final class UnfinishedStepVerifierInspection
extends ReactorUastInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            UnfinishedStepVerifierInspection.$$$reportNull$$$0(0);
        }
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){
            private static final Map<String, Supplier<@IntentionName String>> PROBLEM_DESCRIPTIONS_BY_RETURN_TYPE = Map.of("reactor.test.StepVerifier.Step", ReactorCoreBundle.messagePointer("inspections.unfinished.step.verifier.description", new Object[0]), "reactor.test.StepVerifier.FirstStep", ReactorCoreBundle.messagePointer("inspections.unfinished.step.verifier.description", new Object[0]), "reactor.test.StepVerifier.LastStep", ReactorCoreBundle.messagePointer("inspections.unfinished.step.verifier.description", new Object[0]), "reactor.test.StepVerifier", ReactorCoreBundle.messagePointer("inspections.unfinished.step.verifier.description", new Object[0]));
            private static final LocalQuickFix[] ADD_VERIFY = new LocalQuickFix[]{ReactorFinishStepVerifierQuickFix.newAddVerifyQuickFix()};
            private static final LocalQuickFix[] ADD_VERIFY_COMPLETE = new LocalQuickFix[]{ReactorFinishStepVerifierQuickFix.newAddVerifyCompleteQuickFix()};

            public boolean visitCallExpression(@NotNull UCallExpression callExpression) {
                if (callExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.inspect(callExpression);
                return super.visitCallExpression(callExpression);
            }

            private void inspect(@NotNull UCallExpression callExpression) {
                PsiElement methodIdentifierPsi;
                if (callExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((methodIdentifierPsi = AnalysisUastUtil.getMethodIdentifierSourcePsi((UCallExpression)callExpression)) == null) {
                    return;
                }
                String problemDescription = 1.getTargetProblemDescription(callExpression);
                if (problemDescription != null) {
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor(methodIdentifierPsi, problemDescription, isOnTheFly, 1.getLocalQuickFixes(callExpression), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    holder.registerProblem(problemDescriptor);
                }
            }

            @InspectionMessage
            @Nullable
            private static String getTargetProblemDescription(UCallExpression expression) {
                String returnTypeFqnName = AnalysisUastUtil.getExpressionReturnTypePsiClassFqn((UCallExpression)expression);
                if (returnTypeFqnName != null) {
                    return AnalysisUastUtil.isExpressionResultValueUsed((UCallExpression)expression) ? null : 1.getProblemDescriptionsByReturnType(returnTypeFqnName);
                }
                return null;
            }

            private static LocalQuickFix @NotNull [] getLocalQuickFixes(UCallExpression expression) {
                PsiClass psiClass;
                if (ReactiveStreamsUtils.getNextCallInChain(expression) != null) {
                    if (LocalQuickFix.EMPTY_ARRAY == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return LocalQuickFix.EMPTY_ARRAY;
                }
                PsiType returnType = expression.getReturnType();
                PsiClass psiClass2 = psiClass = returnType instanceof PsiClassType ? ((PsiClassType)returnType).resolve() : null;
                if (InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)false, (String)"reactor.test.StepVerifier.LastStep")) {
                    if (ADD_VERIFY_COMPLETE == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return ADD_VERIFY_COMPLETE;
                }
                if (InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)false, (String)"reactor.test.StepVerifier")) {
                    if (ADD_VERIFY == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return ADD_VERIFY;
                }
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(5);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }

            @IntentionName
            private static String getProblemDescriptionsByReturnType(@NotNull String returnType) {
                Supplier<String> supplier;
                if (returnType == null) {
                    1.$$$reportNull$$$0(6);
                }
                if ((supplier = PROBLEM_DESCRIPTIONS_BY_RETURN_TYPE.get(returnType)) == null) {
                    return null;
                }
                return supplier.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3, 4, 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpression";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/reactivestreams/reactor/inspections/UnfinishedStepVerifierInspection$1";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "returnType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/reactivestreams/reactor/inspections/UnfinishedStepVerifierInspection$1";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocalQuickFixes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "inspect";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getProblemDescriptionsByReturnType";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3, 4, 5 -> new IllegalStateException(string);
                };
            }
        }, (Class[])new Class[]{UCallExpression.class});
        if (psiElementVisitor == null) {
            UnfinishedStepVerifierInspection.$$$reportNull$$$0(1);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/reactivestreams/reactor/inspections/UnfinishedStepVerifierInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/reactivestreams/reactor/inspections/UnfinishedStepVerifierInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

