/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.reactivestreams.reactor.inspections.quickfix;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.reactivestreams.uast.ex.UFunctionalObject;
import com.intellij.reactivestreams.util.ReactiveStreamsUtils;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.analysis.DependencyGraphUtilsKt;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/reactivestreams/reactor/inspections/quickfix/MapLambdaVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "factory", "Lorg/jetbrains/uast/generate/UastElementFactory;", "plugin", "Lorg/jetbrains/uast/generate/UastCodeGenerationPlugin;", "mapLambda", "Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;", "handleContext", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lorg/jetbrains/uast/generate/UastElementFactory;Lorg/jetbrains/uast/generate/UastCodeGenerationPlugin;Lcom/intellij/reactivestreams/uast/ex/UFunctionalObject;Lcom/intellij/psi/PsiElement;)V", "visitReturnExpression", "", "node", "Lorg/jetbrains/uast/UReturnExpression;", "visitThrowExpression", "Lorg/jetbrains/uast/UThrowExpression;", "intellij.reactivestreams.reactor"})
@SourceDebugExtension(value={"SMAP\nReactorThrowInMapQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactorThrowInMapQuickFix.kt\ncom/intellij/reactivestreams/reactor/inspections/quickfix/MapLambdaVisitor\n+ 2 UastCodeGenerationPlugin.kt\norg/jetbrains/uast/generate/UastCodeGenerationPluginKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n229#2,6:112\n236#2:119\n14#3:118\n1869#4,2:120\n*S KotlinDebug\n*F\n+ 1 ReactorThrowInMapQuickFix.kt\ncom/intellij/reactivestreams/reactor/inspections/quickfix/MapLambdaVisitor\n*L\n77#1:112,6\n77#1:119\n77#1:118\n84#1:120,2\n*E\n"})
final class MapLambdaVisitor
extends AbstractUastVisitor {
    @NotNull
    private final UastElementFactory factory;
    @NotNull
    private final UastCodeGenerationPlugin plugin;
    @NotNull
    private final UFunctionalObject<?> mapLambda;
    @NotNull
    private final PsiElement handleContext;

    public MapLambdaVisitor(@NotNull UastElementFactory factory, @NotNull UastCodeGenerationPlugin plugin, @NotNull UFunctionalObject<?> mapLambda, @NotNull PsiElement handleContext) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter(mapLambda, (String)"mapLambda");
        Intrinsics.checkNotNullParameter((Object)handleContext, (String)"handleContext");
        this.factory = factory;
        this.plugin = plugin;
        this.mapLambda = mapLambda;
        this.handleContext = handleContext;
    }

    /*
     * WARNING - void declaration
     */
    public boolean visitReturnExpression(@NotNull UReturnExpression node) {
        UReturnExpression expression;
        UReturnExpression uReturnExpression;
        UElement uElement;
        void $this$replace$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        UReturnExpression expressionWithChangedLabel = this.plugin.changeLabel(node, this.handleContext);
        UElement uElement2 = (UElement)node;
        UElement newElement$iv = (UElement)expressionWithChangedLabel;
        boolean $i$f$replace = false;
        if (Intrinsics.areEqual((Object)$this$replace$iv, (Object)newElement$iv)) {
            uElement = newElement$iv;
        } else {
            UastCodeGenerationPlugin uastCodeGenerationPlugin = UastCodeGenerationPlugin.Companion.byLanguage($this$replace$iv.getLang());
            UastCodeGenerationPlugin it$iv = uastCodeGenerationPlugin = uastCodeGenerationPlugin != null ? uastCodeGenerationPlugin.replace((UElement)$this$replace$iv, newElement$iv, UReturnExpression.class) : null;
            boolean bl = false;
            if (it$iv == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(UastCodeGenerationPlugin.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("failed replacing the " + (UElement)$this$replace$iv + " with " + newElement$iv);
            }
            uElement = uastCodeGenerationPlugin;
        }
        if ((uReturnExpression = (expression = (UReturnExpression)uElement)) == null || (uReturnExpression = uReturnExpression.getReturnExpression()) == null) {
            return false;
        }
        UReturnExpression rawReturn = uReturnExpression;
        Set branches = new LinkedHashSet();
        DependencyGraphUtilsKt.accumulateBranchesResult((UExpression)rawReturn, (Set)branches);
        if (branches.size() > 1) {
            Iterable $this$forEach$iv = branches;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UExpression uExpression = (UExpression)element$iv;
                boolean bl = false;
                UExpression uExpression2 = uExpression;
                if (uExpression2 instanceof UReturnExpression) {
                    ((UReturnExpression)uExpression).accept((UastVisitor)this);
                    continue;
                }
                if (uExpression2 instanceof UThrowExpression) {
                    ReactiveStreamsUtils.replaceReceiverAndMethodCall(uExpression, ((UThrowExpression)uExpression).getThrownExpression(), this.factory, "sink", "error", this.handleContext, true);
                    continue;
                }
                ReactiveStreamsUtils.replaceReceiverAndMethodCall(uExpression, uExpression, this.factory, "sink", "next", this.handleContext, true);
            }
            return true;
        }
        return ReactiveStreamsUtils.replaceAndAddReturnIfNotLastExpression((UExpression)expression, (UExpression)rawReturn, this.factory, this.mapLambda, "sink", "next", this.handleContext);
    }

    public boolean visitThrowExpression(@NotNull UThrowExpression node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return ReactiveStreamsUtils.replaceAndAddReturnIfNotLastExpression((UExpression)node, node.getThrownExpression(), this.factory, this.mapLambda, "sink", "error", this.handleContext);
    }
}

