/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.webp;

import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WebpNativeLibHelper {
    private static boolean sJniLibLoaded;
    private static boolean sJniLibLoadAttempted;

    private WebpNativeLibHelper() {
    }

    static void requireNativeLibrary() throws IOException {
        if (!WebpNativeLibHelper.loadNativeLibraryIfNeeded()) {
            throw new IOException("The WebP decoder library could not be loaded");
        }
    }

    @NotNull
    public static String getDecoderVersion() {
        return "1.3.2";
    }

    @NotNull
    public static String getEncoderVersion() {
        return WebpNativeLibHelper.getDecoderVersion();
    }

    public static boolean loadNativeLibraryIfNeeded() {
        if (!sJniLibLoadAttempted) {
            try {
                WebpNativeLibHelper.loadNativeLibrary();
            }
            catch (UnsatisfiedLinkError e) {
                Logger.getInstance(WebpNativeLibHelper.class).warn((Throwable)e);
            }
        }
        return sJniLibLoaded;
    }

    private static synchronized void loadNativeLibrary() {
        if (sJniLibLoadAttempted) {
            return;
        }
        try {
            Path libFile = WebpNativeLibHelper.getLibLocation();
            if (libFile == null) {
                throw new UnsatisfiedLinkError("WebP JNI binding is missing");
            }
            if (!Files.exists(libFile, new LinkOption[0])) {
                throw new UnsatisfiedLinkError(String.format("'%1$s' does not exist", libFile));
            }
            System.load(libFile.toString());
        }
        finally {
            sJniLibLoadAttempted = true;
        }
        sJniLibLoaded = true;
    }

    @Nullable
    public static Path getLibLocation() {
        String platformName;
        if (SystemInfo.isWindows) {
            platformName = "win";
        } else if (SystemInfo.isMac) {
            platformName = "mac";
        } else if (SystemInfo.isLinux) {
            platformName = "linux";
        } else {
            return null;
        }
        String relativePath = "lib/libwebp/" + platformName + "/" + System.mapLibraryName("webp_jni");
        Path local = Path.of(PluginPathManager.getPluginHomePath((String)"webp"), relativePath);
        if (Files.exists(local, new LinkOption[0])) {
            return local;
        }
        File resource = PluginPathManager.getPluginResource(WebpNativeLibHelper.class, (String)relativePath);
        return resource != null ? resource.toPath().toAbsolutePath() : null;
    }
}

