/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.inspections.unescapedEl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.options.JavaClassValidator;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.options.OptTab;
import com.intellij.codeInspection.options.OptTableColumn;
import com.intellij.codeInspection.options.StringValidator;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javaee.el.ELBinaryExpression;
import com.intellij.javaee.el.ELElementType;
import com.intellij.javaee.el.ELElementVisitor;
import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.ELTokenType;
import com.intellij.javaee.el.psi.ELConditionalExpression;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELLiteralExpression;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELSelectExpression;
import com.intellij.javaee.el.psi.ELUnaryExpression;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.javaee.el.util.ELImplicitVariable;
import com.intellij.javaee.el.util.ELResolveUtil;
import com.intellij.jsp.JavaeeJspBaseBundle;
import com.intellij.jsp.JavaeeJspBundle;
import com.intellij.jsp.impl.TypeAwareAttributeDescriptor;
import com.intellij.jsp.javaee.web.inspections.AbstractWrapFix;
import com.intellij.jsp.javaee.web.inspections.WrapInTagFix;
import com.intellij.jsp.javaee.web.inspections.unescapedEl.EscapingFunctionInfo;
import com.intellij.jsp.javaee.web.inspections.unescapedEl.SafeTagInfo;
import com.intellij.jsp.lang.jsp.NewJspLanguage;
import com.intellij.jsp.lang.jspx.JspxLanguageImpl;
import com.intellij.jsp.psi.BaseJspUtil;
import com.intellij.jsp.psi.impl.jspXml.JspExpressionImpl;
import com.intellij.jsp.psi.impl.jspXml.JspXmlDocument;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspExpression;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import com.siyeh.ig.psiutils.MethodMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JspUnescapedElInspection
extends XmlSuppressableInspectionTool
implements ELTokenType {
    private static final TokenSet SAFE_OPERATIONS = TokenSet.create((IElementType[])new IElementType[]{EL_AND, EL_OR, EL_NOT_KEYWORD, EL_NOT, EL_EQ, EL_NE, EL_LT, EL_GT, EL_LE, EL_GE, EL_TRUE, EL_FALSE, EL_NULL, EL_INSTANCEOF, EL_EMPTY, EL_DIV, EL_MOD, EL_LESS, EL_GREATER, EL_LESS_OR_EQUAL, EL_GREATER_OR_EQUAL, EL_MINUS, EL_PLUS, EL_DIVISION, EL_MODULO, EL_MULTIPLY, EL_NOT_EQUAL, EL_EQUAL, EL_AND_AND, EL_OR_OR, ELElementType.EL_LITERAL});
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String SET_TAG = "set";
    public static final String URL_TAG = "url";
    public static final String OUT_TAG = "out";
    public static final String EMPTY_STRING = "";
    public static final List<@NonNls String> JSTL_FUNCTIONS_URIS_LIST = List.of(XmlUtil.JSTL_FUNCTIONS_URIS);
    public static final List<@NonNls String> ATTRIBUTES_TO_SKIP = List.of("var", "items", "name");
    public final List<String> mySafeTagNamespaces = new ArrayList<String>(List.of("http://java.sun.com/jsp/jstl/core"));
    public final List<String> mySafeTagNames = new ArrayList<String>(List.of("out"));
    public final List<String> mySafeTagAttributes = new ArrayList<String>(List.of("value"));
    public boolean mySuggestEscapeXml = true;
    public final List<String> mySafeTagNamespacesForQuickFix = new ArrayList<String>(List.of("http://java.sun.com/jsp/jstl/core"));
    public final List<String> mySafeTagNamesForQuickFix = new ArrayList<String>(List.of("out"));
    public final List<String> mySafeTagAttributesForQuickFix = new ArrayList<String>(List.of("value"));
    public final List<String> myUntaintedAnnotations = new ArrayList<String>(List.of("org.checkerframework.checker.tainting.qual.Untainted", "javax.annotation.Untainted"));
    public final List<String> myUntaintedAnnotationsForQuickFix = new ArrayList<String>(List.of("org.checkerframework.checker.tainting.qual.Untainted", "javax.annotation.Untainted"));
    public final MethodMatcher myUntaintedMethodMatcher = new MethodMatcher().finishDefault();
    public final List<String> myUntaintedFieldClasses = new ArrayList<String>();
    public final List<String> myUntaintedFieldNames = new ArrayList<String>();
    public final List<String> myEscapingFunctionsNamespaces = new ArrayList<String>(Collections.nCopies(7, "http://java.sun.com/jsp/jstl/functions"));
    public final List<String> myEscapingFunctionsNames = new ArrayList<String>(List.of("contains", "containsIgnoreCase", "endsWith", "escapeXml", "indexOf", "length", "startsWith"));
    public boolean myStaticFinalFieldsAsUntainted = false;
    private final Set<SafeTagInfo> safeTags = ConcurrentCollectionFactory.createConcurrentSet();
    private final Set<EscapingFunctionInfo> escapingFunctions = ConcurrentCollectionFactory.createConcurrentSet();

    @NotNull
    public OptPane getOptionsPane() {
        StringValidator stringIsNotEmptyValidator = StringValidator.of((String)"stringIsNotEmpty", string -> {
            if (string.trim().isEmpty()) {
                return JavaeeJspBundle.message("value.is.required", new Object[0]);
            }
            return null;
        });
        JavaClassValidator annotationsOnlyValidator = new JavaClassValidator().annotationsOnly();
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.tabs((OptTab[])new OptTab[]{OptPane.tab((String)JavaeeJspBundle.message("safe.tags.tab", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.table((String)JavaeeJspBundle.message("safe.tags", new Object[0]), (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"mySafeTagNamespaces", (String)JavaeeJspBundle.message("column.name.namespace", new Object[0]), (StringValidator)stringIsNotEmptyValidator), OptPane.column((String)"mySafeTagNames", (String)JavaeeJspBundle.message("column.name.tag", new Object[0])), OptPane.column((String)"mySafeTagAttributes", (String)JavaeeJspBundle.message("column.name.attribute", new Object[0]))}).description(JavaeeJspBundle.message("safe.tags.description", new Object[0])), OptPane.table((String)JavaeeJspBundle.message("safe.tags.for.quick.fix", new Object[0]), (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"mySafeTagNamespacesForQuickFix", (String)JavaeeJspBundle.message("column.name.namespace", new Object[0]), (StringValidator)stringIsNotEmptyValidator), OptPane.column((String)"mySafeTagNamesForQuickFix", (String)JavaeeJspBundle.message("column.name.tag", new Object[0])), OptPane.column((String)"mySafeTagAttributesForQuickFix", (String)JavaeeJspBundle.message("column.name.attribute", new Object[0]))}).description(JavaeeJspBundle.message("safe.tags.for.quick.fix.description", new Object[0])), OptPane.checkbox((String)"mySuggestEscapeXml", (String)JavaeeJspBundle.message("suggest.jstl.escape.xml.as.fix", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])}), OptPane.tab((String)JavaeeJspBundle.message("untainted.annotations.tab", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"myUntaintedAnnotations", (String)JavaeeJspBundle.message("untainted.annotations", new Object[0]), (StringValidator)annotationsOnlyValidator).description(JavaeeJspBundle.message("untainted.annotations.description", new Object[0])), OptPane.stringList((String)"myUntaintedAnnotationsForQuickFix", (String)JavaeeJspBundle.message("untainted.annotations.for.quick.fix", new Object[0]), (StringValidator)annotationsOnlyValidator).description(JavaeeJspBundle.message("untainted.annotations.for.quick.fix.description", new Object[0]))}), OptPane.tab((String)JavaeeJspBundle.message("untainted.methods.tab", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{this.myUntaintedMethodMatcher.getTable(JavaeeJspBundle.message("untainted.methods", new Object[0])).description(JavaeeJspBundle.message("untainted.methods.description", new Object[0])).prefix("myUntaintedMethodMatcher"), OptPane.table((String)JavaeeJspBundle.message("untainted.fields", new Object[0]), (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"myUntaintedFieldClasses", (String)JavaeeJspBundle.message("untainted.fields.class.name", new Object[0]), (StringValidator)new JavaClassValidator()), OptPane.column((String)"myUntaintedFieldNames", (String)JavaeeJspBundle.message("untainted.fields.field.name", new Object[0]))}).description(JavaeeJspBundle.message("untainted.fields.description", new Object[0])), OptPane.checkbox((String)"myStaticFinalFieldsAsUntainted", (String)JavaeeJspBundle.message("untainted.fields.static.final.checkbox", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])}), OptPane.tab((String)JavaeeJspBundle.message("escape.functions.tab", new Object[0]), (OptRegularComponent[])new OptRegularComponent[]{OptPane.table((String)JavaeeJspBundle.message("escape.functions.table", new Object[0]), (OptTableColumn[])new OptTableColumn[]{OptPane.column((String)"myEscapingFunctionsNamespaces", (String)JavaeeJspBundle.message("escape.functions.table.namespace", new Object[0])), OptPane.column((String)"myEscapingFunctionsNames", (String)JavaeeJspBundle.message("escape.functions.table.name", new Object[0]), (StringValidator)stringIsNotEmptyValidator)})})})});
        if (optPane == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    public void readSettings(@NotNull Element node) {
        if (node == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(1);
        }
        super.readSettings(node);
        this.myUntaintedMethodMatcher.readSettings(node);
    }

    public void writeSettings(@NotNull Element node) {
        if (node == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(2);
        }
        super.writeSettings(node);
        this.myUntaintedMethodMatcher.writeSettings(node);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder problemsHolder, boolean isOnTheFly) {
        if (problemsHolder == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(3);
        }
        this.updateSafeTags(this.mySafeTagNamespaces, this.mySafeTagNames, this.mySafeTagAttributes, false);
        this.updateSafeTags(this.mySafeTagNamespacesForQuickFix, this.mySafeTagNamesForQuickFix, this.mySafeTagAttributesForQuickFix, true);
        this.updateEscapingFunctions(this.myEscapingFunctionsNamespaces, this.myEscapingFunctionsNames);
        return new ELElementVisitor(){

            public void visitELExpressionHolder(@NotNull ELExpressionHolder expressionHolder) {
                PsiElement[] children;
                if (expressionHolder == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((children = expressionHolder.getChildren()).length == 1) {
                    PsiElement child = children[0];
                    if (SAFE_OPERATIONS.contains(child.getNode().getElementType())) {
                        return;
                    }
                    if (child instanceof ELBinaryExpression) {
                        type = ((ELBinaryExpression)child).getOperationSign();
                        if (SAFE_OPERATIONS.contains(type)) {
                            return;
                        }
                    } else if (child instanceof ELUnaryExpression) {
                        IElementType sign = ((ELUnaryExpression)child).getOperationSign();
                        if (SAFE_OPERATIONS.contains(sign)) {
                            return;
                        }
                    } else if (child instanceof ELConditionalExpression) {
                        ELExpression then = ((ELConditionalExpression)child).getThen();
                        ELExpression anElse = ((ELConditionalExpression)child).getElse();
                        if (then instanceof ELLiteralExpression && anElse instanceof ELLiteralExpression) {
                            return;
                        }
                    } else {
                        if (child instanceof ELLiteralExpression) {
                            return;
                        }
                        if (child instanceof ELExpression) {
                            ELVariable elVariable;
                            type = ELResolveUtil.resolveContextAsType((ELExpression)((ELExpression)child));
                            if (type != null && TypeConversionUtil.isPrimitiveAndNotNullOrWrapper((PsiType)type) && !type.equals(PsiTypes.charType())) {
                                return;
                            }
                            if (child instanceof ELVariable && JspUnescapedElInspection.this.isLocalVariableThatAlreadyEscaped(elVariable = (ELVariable)child)) {
                                return;
                            }
                            if (JspUnescapedElInspection.this.isMethodOrFieldThatMarkedAsSafe(child)) {
                                return;
                            }
                        }
                    }
                }
                if (JspUnescapedElInspection.this.isEscapedByEscapingFunction(expressionHolder)) {
                    return;
                }
                XmlAttribute attributeForHolder = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlAttribute.class);
                if (attributeForHolder != null) {
                    String namespace = attributeForHolder.getParent().getNamespace();
                    if (JspUnescapedElInspection.isSafeTagNamespace(namespace)) {
                        if (ATTRIBUTES_TO_SKIP.contains(attributeForHolder.getName())) {
                            return;
                        }
                        Collection allAttributes = PsiTreeUtil.findChildrenOfType((PsiElement)attributeForHolder.getParent(), XmlAttribute.class);
                        for (XmlAttribute xmlAttribute : allAttributes) {
                            if (attributeForHolder.equals(xmlAttribute) || !ATTRIBUTES_TO_SKIP.contains(xmlAttribute.getName())) continue;
                            return;
                        }
                    }
                    if (JspUnescapedElInspection.isSafePrimitive(attributeForHolder)) {
                        return;
                    }
                    if (JspUnescapedElInspection.this.isSafeTag(attributeForHolder)) {
                        return;
                    }
                    JspUnescapedElInspection.this.reportProblem(expressionHolder, problemsHolder, attributeForHolder, JspUnescapedElInspection.this.mySuggestEscapeXml ? new EscapeByJSTL() : null);
                } else {
                    Language language;
                    PsiElement parent = expressionHolder.getParent();
                    if (parent != null && ((language = parent.getLanguage()) == NewJspLanguage.getInstance() || language == JspxLanguageImpl.INSTANCE)) {
                        JspUnescapedElInspection.this.reportProblem(expressionHolder, problemsHolder, null, null);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionHolder", "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$1", "visitELExpressionHolder"));
            }
        };
    }

    private void updateEscapingFunctions(List<String> namespaces, List<String> names) {
        for (int i = 0; i < namespaces.size(); ++i) {
            this.escapingFunctions.add(new EscapingFunctionInfo(namespaces.get(i), names.get(i)));
        }
    }

    private void updateSafeTags(List<String> namespaces, List<String> tags, List<String> attributes, boolean fix) {
        for (int i = 0; i < namespaces.size(); ++i) {
            Optional<SafeTagInfo> existing;
            String namespace = namespaces.get(i);
            String tag = tags.get(i);
            String attribute = attributes.get(i);
            if (fix && (existing = this.safeTags.stream().filter(it -> namespace.equals(it.namespace) && tag.equals(it.tagName) && attribute.equals(it.attributeName)).findFirst()).isPresent()) {
                existing.get().fix = true;
                continue;
            }
            this.safeTags.add(new SafeTagInfo(namespace, tag, attribute, fix));
        }
    }

    private boolean isSafeTag(XmlAttribute attr) {
        for (SafeTagInfo info : this.safeTags) {
            if (!info.matchAttribute(attr)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSafePrimitive(XmlAttribute attr) {
        String type;
        XmlAttributeDescriptor descriptor = attr.getDescriptor();
        return descriptor instanceof TypeAwareAttributeDescriptor && (type = ((TypeAwareAttributeDescriptor)descriptor).getType()) != null && TypeConversionUtil.isPrimitive((String)type) && !type.equals(PsiTypes.charType().getName());
    }

    private boolean isLocalVariableThatAlreadyEscaped(@NotNull ELVariable variable) {
        ELImplicitVariable elImplicitVariable;
        PsiElement declaration;
        XmlTag tag;
        PsiElement resolve;
        PsiReference reference;
        if (variable == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(4);
        }
        return (reference = variable.getReference()) != null && (resolve = reference.resolve()) instanceof ELImplicitVariable && this.isSetOrUrlTagWithEscapedValue(tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(declaration = (elImplicitVariable = (ELImplicitVariable)resolve).getDeclaration()), XmlTag.class));
    }

    private boolean isSetOrUrlTagWithEscapedValue(XmlTag tag) {
        if (tag != null && (SET_TAG.equals(tag.getLocalName()) || URL_TAG.equals(tag.getLocalName())) && JspUnescapedElInspection.isSafeTagNamespace(tag.getNamespace())) {
            XmlAttribute setTagValue = tag.getAttribute(VALUE_ATTRIBUTE);
            if (setTagValue != null) {
                XmlAttributeValue setTagValueValueElement = setTagValue.getValueElement();
                if (setTagValueValueElement != null) {
                    Object[] elExpressions = (ELExpressionHolder[])PsiTreeUtil.getChildrenOfType((PsiElement)setTagValueValueElement, ELExpressionHolder.class);
                    if (elExpressions != null && ContainerUtil.exists((Object[])elExpressions, it -> !this.isEscapedByEscapingFunction((ELExpressionHolder)it) && !this.isMethodOrFieldThatMarkedAsSafe((PsiElement)it))) {
                        return false;
                    }
                    JspExpressionImpl[] jspExpressions = (JspExpressionImpl[])PsiTreeUtil.getChildrenOfType((PsiElement)setTagValueValueElement, JspExpressionImpl.class);
                    return jspExpressions == null || !ContainerUtil.exists((Object[])jspExpressions, it -> !this.isJspExpressionMarkedAsSafe((JspExpression)it));
                }
            } else {
                XmlAttribute attribute;
                XmlTag[] nestedTags = (XmlTag[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, XmlTag.class);
                if (nestedTags != null && nestedTags.length == 1 && (attribute = nestedTags[0].getAttribute(VALUE_ATTRIBUTE)) != null && (JspUnescapedElInspection.isSafePrimitive(attribute) || this.isSafeTag(attribute))) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isSafeTagNamespace(String namespaceToCheck) {
        for (String namespace : XmlUtil.JSTL_CORE_URIS) {
            if (!namespace.equals(namespaceToCheck)) continue;
            return true;
        }
        return false;
    }

    private boolean isMethodOrFieldThatMarkedAsSafe(@Nullable PsiElement element) {
        PsiElement psiMethodOrField = JspUnescapedElInspection.getPsiMethodOrField(element);
        if (psiMethodOrField instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)psiMethodOrField;
            return this.isMethodMarkedAsSafe(psiMethod) || this.isFieldOfGetterMarkedAsSafe(psiMethod);
        }
        if (psiMethodOrField instanceof PsiField) {
            PsiField psiField = (PsiField)psiMethodOrField;
            return this.isFieldIgnoredAsAConstant(psiField);
        }
        return false;
    }

    private boolean isMethodMarkedAsSafe(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(5);
        }
        return this.myUntaintedMethodMatcher.matches(psiMethod);
    }

    private boolean isFieldOfGetterMarkedAsSafe(@NotNull PsiMethod psiMethod) {
        PsiField fieldOfGetter;
        if (psiMethod == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(6);
        }
        if ((fieldOfGetter = PropertyUtil.getFieldOfGetter((PsiMethod)psiMethod)) == null) {
            String methodName = psiMethod.getName();
            PsiClass methodContainingClass = psiMethod.getContainingClass();
            if (methodName.startsWith("get") && methodContainingClass != null) {
                String fieldName = methodName.substring(3);
                fieldOfGetter = PropertyUtilBase.findPropertyField((PsiClass)methodContainingClass, (String)fieldName, (boolean)false);
            }
        }
        if (fieldOfGetter != null && this.isFieldMarkedAsSafe(fieldOfGetter)) {
            return true;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, this.myUntaintedAnnotations, (int)2);
    }

    private boolean isFieldMarkedAsSafe(PsiField psiField) {
        PsiClass fieldOfGetterContainingClass = psiField.getContainingClass();
        if (fieldOfGetterContainingClass != null && this.myUntaintedFieldClasses.contains(fieldOfGetterContainingClass.getQualifiedName()) && ContainerUtil.exists(this.myUntaintedFieldNames, it -> psiField.getName().matches((String)it))) {
            return true;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiField, this.myUntaintedAnnotations, (int)2);
    }

    public boolean isJspExpressionMarkedAsSafe(JspExpression jspExpression) {
        String[] parts;
        String expressionText = jspExpression.getText().replace("<%=", EMPTY_STRING).replace("%>", EMPTY_STRING).trim();
        int indexOfParentheses = expressionText.indexOf("(");
        if (indexOfParentheses > -1) {
            expressionText = expressionText.substring(0, indexOfParentheses);
        }
        if ((parts = expressionText.split("\\.")).length != 2) {
            return false;
        }
        String className = parts[0].trim();
        String fieldOrMethodName = parts[1].trim();
        if (className.isEmpty() || fieldOrMethodName.isEmpty()) {
            return false;
        }
        String qualifiedName = JspUnescapedElInspection.findQualifiedName(jspExpression, className);
        if (qualifiedName == null) {
            return false;
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)jspExpression.getProject()).findClass(qualifiedName, jspExpression.getResolveScope());
        if (psiClass == null) {
            return false;
        }
        PsiMethod[] psiMethods = psiClass.findMethodsByName(fieldOrMethodName, false);
        if (psiMethods.length == 1) {
            return this.isMethodMarkedAsSafe(psiMethods[0]) || this.isFieldOfGetterMarkedAsSafe(psiMethods[0]);
        }
        PsiField psiField = psiClass.findFieldByName(fieldOrMethodName, false);
        return psiField != null && (this.isFieldIgnoredAsAConstant(psiField) || this.isFieldMarkedAsSafe(psiField));
    }

    private boolean isFieldIgnoredAsAConstant(@NotNull PsiField psiField) {
        if (psiField == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(7);
        }
        return this.myStaticFinalFieldsAsUntainted && psiField.hasModifierProperty("static") && psiField.hasModifierProperty("final");
    }

    @Nullable
    private static String findQualifiedName(@NotNull JspExpression jspExpression, @NotNull String className) {
        if (jspExpression == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(8);
        }
        if (className == null) {
            JspUnescapedElInspection.$$$reportNull$$$0(9);
        }
        if (className.isEmpty()) {
            return null;
        }
        PsiFile jspFile = jspExpression.getContainingFile();
        JspXmlDocument jspDocument = (JspXmlDocument)PsiTreeUtil.getChildOfType((PsiElement)jspFile, JspXmlDocument.class);
        if (jspDocument == null) {
            return null;
        }
        JspXmlRootTag jspXmlRootTag = (JspXmlRootTag)PsiTreeUtil.getChildOfType((PsiElement)jspDocument, JspXmlRootTag.class);
        if (jspXmlRootTag == null) {
            return null;
        }
        String capitalizedClassName = className.substring(0, 1).toUpperCase(Locale.ROOT) + className.substring(1);
        List jspDirectives = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)jspXmlRootTag, JspDirective.class);
        Optional<JspDirective> pageImport = jspDirectives.stream().filter(it -> {
            String directiveName = it.getName();
            String importValue = it.getAttributeValue("import");
            return "page".equals(directiveName) && importValue != null && importValue.endsWith(capitalizedClassName);
        }).findFirst();
        if (pageImport.isPresent()) {
            return pageImport.get().getAttributeValue("import");
        }
        List xmlTagList = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)jspXmlRootTag, XmlTag.class);
        Optional<XmlTag> tag = xmlTagList.stream().filter(it -> {
            String tagName = it.getName();
            String idValue = it.getAttributeValue("id");
            return "jsp:useBean".equals(tagName) && idValue != null && idValue.equals(className);
        }).findFirst();
        return tag.map(xmlTag -> xmlTag.getAttributeValue("type")).orElse(null);
    }

    @Nullable
    private static PsiElement getPsiMethodOrField(@Nullable PsiElement element) {
        ELVariable variable = null;
        if (element instanceof ELSelectExpression) {
            ELSelectExpression selectExpression = (ELSelectExpression)element;
            variable = selectExpression.getField();
        } else if (element instanceof ELMethodCallExpression) {
            ELMethodCallExpression methodCallExpression = (ELMethodCallExpression)element;
            variable = methodCallExpression.getMethod();
        } else {
            ELSelectExpression[] elSelectExpressionElements = (ELSelectExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)element, ELSelectExpression.class);
            if (elSelectExpressionElements != null && elSelectExpressionElements.length == 1) {
                variable = elSelectExpressionElements[0].getField();
            } else {
                ELMethodCallExpression[] elMethodCallExpressions = (ELMethodCallExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)element, ELMethodCallExpression.class);
                if (elMethodCallExpressions != null && elMethodCallExpressions.length == 1) {
                    variable = elMethodCallExpressions[0].getMethod();
                }
            }
        }
        return variable != null && variable.getReferences().length > 0 ? variable.getReferences()[0].resolve() : null;
    }

    private boolean isEscapedByEscapingFunction(ELExpressionHolder expressionHolder) {
        PsiElement psiElement;
        PsiElement[] children = expressionHolder.getChildren();
        if (children.length == 1 && (psiElement = children[0]) instanceof ELFunctionCallExpression) {
            ELFunctionCallExpression call = (ELFunctionCallExpression)psiElement;
            String functionName = call.getFunctionName();
            String namespacePrefix = call.getNamespace().getName();
            String functionCallNamespace = JspUnescapedElInspection.getFunctionCallNamespace(expressionHolder, namespacePrefix);
            List foundEscapingFunctions = ContainerUtil.filter(this.escapingFunctions, it -> it.getFunctionName().equals(functionName));
            if (!foundEscapingFunctions.isEmpty()) {
                Set<String> escapingNamespaces = foundEscapingFunctions.stream().map(it -> it.getNamespaceUri()).collect(Collectors.toSet());
                return JspUnescapedElInspection.containsFunctionNamespaceInEscapingSet(escapingNamespaces, functionCallNamespace);
            }
        }
        return false;
    }

    private static boolean containsFunctionNamespaceInEscapingSet(Set<String> escapingNamespaces, String functionCallNamespace) {
        for (String escapingNamespace : escapingNamespaces) {
            if (!escapingNamespace.isEmpty() && !escapingNamespace.equals(functionCallNamespace) && (!JSTL_FUNCTIONS_URIS_LIST.contains(escapingNamespace) || !JSTL_FUNCTIONS_URIS_LIST.contains(functionCallNamespace))) continue;
            return true;
        }
        return false;
    }

    private static String getFunctionCallNamespace(ELExpressionHolder expressionHolder, String namespacePrefix) {
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)expressionHolder, XmlTag.class);
        if (parentTag != null) {
            return XmlUtil.findNamespaceByPrefix((String)namespacePrefix, (XmlTag)parentTag);
        }
        return null;
    }

    private void reportProblem(ELExpressionHolder expressionHolder, ProblemsHolder problemsHolder, @Nullable XmlAttribute attribute, @Nullable LocalQuickFix additional) {
        XmlTag tag;
        BaseJspFile jspFile = BaseJspUtil.getJspFile((PsiElement)expressionHolder);
        ArrayList<RegisterAsSafeFix> fixes = new ArrayList<RegisterAsSafeFix>(ContainerUtil.mapNotNull(this.safeTags, tagInfo -> {
            if (jspFile == null || ExtendedTagInsertHandler.suggestPrefix((XmlFile)jspFile, (String)tagInfo.namespace) == null) {
                return null;
            }
            return tagInfo.fix ? new WrapInTagFix((SafeTagInfo)tagInfo) : null;
        }));
        ContainerUtil.addIfNotNull(fixes, (Object)additional);
        if (attribute != null && (tag = attribute.getParent()) != null) {
            fixes.add(new RegisterAsSafeFix(JavaeeJspBundle.message("intention.name.register.as.safe.place", tag.getLocalName(), attribute.getLocalName())));
            fixes.add(new RegisterAsSafeFix(JavaeeJspBundle.message("intention.name.register.tag.as.safe.place", tag.getLocalName())){

                @Override
                protected SafeTagInfo createInfo(XmlAttribute attribute) {
                    return new SafeTagInfo(attribute.getParent().getNamespace(), attribute.getParent().getLocalName(), JspUnescapedElInspection.EMPTY_STRING);
                }
            });
            fixes.add(new RegisterAsSafeFix(JavaeeJspBundle.message("intention.name.register.all.tags.from.as.safe", tag.getNamespace())){

                @Override
                protected SafeTagInfo createInfo(XmlAttribute attribute) {
                    return new SafeTagInfo(attribute.getParent().getNamespace(), JspUnescapedElInspection.EMPTY_STRING, JspUnescapedElInspection.EMPTY_STRING);
                }
            });
        }
        fixes.addAll(ContainerUtil.map(this.myUntaintedAnnotationsForQuickFix, it -> new AnnotateAsSafeFix((String)it)));
        problemsHolder.registerProblem((PsiElement)expressionHolder, JavaeeJspBundle.message("inspection.message.unescaped.el.expression", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jspExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLocalVariableThatAlreadyEscaped";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMethodMarkedAsSafe";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFieldOfGetterMarkedAsSafe";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isFieldIgnoredAsAConstant";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findQualifiedName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }

    private class RegisterAsSafeFix
    implements LocalQuickFix {
        @IntentionName
        private final String myName;

        RegisterAsSafeFix(String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaeeJspBaseBundle.message("jsp.inspections.group.name", new Object[0]);
            if (string == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            XmlAttribute attribute;
            if (project == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RegisterAsSafeFix.$$$reportNull$$$0(3);
            }
            if ((attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), XmlAttribute.class)) != null) {
                InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile().modifyToolSettings(Key.create((String)JspUnescapedElInspection.this.getShortName()), descriptor.getPsiElement(), inspection -> {
                    SafeTagInfo safeTagInfo = this.createInfo(attribute);
                    inspection.safeTags.add(safeTagInfo);
                    inspection.mySafeTagNamespaces.add(safeTagInfo.namespace);
                    inspection.mySafeTagNames.add(safeTagInfo.tagName);
                    inspection.mySafeTagAttributes.add(safeTagInfo.attributeName);
                });
            }
        }

        protected SafeTagInfo createInfo(XmlAttribute attribute) {
            XmlTag tag = attribute.getParent();
            return new SafeTagInfo(tag.getNamespace(), tag.getLocalName(), attribute.getLocalName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$RegisterAsSafeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class AnnotateAsSafeFix
    implements LocalQuickFix {
        private final String mySafeAnnotation;

        AnnotateAsSafeFix(String safeAnnotation) {
            this.mySafeAnnotation = safeAnnotation;
        }

        @NotNull
        public String getName() {
            String string = JavaeeJspBundle.message("untainted.annotations.quick.fix", this.mySafeAnnotation);
            if (string == null) {
                AnnotateAsSafeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaeeJspBaseBundle.message("jsp.inspections.group.name", new Object[0]);
            if (string == null) {
                AnnotateAsSafeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement child;
            PsiElement psiElement;
            if (project == null) {
                AnnotateAsSafeFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                AnnotateAsSafeFix.$$$reportNull$$$0(3);
            }
            if ((psiElement = JspUnescapedElInspection.getPsiMethodOrField(child = descriptor.getPsiElement().getChildren()[0])) instanceof PsiMethod) {
                PsiMethod psiMethod = (PsiMethod)psiElement;
                PsiField fieldOfGetter = PropertyUtil.getFieldOfGetter((PsiMethod)psiMethod);
                PsiField target = fieldOfGetter != null ? fieldOfGetter : psiMethod;
                ApplicationManager.getApplication().runWriteAction(() -> this.lambda$applyFix$0(project, (PsiModifierListOwner)target));
            }
        }

        private static void annotateFieldOrMethod(Project project, PsiModifierListOwner fieldOrMethod, String annotationFQN) {
            PsiModifierList modifierList = fieldOrMethod.getModifierList();
            if (modifierList == null) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(fieldOrMethod.getContainingFile())) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiAnnotation annotation = factory.createAnnotationFromText("@" + annotationFQN, (PsiElement)fieldOrMethod);
            PsiElement firstChild = modifierList.getFirstChild();
            if (firstChild != null) {
                modifierList.addBefore((PsiElement)annotation, firstChild);
            } else {
                modifierList.add((PsiElement)annotation);
            }
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)modifierList);
        }

        private /* synthetic */ void lambda$applyFix$0(Project project, PsiModifierListOwner target) {
            AnnotateAsSafeFix.annotateFieldOrMethod(project, target, this.mySafeAnnotation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$AnnotateAsSafeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$AnnotateAsSafeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class EscapeByJSTL
    extends AbstractWrapFix {
        private EscapeByJSTL() {
        }

        @NotNull
        public String getName() {
            String string = JavaeeJspBundle.message("intention.name.wrap.in.jstl.escape.xml.function", new Object[0]);
            if (string == null) {
                EscapeByJSTL.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                EscapeByJSTL.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected String getNamespace() {
            return "http://java.sun.com/jsp/jstl/functions";
        }

        @Override
        protected PsiElement getElementToReplace(PsiElement holder) {
            return holder.getChildren()[0];
        }

        @Override
        protected StringBuilder buildNewText(String prefix, String text) {
            return new StringBuilder().append(prefix).append(":escapeXml(").append(text).append(')');
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                EscapeByJSTL.$$$reportNull$$$0(2);
            }
            if (previewDescriptor == null) {
                EscapeByJSTL.$$$reportNull$$$0(3);
            }
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                EscapeByJSTL.$$$reportNull$$$0(4);
            }
            return intentionPreviewInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$EscapeByJSTL";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jsp/javaee/web/inspections/unescapedEl/JspUnescapedElInspection$EscapeByJSTL";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "generatePreview";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

