/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.microservices.jvm.callsites.ArgumentCallSite;
import com.intellij.microservices.jvm.callsites.ArgumentCallSiteCollector;
import com.intellij.microservices.jvm.callsites.MethodArgument;
import com.intellij.microservices.jvm.mq.CallSiteMQTargetInfo;
import com.intellij.microservices.jvm.mq.MQAccessType;
import com.intellij.microservices.jvm.mq.MQAccessTypes;
import com.intellij.microservices.jvm.mq.MQResolver;
import com.intellij.microservices.jvm.mq.MQResolverFactory;
import com.intellij.microservices.jvm.mq.MQTargetInfo;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.MQTypes;
import com.intellij.openapi.project.Project;
import com.intellij.spring.messaging.providers.SpringJmsTemplateMQResolver;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/messaging/providers/SpringKafkaTemplateMQResolver;", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/microservices/jvm/mq/MQType;", "collector", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/jvm/mq/MQType;Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;)V", "supportedTypes", "", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/jvm/mq/MQTargetInfo;", "typeHint", "Companion", "Factory", "intellij.spring.messaging"})
public final class SpringKafkaTemplateMQResolver
implements MQResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final MQType type;
    @NotNull
    private final ArgumentCallSiteCollector collector;
    @NotNull
    private final List<MQType> supportedTypes;
    @NotNull
    private static final ArgumentCallSiteCollector KAFKA_SEND_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector KAFKA_METADATA_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector KAFKA_TOPIC_OPERATIONS_COLLECTOR;

    public SpringKafkaTemplateMQResolver(@NotNull Project project, @NotNull MQType type, @NotNull ArgumentCallSiteCollector collector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.project = project;
        this.type = type;
        this.collector = collector;
        this.supportedTypes = CollectionsKt.listOf((Object)this.type);
    }

    @NotNull
    public List<MQType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @NotNull
    public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)this.collector.getCallSitesSequence(this.project), arg_0 -> SpringKafkaTemplateMQResolver.getVariants$lambda$0(this, arg_0)));
    }

    private static final CallSiteMQTargetInfo getVariants$lambda$0(SpringKafkaTemplateMQResolver this$0, ArgumentCallSite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MQType mQType = this$0.type;
        Object object = this$0.collector.getUserData(MQAccessType.KEY);
        Intrinsics.checkNotNull((Object)object);
        return new CallSiteMQTargetInfo(it, mQType, (MQAccessType)object);
    }

    static {
        MethodArgument[] methodArgumentArray = new MethodArgument[]{new MethodArgument("org.springframework.kafka.core.KafkaOperations", "send", 0, 0, 8, null), new MethodArgument("org.springframework.kafka.core.KafkaTemplate", "send", 0, 0, 8, null)};
        MethodArgument[] $this$KAFKA_SEND_OPERATIONS_COLLECTOR_u24lambda_u241 = methodArgumentArray = new ArgumentCallSiteCollector("SPRING_KAFKA_SEND_OPERATIONS_DESTINATION", CollectionsKt.listOf((Object[])methodArgumentArray), null, 4, null);
        boolean bl = false;
        $this$KAFKA_SEND_OPERATIONS_COLLECTOR_u24lambda_u241.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_TYPE);
        KAFKA_SEND_OPERATIONS_COLLECTOR = methodArgumentArray;
        methodArgumentArray = new MethodArgument[]{new MethodArgument("org.springframework.kafka.core.KafkaOperations", "partitionsFor", 0, 0, 8, null), new MethodArgument("org.springframework.kafka.core.KafkaTemplate", "partitionsFor", 0, 0, 8, null), new MethodArgument("org.springframework.kafka.core.reactive.ReactiveKafkaConsumerTemplate", "partitionsFromConsumerFor", 0, 0, 8, null)};
        MethodArgument[] $this$KAFKA_METADATA_OPERATIONS_COLLECTOR_u24lambda_u242 = methodArgumentArray = new ArgumentCallSiteCollector("SPRING_KAFKA_METADATA_OPERATIONS_DESTINATION", CollectionsKt.listOf((Object[])methodArgumentArray), null, 4, null);
        boolean bl2 = false;
        $this$KAFKA_METADATA_OPERATIONS_COLLECTOR_u24lambda_u242.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.ADMINISTRATION_TYPE);
        KAFKA_METADATA_OPERATIONS_COLLECTOR = methodArgumentArray;
        methodArgumentArray = new MethodArgument[]{new MethodArgument("org.springframework.kafka.core.KafkaTemplate", "setDefaultTopic", 0, 0, 8, null), new MethodArgument("org.springframework.kafka.config.TopicBuilder", "name", 0, 0, 8, null)};
        MethodArgument[] $this$KAFKA_TOPIC_OPERATIONS_COLLECTOR_u24lambda_u243 = methodArgumentArray = new ArgumentCallSiteCollector("SPRING_KAFKA_TOPIC_OPERATIONS_DESTINATION", CollectionsKt.listOf((Object[])methodArgumentArray), null, 4, null);
        boolean bl3 = false;
        $this$KAFKA_TOPIC_OPERATIONS_COLLECTOR_u24lambda_u243.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.UNKNOWN_TYPE);
        KAFKA_TOPIC_OPERATIONS_COLLECTOR = methodArgumentArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/spring/messaging/providers/SpringKafkaTemplateMQResolver$Companion;", "", "<init>", "()V", "KAFKA_SEND_OPERATIONS_COLLECTOR", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "KAFKA_METADATA_OPERATIONS_COLLECTOR", "KAFKA_TOPIC_OPERATIONS_COLLECTOR", "intellij.spring.messaging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/messaging/providers/SpringKafkaTemplateMQResolver$Factory;", "Lcom/intellij/microservices/jvm/mq/MQResolverFactory;", "<init>", "()V", "forProject", "", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.messaging"})
    public static final class Factory
    implements MQResolverFactory {
        @NotNull
        public List<MQResolver> forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!SpringMQUtils.INSTANCE.hasSpringKafkaLibrary(project)) {
                return CollectionsKt.emptyList();
            }
            Object[] objectArray = new SpringJmsTemplateMQResolver[]{new SpringJmsTemplateMQResolver(project, (MQType)MQTypes.KAFKA_TOPIC_TYPE, KAFKA_SEND_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)MQTypes.KAFKA_TOPIC_TYPE, KAFKA_METADATA_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)MQTypes.KAFKA_TOPIC_TYPE, KAFKA_TOPIC_OPERATIONS_COLLECTOR)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

