/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.persistence.database;

import com.intellij.database.psi.DbDataSource;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.database.ConfigDataSourceCandidate;
import com.intellij.persistence.database.ConfigDataSourceProcessor;
import com.intellij.persistence.database.ConfigDataSourcePropertyInfo;
import com.intellij.persistence.database.ConfigDataSourceService;
import com.intellij.persistence.database.ConfigurationFileInfo;
import com.intellij.persistence.database.DataSourceConfigType;
import com.intellij.persistence.database.RecognizedDatabaseConfig;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH$J$\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/persistence/database/ConfigDataSourceSinglePropertyProcessor;", "T", "Lcom/intellij/persistence/database/DataSourceConfigType;", "I", "Lcom/intellij/persistence/database/ConfigDataSourcePropertyInfo;", "Lcom/intellij/persistence/database/ConfigDataSourceProcessor;", "<init>", "()V", "getCandidate", "Lcom/intellij/persistence/database/ConfigDataSourceCandidate;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getPropertyCandidate", "provideRecognizedConfigsToExistingDatasource", "", "Lcom/intellij/persistence/database/RecognizedDatabaseConfig;", "Lcom/intellij/database/psi/DbDataSource;", "intellij.javaee.persistence"})
@SourceDebugExtension(value={"SMAP\nConfigDataSourceProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigDataSourceProcessor.kt\ncom/intellij/persistence/database/ConfigDataSourceSinglePropertyProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1285#2,2:98\n1299#2,4:100\n*S KotlinDebug\n*F\n+ 1 ConfigDataSourceProcessor.kt\ncom/intellij/persistence/database/ConfigDataSourceSinglePropertyProcessor\n*L\n62#1:98,2\n62#1:100,4\n*E\n"})
public abstract class ConfigDataSourceSinglePropertyProcessor<T extends DataSourceConfigType, I extends ConfigDataSourcePropertyInfo>
implements ConfigDataSourceProcessor<T, I> {
    @Nullable
    public final ConfigDataSourceCandidate<T, I> getCandidate(@NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!this.isApplicable(null, element.getProject())) {
            return null;
        }
        return this.getPropertyCandidate(editor, element);
    }

    @Nullable
    protected abstract ConfigDataSourceCandidate<T, I> getPropertyCandidate(@NotNull Editor var1, @NotNull PsiElement var2);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<RecognizedDatabaseConfig, DbDataSource> provideRecognizedConfigsToExistingDatasource(@NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ConfigDataSourceCandidate<T, I> configDataSourceCandidate = this.getPropertyCandidate(editor, element);
        if (configDataSourceCandidate == null) {
            return MapsKt.emptyMap();
        }
        ConfigDataSourceCandidate<T, I> candidate = configDataSourceCandidate;
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return MapsKt.emptyMap();
        }
        Module module2 = module;
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        ConfigurationFileInfo fileInfo = new ConfigurationFileInfo(psiFile, module2);
        ConfigDataSourceService service = ConfigDataSourceService.Companion.getInstance();
        Iterable $this$associateWith$iv = this.getDataSourceProvider().retrieveConfigs(fileInfo, candidate);
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            RecognizedDatabaseConfig recognizedDatabaseConfig = (RecognizedDatabaseConfig)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            String string = it.getUrl();
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            DbDataSource dbDataSource = service.findExistingDatasource(string, project);
            map.put(t, dbDataSource);
        }
        return result$iv;
    }
}

