/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.rd.util.RdCoroutinesUtilKt;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.remoteDev.util.RemoteDevProtocolUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.EDT;
import com.jetbrains.gateway.GatewayBundle;
import com.jetbrains.gateway.api.ConnectionRequestor;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayConnectionProvider;
import com.jetbrains.gateway.api.GatewayConnector;
import com.jetbrains.gateway.api.GatewayCustomViewConnector;
import com.jetbrains.gateway.api.GatewayUI;
import com.jetbrains.gateway.connection.GatewayConnectionFrameManager;
import com.jetbrains.gateway.impl.GatewayStarter;
import com.jetbrains.gateway.impl.GatewayUIState;
import com.jetbrains.gateway.ssh.util.RemoteRecentProjectsHelperExtension;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenPanel;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeScreenSelectTabTopicKt;
import com.jetbrains.gateway.welcomeScreen.WelcomeScreenTabSelectionListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.Signal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="GatewayUIService", storages={@Storage(value="GatewayUIService.xml")})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 )2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001)B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fJ\b\u0010\u0014\u001a\u00020\bH\u0016J\b\u0010\u0015\u001a\u00020\bH\u0016J\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u000fH\u0016J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J,\u0010 \u001a\u00020\b2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0\"2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000fH\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010&\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010$\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/gateway/impl/GatewayUIService;", "Lcom/jetbrains/gateway/api/GatewayUI;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/jetbrains/gateway/impl/GatewayUIState;", "<init>", "()V", "connected", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getConnected", "()Lcom/jetbrains/rd/util/reactive/Signal;", "currentPanel", "Lcom/jetbrains/gateway/welcomeScreen/GatewayWelcomeScreenPanel;", "onResetActions", "", "Lkotlin/Function0;", "setupGatewayPanel", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "panel", "reset", "resetEx", "onReset", "action", "navigateToConnectorTab", "connectorRecentsId", "", "showConnectorView", "connectorId", "token", "getToken", "()Ljava/lang/String;", "connect", "parameters", "", "onDone", "tempLastConnectorId", "getLastConnectorId", "setLastConnectorId", "temp", "", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nGatewayUIService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GatewayUIService.kt\ncom/jetbrains/gateway/impl/GatewayUIService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,165:1\n1869#2,2:166\n1563#2:168\n1634#2,3:169\n14#3:172\n*S KotlinDebug\n*F\n+ 1 GatewayUIService.kt\ncom/jetbrains/gateway/impl/GatewayUIService\n*L\n56#1:166,2\n94#1:168\n94#1:169,3\n33#1:172\n*E\n"})
public final class GatewayUIService
extends SimplePersistentStateComponent<GatewayUIState>
implements GatewayUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Signal<Unit> connected = new Signal();
    @Nullable
    private GatewayWelcomeScreenPanel currentPanel;
    @NotNull
    private final List<Function0<Unit>> onResetActions = new ArrayList();
    @NotNull
    private final String token;
    @Nullable
    private String tempLastConnectorId;
    @NotNull
    private static final Logger logger;

    public GatewayUIService() {
        super((BaseState)new GatewayUIState());
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this.token = string;
    }

    @NotNull
    public final Signal<Unit> getConnected() {
        return this.connected;
    }

    public final void setupGatewayPanel(@NotNull Lifetime lifetime, @NotNull GatewayWelcomeScreenPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
        this.currentPanel = panel2;
        lifetime.onTermination(() -> GatewayUIService.setupGatewayPanel$lambda$0(this));
    }

    @Override
    public void reset() {
        block0: {
            EDT.assertIsEdt();
            logger.debug("Reset gateway main panel");
            GatewayWelcomeScreenPanel gatewayWelcomeScreenPanel = this.currentPanel;
            if (gatewayWelcomeScreenPanel == null) break block0;
            gatewayWelcomeScreenPanel.reset();
        }
    }

    @Override
    public void resetEx() {
        this.reset();
        Iterable $this$forEach$iv = this.onResetActions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    @Override
    public void onReset(@NotNull Lifetime lifetime, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        lifetime.executeIfAlive(() -> GatewayUIService.onReset$lambda$3(this, action, lifetime));
    }

    @Override
    public void navigateToConnectorTab(@Nullable String connectorRecentsId) {
        block0: {
            WelcomeFrame.Companion.showNow();
            String string = connectorRecentsId;
            if (string == null) break block0;
            String id = string;
            boolean bl = false;
            ((WelcomeScreenTabSelectionListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(GatewayWelcomeScreenSelectTabTopicKt.getWELCOME_SCREEN_SELECT_TAB_TOPIC())).selectRecentConnectionsTab(id);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void showConnectorView(@NotNull String connectorId) {
        Object v0;
        List<GatewayConnector> connectors;
        block6: {
            Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
            if (this.currentPanel == null) {
                WelcomeFrame.Companion.showNow();
            }
            connectors = GatewayConnector.Companion.getConnectors();
            Iterable iterable = connectors;
            for (Object t : iterable) {
                GatewayConnector it = (GatewayConnector)t;
                boolean bl = false;
                if (!(!(it instanceof GatewayCustomViewConnector) && Intrinsics.areEqual((Object)it.getConnectorId(), (Object)connectorId))) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        GatewayConnector connector = v0;
        if (connector != null) {
            GatewayWelcomeScreenPanel gatewayWelcomeScreenPanel = this.currentPanel;
            if (gatewayWelcomeScreenPanel != null) {
                gatewayWelcomeScreenPanel.createConnectorView(connector);
            }
        } else {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = connectors;
            String string = connectorId;
            Logger logger = GatewayUIService.logger;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                GatewayConnector gatewayConnector = (GatewayConnector)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getConnectorId());
            }
            collection = (List)destination$iv$iv;
            logger.error("Registered connector with id: " + string + " not found, existent = " + (List)collection);
        }
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @Override
    public void connect(@NotNull Map<String, String> parameters, @Nullable Function0<Unit> onDone2) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        logger.debug("Connect request...");
        if (PlatformUtils.isGateway()) {
            GatewayConnectionProvider.Companion.connect(parameters, ConnectionRequestor.Local, (Function1<? super GatewayConnectionHandle, Unit>)((Function1)arg_0 -> GatewayUIService.connect$lambda$8(onDone2, this, arg_0)));
            return;
        }
        Function0 startGatewayFunction2 = () -> GatewayUIService.connect$lambda$10(parameters, this);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> GatewayUIService.connect$lambda$11(startGatewayFunction2), GatewayBundle.INSTANCE.message("ui.service.gateway.process.title", new Object[0]), false, null);
        this.reset();
        this.connected.fire((Object)Unit.INSTANCE);
    }

    @Override
    @Nullable
    public String getLastConnectorId() {
        String tempL = this.tempLastConnectorId;
        if (tempL != null) {
            this.tempLastConnectorId = null;
            return tempL;
        }
        return ((GatewayUIState)this.getState()).getLastSelectedConnectorId();
    }

    @Override
    public void setLastConnectorId(@NotNull String connectorId, boolean temp) {
        Intrinsics.checkNotNullParameter((Object)connectorId, (String)"connectorId");
        if (temp) {
            this.tempLastConnectorId = connectorId;
        } else {
            ((GatewayUIState)this.getState()).setLastSelectedConnectorId(connectorId);
        }
    }

    private static final Unit setupGatewayPanel$lambda$0(GatewayUIService this$0) {
        this$0.currentPanel = null;
        return Unit.INSTANCE;
    }

    private static final Unit onReset$lambda$3$lambda$2(GatewayUIService this$0, Function0 $action) {
        this$0.onResetActions.remove($action);
        return Unit.INSTANCE;
    }

    private static final Unit onReset$lambda$3(GatewayUIService this$0, Function0 $action, Lifetime $lifetime) {
        this$0.onResetActions.add((Function0<Unit>)$action);
        $lifetime.onTermination(() -> GatewayUIService.onReset$lambda$3$lambda$2(this$0, $action));
        return Unit.INSTANCE;
    }

    private static final Unit connect$lambda$8(Function0 $onDone, GatewayUIService this$0, GatewayConnectionHandle handle2) {
        block1: {
            if (handle2 == null) break block1;
            GatewayConnectionFrameManager.Companion.getInstance().closeWelcomeFrame();
            Function0 function0 = $onDone;
            if (function0 != null) {
                Function0 it = function0;
                boolean bl = false;
                this$0.connected.fire((Object)Unit.INSTANCE);
                it.invoke();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit connect$lambda$10$lambda$9(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List helpers = RemoteRecentProjectsHelperExtension.Companion.getEP().getExtensionList();
        for (RemoteRecentProjectsHelperExtension helper : helpers) {
            if (!helper.canHandleMessage(it)) continue;
            RdCoroutinesUtilKt.launchOnUi$default((Lifetime)Lifetime.Companion.getEternal(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(helper, it, null){
                int label;
                final /* synthetic */ RemoteRecentProjectsHelperExtension $helper;
                final /* synthetic */ String $it;
                {
                    this.$helper = $helper;
                    this.$it = $it;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.$helper.addToRecent(this.$it);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit connect$lambda$10(Map $parameters, GatewayUIService this$0) {
        String url = RemoteDevProtocolUtil.INSTANCE.createGatewayUrl(MapsKt.plus((Map)$parameters, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"runFromIdeToken", (Object)this$0.token))));
        GatewayStarter.INSTANCE.runGatewayProcess(url, (Pair<String, String>)TuplesKt.to((Object)"GTW_FROM_IDE_TOKEN", (Object)this$0.token), (Function1<? super String, Unit>)((Function1)GatewayUIService::connect$lambda$10$lambda$9));
        Thread.sleep(3000L);
        return Unit.INSTANCE;
    }

    private static final void connect$lambda$11(Function0 $tmp0) {
        $tmp0.invoke();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GatewayUIService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        GatewayUIService.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/impl/GatewayUIService$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getServiceInstance", "Lcom/jetbrains/gateway/impl/GatewayUIService;", "intellij.gateway.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GatewayUIService getServiceInstance() {
            GatewayUI gatewayUI = GatewayUI.Companion.getInstance();
            Intrinsics.checkNotNull((Object)gatewayUI, (String)"null cannot be cast to non-null type com.jetbrains.gateway.impl.GatewayUIService");
            return (GatewayUIService)gatewayUI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

