/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway;

import com.intellij.flyway.FlywayCallbackEvent;
import com.intellij.flyway.JavaCallbackModel;
import com.intellij.flyway.JavaMigrationModel;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.util.HProjectUtils;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rJ \u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J \u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/intellij/flyway/FlywayCreator;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createMigrationFile", "Lcom/intellij/psi/PsiFile;", "directory", "Lcom/intellij/psi/PsiDirectory;", "fileName", "", "source", "createJavaMigrationFile", "model", "Lcom/intellij/flyway/JavaMigrationModel;", "targetDirectory", "generationLanguage", "Lcom/intellij/jpa/jpb/model/model/SourceLanguage;", "createJavaCallbackFile", "callbackModel", "Lcom/intellij/flyway/JavaCallbackModel;", "getFlywayCallbackTemplate", "getFlywayJavaMigrationTemplate", "convertEvents", "eventParamName", "events", "", "Lcom/intellij/flyway/FlywayCallbackEvent;", "Companion", "intellij.flyway"})
public final class FlywayCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public FlywayCreator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final PsiFile createMigrationFile(@NotNull PsiDirectory directory, @NotNull String fileName, @NotNull String source) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("MIGRATION_SOURCE", source);
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate("com.intellij.jpb.FlywayMigrationScript.sql");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)props, (PsiDirectory)directory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            psiFile = element.getContainingFile();
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create flyway SQL migration file: '" + fileName + "'"), (Throwable)e).post(this.project);
            psiFile = null;
        }
        return psiFile;
    }

    public static /* synthetic */ PsiFile createMigrationFile$default(FlywayCreator flywayCreator, PsiDirectory psiDirectory, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = "";
        }
        return flywayCreator.createMigrationFile(psiDirectory, string, string2);
    }

    @Nullable
    public final PsiFile createJavaMigrationFile(@NotNull JavaMigrationModel model, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage generationLanguage) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)generationLanguage, (String)"generationLanguage");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("NAME", model.getClassName());
        props.setProperty("PACKAGE_NAME", model.getPackageName());
        boolean hasJdbcTemplate = HProjectUtils.isClassAvailableInLibraries((Project)this.project, (String)"org.springframework.jdbc.core.JdbcTemplate");
        props.setProperty("HAS_JDBC_TEMPLATE", String.valueOf(hasJdbcTemplate));
        props.setProperty("IS_COMMUNITY_IDEA", String.valueOf(!JpaUtils.isUltimate()));
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getFlywayJavaMigrationTemplate(generationLanguage));
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)model.getClassName(), (Properties)props, (PsiDirectory)targetDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            psiFile = element.getContainingFile();
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create Flyway java migration: '" + model.getClassName() + "'"), (Throwable)e).post(this.project);
            psiFile = null;
        }
        return psiFile;
    }

    @Nullable
    public final PsiFile createJavaCallbackFile(@NotNull JavaCallbackModel callbackModel, @NotNull PsiDirectory targetDirectory, @NotNull SourceLanguage generationLanguage) {
        PsiFile psiFile;
        Intrinsics.checkNotNullParameter((Object)callbackModel, (String)"callbackModel");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkNotNullParameter((Object)generationLanguage, (String)"generationLanguage");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Properties properties = templateManager.getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties props = properties;
        props.setProperty("NAME", callbackModel.getClassName());
        props.setProperty("PACKAGE_NAME", callbackModel.getPackageName());
        props.setProperty("CALLBACK_NAME", callbackModel.getCallbackName());
        props.setProperty("CAN_HANDLE_IN_TRANSACTION", String.valueOf(callbackModel.getCanHandleInTransaction()));
        String eventParamName = "event";
        props.setProperty("EVENT_PARAM_NAME", eventParamName);
        props.setProperty("EVENTS", this.convertEvents(eventParamName, generationLanguage, callbackModel.getEvents()));
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(this.getFlywayCallbackTemplate(generationLanguage));
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        try {
            PsiElement psiElement = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)callbackModel.getClassName(), (Properties)props, (PsiDirectory)targetDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"createFromTemplate(...)");
            PsiElement element = psiElement;
            psiFile = element.getContainingFile();
        }
        catch (Exception e) {
            new ExceptionEvent((Object)("Exception while trying to create Flyway java callback: '" + callbackModel.getClassName() + "'"), (Throwable)e).post(this.project);
            psiFile = null;
        }
        return psiFile;
    }

    private final String getFlywayCallbackTemplate(SourceLanguage generationLanguage) {
        return generationLanguage == SourceLanguage.KOTLIN ? "com.intellij.jpb.FlywayCallback.kt" : "com.intellij.jpb.FlywayCallback.java";
    }

    private final String getFlywayJavaMigrationTemplate(SourceLanguage generationLanguage) {
        return generationLanguage == SourceLanguage.KOTLIN ? "com.intellij.jpb.FlywayMigration.kt" : "com.intellij.jpb.FlywayMigration.java";
    }

    private final String convertEvents(String eventParamName, SourceLanguage generationLanguage, List<? extends FlywayCallbackEvent> events) {
        return CollectionsKt.joinToString$default((Iterable)events, (CharSequence)" || ", null, null, (int)0, null, arg_0 -> FlywayCreator.convertEvents$lambda$0(generationLanguage, eventParamName, arg_0), (int)30, null);
    }

    private static final CharSequence convertEvents$lambda$0(SourceLanguage $generationLanguage, String $eventParamName, FlywayCallbackEvent it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return $generationLanguage == SourceLanguage.KOTLIN ? (CharSequence)($eventParamName + " == Event." + it.name()) : (CharSequence)($eventParamName + ".equals(Event." + it.name() + ")");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/flyway/FlywayCreator$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/flyway/FlywayCreator;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.flyway"})
    @SourceDebugExtension(value={"SMAP\nFlywayCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayCreator.kt\ncom/intellij/flyway/FlywayCreator$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,128:1\n30#2,2:129\n*S KotlinDebug\n*F\n+ 1 FlywayCreator.kt\ncom/intellij/flyway/FlywayCreator$Companion\n*L\n21#1:129,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlywayCreator getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FlywayCreator> serviceClass$iv = FlywayCreator.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FlywayCreator)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

