/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flyway;

import com.intellij.flyway.FlywaySearchHelper;
import com.intellij.flyway.ext.MigrationVersion;
import com.intellij.flyway.ext.ResourceName;
import com.intellij.flyway.ext.ResourceNameParser;
import com.intellij.jpa.jpb.model.backend.props.SpringPropertiesConfiguration;
import com.intellij.jpa.jpb.model.backend.props.SpringPropertiesConfigurationKt;
import com.intellij.jpa.jpb.model.core.es.BuildVersion;
import com.intellij.jpa.jpb.model.core.es.ExternalSystemInfo;
import com.intellij.jpa.jpb.model.core.util.JpbVfsUtil;
import com.intellij.jpa.jpb.model.properties.PropertySource;
import com.intellij.jpa.jpb.model.properties.SpringProperty;
import com.intellij.jpa.jpb.model.util.DiffHelper;
import com.intellij.liquibase.common.FormatterTemplate;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u000fH\u0002J\u0006\u0010\u0017\u001a\u00020\u000bJ\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/flyway/FlywayHelper;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "dbMigrationState", "Lcom/intellij/liquibase/common/config/DatabaseMigrationState;", "generateVersionedName", "", "existScriptNames", "", "module", "Lcom/intellij/openapi/module/Module;", "generateChangelogDirPath", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "generateFlywayDir", "findSourceRootsForChangelog", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFirstFlywayLocation", "findFlywayLocationInPropertySources", "allPropertySources", "", "Lcom/intellij/jpa/jpb/model/properties/PropertySource;", "Companion", "FlywayLibrary", "FlywayFormatterTemplate", "intellij.flyway"})
@SourceDebugExtension(value={"SMAP\nFlywayHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayHelper.kt\ncom/intellij/flyway/FlywayHelper\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n37#2:196\n36#2,3:197\n1#3:200\n1#3:211\n1617#4,9:201\n1869#4:210\n1870#4:212\n1626#4:213\n*S KotlinDebug\n*F\n+ 1 FlywayHelper.kt\ncom/intellij/flyway/FlywayHelper\n*L\n71#1:196\n71#1:197,3\n118#1:211\n118#1:201,9\n118#1:210\n118#1:212\n118#1:213\n*E\n"})
public final class FlywayHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DatabaseMigrationState dbMigrationState;
    @NotNull
    public static final String SEMANTIC_VERSION_VAR_NAME = "semVer";

    public FlywayHelper(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.dbMigrationState = DatabaseMigrationConfig.Companion.getInstance(this.project).getState();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String generateVersionedName(@NotNull Collection<String> existScriptNames, @Nullable Module module) {
        Map map;
        String versionPattern;
        Intrinsics.checkNotNullParameter(existScriptNames, (String)"existScriptNames");
        String string = this.dbMigrationState.getFlywayVersionPattern();
        if (string == null) {
            string = "1";
        }
        if (StringsKt.contains$default((CharSequence)(versionPattern = string), (CharSequence)"${semVer", (boolean)false, (int)2, null)) {
            BuildVersion buildVersion = ExternalSystemInfo.Companion.findBuildVersion(this.project);
            if (buildVersion == null) {
                buildVersion = new BuildVersion("0.0.1", 0, 0, 1, null, null, 48, null);
            }
            BuildVersion buildVersion2 = buildVersion;
            map = MapsKt.mapOf((Pair)TuplesKt.to((Object)SEMANTIC_VERSION_VAR_NAME, (Object)buildVersion2));
        } else {
            map = MapsKt.emptyMap();
        }
        Map attributes = map;
        String string2 = this.dbMigrationState.getFlywayMigrationPrefixNN();
        String string3 = this.dbMigrationState.getFlywayMigrationSeparatorNN();
        String string4 = this.dbMigrationState.getFlywayMigrationDescription();
        if (string4 == null) {
            string4 = "";
        }
        String migrationNamePattern = string2 + versionPattern + string3 + string4;
        return new FlywayFormatterTemplate(module, migrationNamePattern, attributes, existScriptNames).run();
    }

    public static /* synthetic */ String generateVersionedName$default(FlywayHelper flywayHelper, Collection collection, Module module, int n, Object object) {
        if ((n & 2) != 0) {
            module = null;
        }
        return flywayHelper.generateVersionedName(collection, module);
    }

    @NotNull
    public final String generateChangelogDirPath(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Module module = (Module)event.getData(PlatformDataKeys.MODULE);
        if (module == null) {
            return this.generateFlywayDir();
        }
        Module module2 = module;
        return this.generateFlywayDir(module2);
    }

    @NotNull
    public final String generateFlywayDir() {
        List sourceRoots = JpbVfsUtil.getProjectSourceRoots((Project)this.project, (Set)SetsKt.setOf((Object)JavaResourceRootType.RESOURCE));
        if (sourceRoots.isEmpty()) {
            Set set = JavaModuleSourceRootTypes.SOURCES;
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SOURCES");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JavaSourceRootType[] javaSourceRootTypeArray = thisCollection$iv.toArray(new JavaSourceRootType[0]);
            sourceRoots = JpbVfsUtil.getProjectSourceRoots((Project)this.project, (Set)SetsKt.setOf((Object[])Arrays.copyOf(javaSourceRootTypeArray, javaSourceRootTypeArray.length)));
        }
        String flywayLocation = this.getFirstFlywayLocation();
        if (sourceRoots.isEmpty()) {
            return flywayLocation;
        }
        return ((VirtualFile)sourceRoots.get(0)).getPath() + "/" + flywayLocation;
    }

    @NotNull
    public final String generateFlywayDir(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List<VirtualFile> sourceRoots = this.findSourceRootsForChangelog(module);
        if (sourceRoots.isEmpty()) {
            return this.getFirstFlywayLocation(module);
        }
        return ((VirtualFile)CollectionsKt.first(sourceRoots)).getPath() + "/" + this.getFirstFlywayLocation(module);
    }

    private final List<VirtualFile> findSourceRootsForChangelog(Module $this$findSourceRootsForChangelog) {
        List list;
        ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)$this$findSourceRootsForChangelog);
        List it = list = rootManager.getSourceRoots(JavaModuleSourceRootTypes.RESOURCES);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)it);
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            List list3 = rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            list2 = list3;
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSourceRoots(...)");
        }
        return list2;
    }

    @NotNull
    public final String getFirstFlywayLocation() {
        List allPropertySources = SpringPropertiesConfiguration.Companion.getInstance(this.project).loadAllPropertySources();
        String string = this.findFlywayLocationInPropertySources(allPropertySources);
        if (string == null) {
            string = "db/migration";
        }
        return string;
    }

    private final String getFirstFlywayLocation(Module module) {
        List propertySources = SpringPropertiesConfigurationKt.loadPropertySourcesFromModule$default((SpringPropertiesConfiguration)SpringPropertiesConfiguration.Companion.getInstance(this.project), (Module)module, (boolean)false, (int)2, null);
        String string = this.findFlywayLocationInPropertySources(propertySources);
        if (string == null) {
            string = "db/migration";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String findFlywayLocationInPropertySources(List<? extends PropertySource> allPropertySources) {
        for (PropertySource propertySource : allPropertySources) {
            String string;
            void $this$mapNotNullTo$iv$iv;
            SpringProperty flywayLocationProp = propertySource.findProperty("flyway.locations");
            if (flywayLocationProp == null) {
                flywayLocationProp = propertySource.findProperty("spring.flyway.locations");
            }
            if (flywayLocationProp == null) continue;
            String[] stringArray = new String[]{","};
            Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)flywayLocationProp.getValue(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                String trimmedValue = ((Object)StringsKt.trim((CharSequence)it)).toString();
                if ((StringsKt.startsWith$default((String)trimmedValue, (String)"classpath:", (boolean)false, (int)2, null) ? StringsKt.substringAfter$default((String)trimmedValue, (String)"classpath:", null, (int)2, null) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            String string2 = (String)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
            if (string2 == null) continue;
            String firstClasspath = string2;
            if (StringsKt.startsWith$default((String)firstClasspath, (String)"/", (boolean)false, (int)2, null)) {
                String string3 = firstClasspath.substring(1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = firstClasspath;
            }
            return string;
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/flyway/FlywayHelper$Companion;", "", "<init>", "()V", "SEMANTIC_VERSION_VAR_NAME", "", "getInstance", "Lcom/intellij/flyway/FlywayHelper;", "project", "Lcom/intellij/openapi/project/Project;", "isFlywaySupported", "", "intellij.flyway"})
    @SourceDebugExtension(value={"SMAP\nFlywayHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayHelper.kt\ncom/intellij/flyway/FlywayHelper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,195:1\n30#2,2:196\n*S KotlinDebug\n*F\n+ 1 FlywayHelper.kt\ncom/intellij/flyway/FlywayHelper$Companion\n*L\n34#1:196,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FlywayHelper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<FlywayHelper> serviceClass$iv = FlywayHelper.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (FlywayHelper)object;
        }

        public final boolean isFlywaySupported(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return DatabaseMigrationConfig.Companion.getInstance(project).getState().getUseFlywayForce() || DiffHelper.INSTANCE.isFlywaySupported(project);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/flyway/FlywayHelper$FlywayFormatterTemplate;", "Lcom/intellij/liquibase/common/FormatterTemplate;", "module", "Lcom/intellij/openapi/module/Module;", "content", "", "attributes", "", "", "existScriptNames", "", "<init>", "(Lcom/intellij/flyway/FlywayHelper;Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/util/Map;Ljava/util/Collection;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "processIncrementPattern", "completeName", "templateFormatter", "Lcom/intellij/liquibase/common/FormatterTemplate$TemplateFormatter;", "completePatternIncrementVersion", "Ljava/util/regex/Pattern;", "name", "intellij.flyway"})
    @SourceDebugExtension(value={"SMAP\nFlywayHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlywayHelper.kt\ncom/intellij/flyway/FlywayHelper$FlywayFormatterTemplate\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1563#2:196\n1634#2,3:197\n1617#2,9:200\n1869#2:209\n1870#2:211\n1626#2:212\n1068#2:213\n1#3:210\n*S KotlinDebug\n*F\n+ 1 FlywayHelper.kt\ncom/intellij/flyway/FlywayHelper$FlywayFormatterTemplate\n*L\n150#1:196\n150#1:197,3\n150#1:200,9\n150#1:209\n150#1:211\n150#1:212\n153#1:213\n150#1:210\n*E\n"})
    public final class FlywayFormatterTemplate
    extends FormatterTemplate {
        @Nullable
        private final Module module;
        @NotNull
        private final Collection<String> existScriptNames;

        public FlywayFormatterTemplate(@NotNull Module module, @NotNull String content, @NotNull Map<String, ? extends Object> attributes, Collection<String> existScriptNames) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
            Intrinsics.checkNotNullParameter(existScriptNames, (String)"existScriptNames");
            super(content, attributes, null, null, 12, null);
            this.module = module;
            this.existScriptNames = existScriptNames;
        }

        @Nullable
        public final Module getModule() {
            return this.module;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public String processIncrementPattern(@NotNull String completeName, @NotNull FormatterTemplate.TemplateFormatter templateFormatter) {
            void $this$sortedByDescending$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)completeName, (String)"completeName");
            Intrinsics.checkNotNullParameter((Object)templateFormatter, (String)"templateFormatter");
            if (!StringsKt.contains$default((CharSequence)completeName, (CharSequence)"$INCREMENT_LOCATION$", (boolean)false, (int)2, null)) {
                return completeName;
            }
            double incrementValue = templateFormatter.getIncrementStart().doubleValue();
            String processedFileName = this.replaceIncrementValue(completeName, incrementValue, templateFormatter.getIncrementPattern());
            Iterable iterable = this.existScriptNames;
            Iterable iterable2 = FlywaySearchHelper.Companion.getInstance(FlywayHelper.this.getProject()).findAllVersionedMigrationNames(this.module);
            boolean $i$f$map22 = false;
            void var9_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string2 = FileUtilRt.getExtension((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
                collection.add(StringsKt.isBlank((CharSequence)string2) ? (String)it + "d.sql" : it);
            }
            $this$map$iv = (List)destination$iv$iv;
            FlywayHelper $i$f$map22 = FlywayHelper.this;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ResourceName it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (ResourceNameParser.parse($i$f$map22.getProject(), it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.union((Iterable)iterable2, (Iterable)((List)destination$iv$iv2));
            boolean $i$f$sortedByDescending = false;
            List sortedMigrations = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ResourceName it = (ResourceName)b;
                    boolean bl = false;
                    MigrationVersion migrationVersion = it.getVersion();
                    if (migrationVersion == null) {
                        migrationVersion = MigrationVersion.EMPTY;
                    }
                    it = (ResourceName)a;
                    Comparable comparable = migrationVersion;
                    bl = false;
                    MigrationVersion migrationVersion2 = it.getVersion();
                    if (migrationVersion2 == null) {
                        migrationVersion2 = MigrationVersion.EMPTY;
                    }
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)migrationVersion2);
                }
            });
            ResourceName processedResourceName = ResourceNameParser.parse(FlywayHelper.this.getProject(), processedFileName + "d.sql");
            Object object = processedResourceName;
            if (object == null || (object = ((ResourceName)object).getVersion()) == null) {
                return processedFileName;
            }
            Object processedVersion = object;
            Pattern patternIncrementVersion = this.completePatternIncrementVersion(completeName);
            for (ResourceName existMigration : sortedMigrations) {
                MigrationVersion maxVersion;
                if (existMigration.getVersion() == null) {
                    return processedFileName;
                }
                if (maxVersion.compareTo((MigrationVersion)processedVersion) < 0) break;
                Matcher maxMatcher = patternIncrementVersion.matcher(existMigration.getRawResourceName());
                if (!maxMatcher.find() || 1 > maxMatcher.groupCount()) continue;
                String string = maxMatcher.group(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                Double d = StringsKt.toDoubleOrNull((String)string);
                if (d == null) {
                    continue;
                }
                double versionValue = d;
                double incrementBy = templateFormatter.getIncrementBy().doubleValue();
                processedFileName = this.replaceIncrementValue(completeName, versionValue + incrementBy, templateFormatter.getIncrementPattern());
                break;
            }
            return processedFileName;
        }

        private final Pattern completePatternIncrementVersion(String name) {
            String separator;
            Object processedName = ((Object)StringsKt.trim((CharSequence)name)).toString();
            int separatorIdx = StringsKt.indexOf$default((CharSequence)((CharSequence)processedName), (String)(separator = DatabaseMigrationConfig.Companion.getInstance(FlywayHelper.this.getProject()).getState().getFlywayMigrationSeparatorNN()), (int)0, (boolean)false, (int)6, null);
            if (separatorIdx != -1) {
                String string = ((String)processedName).substring(0, separatorIdx);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                processedName = string + separator;
            }
            String string = StringUtil.escapeToRegexp((String)processedName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"escapeToRegexp(...)");
            String string2 = StringUtil.escapeToRegexp((String)"$INCREMENT_LOCATION$");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"escapeToRegexp(...)");
            Pattern pattern = Pattern.compile("^" + StringsKt.replace$default((String)string, (String)string2, (String)"([0-9]+\\.?[0-9]*?)", (boolean)false, (int)4, null));
            Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
            return pattern;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/flyway/FlywayHelper$FlywayLibrary;", "", "version", "", "<init>", "(Ljava/lang/String;)V", "getVersion", "()Ljava/lang/String;", "intellij.flyway"})
    public static final class FlywayLibrary {
        @NotNull
        private final String version;

        public FlywayLibrary(@NotNull String version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            this.version = version;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }
    }
}

