/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.yaml.reference;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.liquibase.codeInsight.references.LiquibaseXmlPropertySymbol;
import com.intellij.liquibase.common.LiquibaseSearcher;
import com.intellij.liquibase.yaml.reference.LiquibaseYamlPropertyPsiSymbolReference$collectChangelogFiles$;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.StringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001a\u001a\u00020\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/liquibase/yaml/reference/LiquibaseYamlPropertyPsiSymbolReference;", "Lcom/intellij/model/psi/PsiSymbolReference;", "property", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "getElement", "getRangeInElement", "resolveReference", "", "Lcom/intellij/model/Symbol;", "getVariantsIterator", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/psi/PsiFile;", "getDeclaredProperties", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "collectChangelogFiles", "Lorg/jetbrains/yaml/psi/YAMLFile;", "getPropertyTags", "yamlFile", "intellij.liquibase.yaml"})
@SourceDebugExtension(value={"SMAP\nLiquibaseYamlPropertyPsiSymbolReference.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseYamlPropertyPsiSymbolReference.kt\ncom/intellij/liquibase/yaml/reference/LiquibaseYamlPropertyPsiSymbolReference\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n477#2:92\n19#3:93\n1374#4:94\n1460#4,5:95\n774#4:100\n865#4,2:101\n1617#4,9:103\n1869#4:112\n1870#4:114\n1626#4:115\n1#5:113\n1#5:116\n*S KotlinDebug\n*F\n+ 1 LiquibaseYamlPropertyPsiSymbolReference.kt\ncom/intellij/liquibase/yaml/reference/LiquibaseYamlPropertyPsiSymbolReference\n*L\n79#1:92\n85#1:93\n85#1:94\n85#1:95,5\n86#1:100\n86#1:101,2\n87#1:103,9\n87#1:112\n87#1:114\n87#1:115\n87#1:113\n*E\n"})
public final class LiquibaseYamlPropertyPsiSymbolReference
implements PsiSymbolReference {
    @NotNull
    private final String property;
    @NotNull
    private final PsiElement psiElement;
    @NotNull
    private final TextRange textRange;

    public LiquibaseYamlPropertyPsiSymbolReference(@NotNull String property, @NotNull PsiElement psiElement, @NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        this.property = property;
        this.psiElement = psiElement;
        this.textRange = textRange;
    }

    @NotNull
    public PsiElement getElement() {
        return this.psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.textRange;
    }

    @NotNull
    public Collection<Symbol> resolveReference() {
        PsiFile psiFile = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)this.psiElement, PsiFile.class);
        if (psiFile == null) {
            return CollectionsKt.emptyList();
        }
        PsiFile context = psiFile;
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter(this.getDeclaredProperties(context), arg_0 -> LiquibaseYamlPropertyPsiSymbolReference.resolveReference$lambda$0(this, arg_0)), LiquibaseYamlPropertyPsiSymbolReference::resolveReference$lambda$1));
    }

    @NotNull
    public final Iterator<LookupElement> getVariantsIterator(@NotNull PsiFile context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SequencesKt.mapNotNull(this.getDeclaredProperties(context), LiquibaseYamlPropertyPsiSymbolReference::getVariantsIterator$lambda$4).iterator();
    }

    private final Sequence<YAMLMapping> getDeclaredProperties(PsiFile context) {
        return SequencesKt.flatMap(this.collectChangelogFiles(context), arg_0 -> LiquibaseYamlPropertyPsiSymbolReference.getDeclaredProperties$lambda$5(this, arg_0));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Sequence<YAMLFile> collectChangelogFiles(PsiFile context) {
        Sequence sequence;
        LiquibaseSearcher liquibaseSearcher = (LiquibaseSearcher)LiquibaseSearcher.Companion.getInstance((PsiElement)context);
        if (liquibaseSearcher != null) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)context);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
            Sequence<PsiFile> sequence2 = liquibaseSearcher.collectChangelogFiles(globalSearchScope);
            if (sequence2 != null) {
                void $this$filterIsInstance$iv;
                Sequence<PsiFile> sequence3 = sequence2;
                boolean $i$f$filterIsInstance = false;
                Sequence sequence4 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)collectChangelogFiles$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence4, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                Sequence sequence5 = sequence4;
                if (sequence5 != null) {
                    sequence = sequence5;
                    return sequence;
                }
            }
        }
        sequence = SequencesKt.emptySequence();
        return sequence;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final Sequence<YAMLMapping> getPropertyTags(YAMLFile yamlFile) {
        Sequence sequence;
        String[] stringArray = new String[]{"databaseChangeLog"};
        YAMLKeyValue yAMLKeyValue = YAMLUtil.getQualifiedKeyInFile((YAMLFile)yamlFile, (String[])stringArray);
        if (yAMLKeyValue != null && (stringArray = yAMLKeyValue.getValue()) != null) {
            List list;
            YAMLSequence yAMLSequence;
            String[] stringArray2 = stringArray;
            boolean $i$f$asSafely = false;
            String[] stringArray3 = stringArray2;
            if (!(stringArray2 instanceof YAMLSequence)) {
                stringArray3 = null;
            }
            if ((yAMLSequence = (YAMLSequence)stringArray3) != null && (list = yAMLSequence.getItems()) != null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                Iterable iterable = list;
                boolean $i$f$flatMap22 = false;
                void var9_11 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    YAMLSequenceItem it = (YAMLSequenceItem)element$iv$iv;
                    boolean bl = false;
                    Collection collection = it.getKeysValues();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getKeysValues(...)");
                    Iterable list$iv$iv = collection;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Iterable $i$f$flatMap22 = (List)destination$iv$iv;
                boolean $i$f$filter22 = false;
                destination$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getKeyText(), (Object)"property")) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Iterable $i$f$filter22 = (List)destination$iv$iv2;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv2 = $this$mapNotNull$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    YAMLMapping it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    YAMLKeyValue it = (YAMLKeyValue)element$iv$iv;
                    boolean bl2 = false;
                    YAMLValue yAMLValue = it.getValue();
                    if ((yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv3.add(it$iv$iv);
                }
                Sequence sequence2 = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv3));
                if (sequence2 != null) {
                    sequence = sequence2;
                    return sequence;
                }
            }
        }
        sequence = SequencesKt.emptySequence();
        return sequence;
    }

    private static final boolean resolveReference$lambda$0(LiquibaseYamlPropertyPsiSymbolReference this$0, YAMLMapping propertyTag) {
        Intrinsics.checkNotNullParameter((Object)propertyTag, (String)"propertyTag");
        YAMLKeyValue yAMLKeyValue = propertyTag.getKeyValueByKey("name");
        return Intrinsics.areEqual((Object)(yAMLKeyValue != null ? yAMLKeyValue.getValueText() : null), (Object)this$0.property);
    }

    private static final LiquibaseXmlPropertySymbol resolveReference$lambda$1(YAMLMapping propertyTag) {
        Intrinsics.checkNotNullParameter((Object)propertyTag, (String)"propertyTag");
        YAMLKeyValue yAMLKeyValue = propertyTag.getKeyValueByKey("value");
        String string = StringKt.nullize$default((String)(yAMLKeyValue != null ? yAMLKeyValue.getValueText() : null), (boolean)false, (int)1, null);
        if (string == null) {
            string = "<empty>";
        }
        String propertyValue = string;
        YAMLKeyValue yAMLKeyValue2 = propertyTag.getKeyValueByKey("dbms");
        String dbms = yAMLKeyValue2 != null ? yAMLKeyValue2.getValueText() : null;
        PsiFile psiFile = propertyTag.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        TextRange textRange = propertyTag.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        return new LiquibaseXmlPropertySymbol(propertyValue, dbms, psiFile, textRange);
    }

    private static final LookupElement getVariantsIterator$lambda$4(YAMLMapping propertyTag) {
        String propertyName;
        String string;
        block9: {
            block8: {
                String string2;
                String string3;
                String string4;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)propertyTag, (String)"propertyTag");
                        YAMLKeyValue yAMLKeyValue = propertyTag.getKeyValueByKey("name");
                        if (yAMLKeyValue == null || (string4 = yAMLKeyValue.getValueText()) == null) break block6;
                        String it = string = string4;
                        boolean bl = false;
                        String string5 = string3 = !StringsKt.isBlank((CharSequence)it) ? string : null;
                        if (string3 != null) break block7;
                    }
                    return null;
                }
                propertyName = string3;
                string4 = propertyTag.getKeyValueByKey("value");
                if (string4 == null || (string3 = string4.getValueText()) == null) break block8;
                String it = string2 = string3;
                boolean bl = false;
                String string6 = string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                if (string != null) break block9;
            }
            return null;
        }
        String propertyValue = string;
        return PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)LookupElementBuilder.create((String)propertyName).withIcon(AllIcons.Providers.Liquibase).withTailText(" '" + propertyValue + "'").withTypeText(propertyTag.getContainingFile().getName())), (double)1000.0);
    }

    private static final Sequence getDeclaredProperties$lambda$5(LiquibaseYamlPropertyPsiSymbolReference this$0, YAMLFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getPropertyTags(it);
    }
}

