/*
 * Decompiled with CFR 0.152.
 */
package liquibase.snapshot;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.snapshot.CachedRow;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.JdbcDatabaseSnapshot;
import liquibase.snapshot.ResultSetCache;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.core.GetViewDefinitionStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.View;
import liquibase.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewSnapshotGenerator
extends JdbcSnapshotGenerator {
    private static final String SQL_FILTER_MATCH_ALL = "%";
    private static final String MATERIALIZED_VIEW_TYPE = "MATERIALIZED VIEW";

    public ViewSnapshotGenerator() {
        super(View.class, new Class[]{Schema.class});
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return new Class[]{liquibase.snapshot.jvm.ViewSnapshotGenerator.class};
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        if (((View)example).getDefinition() != null) {
            return example;
        }
        Database database = snapshot.getDatabase();
        Schema schema = example.getSchema();
        try {
            List<CachedRow> viewsMetadataRs = this.getViews((JdbcDatabaseSnapshot)snapshot, schema, (AbstractJdbcDatabase)database, example.getName());
            if (!viewsMetadataRs.isEmpty()) {
                CachedRow row = viewsMetadataRs.get(0);
                String rawViewName = row.getString("TABLE_NAME");
                String rawSchemaName = StringUtil.trimToNull((String)row.getString("TABLE_SCHEM"));
                String rawCatalogName = StringUtil.trimToNull((String)row.getString("TABLE_CAT"));
                boolean isMaterializedView = MATERIALIZED_VIEW_TYPE.equals(row.getString("TABLE_TYPE"));
                String remarks = row.getString("REMARKS");
                if (remarks != null) {
                    remarks = remarks.replace("''", "'");
                }
                View view = new View().setName(this.cleanNameFromDatabase(rawViewName, database));
                view.setRemarks(remarks);
                CatalogAndSchema schemaFromJdbcInfo = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(rawCatalogName, rawSchemaName);
                view.setSchema(new Schema(schemaFromJdbcInfo.getCatalogName(), schemaFromJdbcInfo.getSchemaName()));
                try {
                    String definition;
                    if (!isMaterializedView) {
                        int length;
                        definition = database.getViewDefinition(schemaFromJdbcInfo, view.getName());
                        if (definition.startsWith("FULL_DEFINITION: ")) {
                            definition = definition.replaceFirst("^FULL_DEFINITION: ", "");
                            view.setContainsFullDefinition(true);
                        }
                        if ((length = definition.length()) > 0 && definition.charAt(length - 1) == '\u0000') {
                            definition = definition.substring(0, length - 1);
                        }
                        if (database instanceof InformixDatabase) {
                            definition = definition.trim();
                            definition = definition.replaceAll("\\s*,\\s*", ", ");
                            definition = definition.replaceAll("\\s*;", "");
                            definition = definition.replaceAll("(?i)\"" + view.getSchema().getName() + "\"\\.", "");
                        }
                        DbType databaseType = LiquibaseUtils.getDatabaseType(database);
                        if ((definition = StringUtil.trimToNull((String)definition)) == null) {
                            definition = "[CANNOT READ VIEW DEFINITION]";
                            String warningMessage = null;
                            if (databaseType == DbType.MARIA) {
                                warningMessage = "\nThe current MariaDB user does not have permissions to access view definitions needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ VIEW DEFINITION]' to locate inaccessible objects. Learn more about altering permissions with suggested MariaDB GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mariadbgrants.html\n";
                            } else if (databaseType == DbType.MYSQL) {
                                warningMessage = "\nThe current MySQL user does not have permissions to access view definitions needed for this Liquibase command.\nPlease search the changelog for '[CANNOT READ VIEW DEFINITION]' to locate inaccessible objects. This is\npotentially due to a known MySQL bug https://bugs.mysql.com/bug.php?id=22763. Learn more about altering\npermissions with suggested MySQL GRANTs at https://docs.liquibase.com/workflows/liquibase-pro/mysqlgrants.html\n";
                            }
                            if (warningMessage != null) {
                                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + warningMessage);
                                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(warningMessage);
                            }
                        }
                    } else {
                        definition = ViewSnapshotGenerator.getMaterializedViewDefinition();
                    }
                    view.setDefinition(definition);
                }
                catch (DatabaseException e) {
                    throw new DatabaseException("Error getting " + database.getConnection().getURL() + " view with " + String.valueOf(new GetViewDefinitionStatement(view.getSchema().getCatalogName(), view.getSchema().getName(), rawViewName)), (Throwable)e);
                }
                return view;
            }
            return null;
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @NotNull
    private static String getMaterializedViewDefinition() {
        return "CREATE MATERIALIZED VIEW fake_view select * from fake_table;";
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(View.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            Database database = snapshot.getDatabase();
            try {
                List<CachedRow> viewsMetadataRs = this.getViews((JdbcDatabaseSnapshot)snapshot, schema, (AbstractJdbcDatabase)database, null);
                for (CachedRow row : viewsMetadataRs) {
                    CatalogAndSchema catalogAndSchema = ((AbstractJdbcDatabase)database).getSchemaFromJdbcInfo(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"));
                    View view = new View();
                    view.setName(row.getString("TABLE_NAME"));
                    view.setSchema(new Schema(catalogAndSchema.getCatalogName(), catalogAndSchema.getSchemaName()));
                    view.setRemarks(row.getString("REMARKS"));
                    boolean isMaterializedView = MATERIALIZED_VIEW_TYPE.equals(row.getString("TABLE_TYPE"));
                    if (!isMaterializedView) {
                        String definition = StringUtil.standardizeLineEndings((String)row.getString("OBJECT_BODY"));
                        view.setDefinition(definition);
                    } else {
                        view.setDefinition(ViewSnapshotGenerator.getMaterializedViewDefinition());
                    }
                    if (LiquibaseUtils.getDatabaseType(database) == DbType.ORACLE) {
                        view.setAttribute("editioning", (Object)"Y".equals(row.getString("EDITIONING_VIEW")));
                    }
                    schema.addDatabaseObject((DatabaseObject)view);
                }
            }
            catch (SQLException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
    }

    private List<CachedRow> getViews(JdbcDatabaseSnapshot snapshot, Schema schema, AbstractJdbcDatabase database, @Nullable String viewName) throws DatabaseException, SQLException {
        DatabaseMetaData databaseMetaData;
        List<CachedRow> materializedViews;
        JdbcDatabaseSnapshot.CachingDatabaseMetaData metaDataFromCache = snapshot.getMetaDataFromCache();
        String catalogName = database.getJdbcCatalogName(schema);
        String schemaName = database.getJdbcSchemaName(schema);
        ArrayList<CachedRow> result = new ArrayList<CachedRow>(metaDataFromCache.getViews(catalogName, schemaName, viewName));
        if (LiquibaseUtils.getDatabaseType((Database)database) == DbType.POSTGRES && (materializedViews = this.getMaterializedViews(snapshot, database, databaseMetaData = metaDataFromCache.getDatabaseMetaData(), catalogName, schemaName, viewName)) != null) {
            result.addAll(materializedViews);
        }
        return result;
    }

    @Nullable
    private List<CachedRow> getMaterializedViews(final JdbcDatabaseSnapshot snapshot, final AbstractJdbcDatabase database, final DatabaseMetaData databaseMetaData, final String catalogName, final String schemaName, final @Nullable String viewName) throws DatabaseException {
        return snapshot.getResultSetCache("getMaterializedViews").get((ResultSetCache.ResultSetExtractor)new ResultSetCache.SingleResultSetExtractor((Database)database){

            protected boolean shouldBulkSelect(String schemaKey, ResultSetCache resultSetCache) {
                return viewName == null || snapshot.getScratchData("DatabaseSnapshot.allCatalogsString") != null || super.shouldBulkSelect(schemaKey, resultSetCache);
            }

            public ResultSetCache.RowData rowKeyParameters(CachedRow row) {
                return new ResultSetCache.RowData(row.getString("TABLE_CAT"), row.getString("TABLE_SCHEM"), (Database)database, new String[]{row.getString("TABLE_NAME")});
            }

            public ResultSetCache.RowData wantedKeyParameters() {
                return new ResultSetCache.RowData(catalogName, schemaName, (Database)database, new String[]{viewName});
            }

            public boolean bulkContainsSchema(String schemaKey) {
                return false;
            }

            public String getSchemaKey(CachedRow row) {
                return row.getString("TABLE_SCHEM");
            }

            public List<CachedRow> fastFetchQuery() throws SQLException {
                CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize((Database)database);
                String catalog = database.getJdbcCatalogName(catalogAndSchema);
                String schema = database.getJdbcSchemaName(catalogAndSchema);
                return this.extract(databaseMetaData.getTables(catalog, schema, viewName == null ? ViewSnapshotGenerator.SQL_FILTER_MATCH_ALL : viewName, new String[]{ViewSnapshotGenerator.MATERIALIZED_VIEW_TYPE}));
            }

            public List<CachedRow> bulkFetchQuery() throws SQLException {
                CatalogAndSchema catalogAndSchema = new CatalogAndSchema(catalogName, schemaName).customize((Database)database);
                String catalog = database.getJdbcCatalogName(catalogAndSchema);
                String schema = database.getJdbcSchemaName(catalogAndSchema);
                return this.extract(databaseMetaData.getTables(catalog, schema, ViewSnapshotGenerator.SQL_FILTER_MATCH_ALL, new String[]{ViewSnapshotGenerator.MATERIALIZED_VIEW_TYPE}));
            }
        });
    }
}

