/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.jps.maven.model.impl.MavenFilteredJarConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenFilteredJarUtils;", "", "<init>", "()V", "Companion", "intellij.maven"})
public final class MavenFilteredJarUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String> GOALS;
    @NotNull
    private static final Map<String, String[]> DEFAULTEXCLUDES;

    @JvmStatic
    @NotNull
    public static final List<MavenFilteredJarConfiguration> getAllFilteredConfigurations(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject) {
        return Companion.getAllFilteredConfigurations(mavenProjectsManager, mavenProject);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"jar", (Object)""), TuplesKt.to((Object)"test-jar", (Object)"tests")};
        GOALS = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[16];
        String[] stringArray = new String[]{" **/*~", "**/#*#", "**/.#*", "**/%*%", "*/._*"};
        pairArray[0] = TuplesKt.to((Object)"Misc", (Object)stringArray);
        stringArray = new String[]{"*/CVS", "**/CVS/**", "**/.cvsignore"};
        pairArray[1] = TuplesKt.to((Object)"CVS", (Object)stringArray);
        stringArray = new String[]{"**/RCS", "**/RCS/**"};
        pairArray[2] = TuplesKt.to((Object)"RCS", (Object)stringArray);
        stringArray = new String[]{"**/SCCS", "**/SCCS/**"};
        pairArray[3] = TuplesKt.to((Object)"SCCS", (Object)stringArray);
        stringArray = new String[]{" **/vssver.scc"};
        pairArray[4] = TuplesKt.to((Object)"VSSercer", (Object)stringArray);
        stringArray = new String[]{"**/project.pj"};
        pairArray[5] = TuplesKt.to((Object)"MKS", (Object)stringArray);
        stringArray = new String[]{"**/.svn", "**/.svn/**"};
        pairArray[6] = TuplesKt.to((Object)"SVN", (Object)stringArray);
        stringArray = new String[]{"**/.arch-ids", "**/.arch-ids/**"};
        pairArray[7] = TuplesKt.to((Object)"GNU", (Object)stringArray);
        stringArray = new String[]{"**/.bzr", "**/.bzr/**"};
        pairArray[8] = TuplesKt.to((Object)"Bazaar", (Object)stringArray);
        stringArray = new String[]{"**/.MySCMServerInfo"};
        pairArray[9] = TuplesKt.to((Object)"SurroundSCM", (Object)stringArray);
        stringArray = new String[]{"**/.DS_Store"};
        pairArray[10] = TuplesKt.to((Object)"Mac", (Object)stringArray);
        stringArray = new String[]{"**/.metadata", "**/.metadata/**"};
        pairArray[11] = TuplesKt.to((Object)"Serena Dimension", (Object)stringArray);
        stringArray = new String[]{"**/.hg", "**/.hg/**"};
        pairArray[12] = TuplesKt.to((Object)"Mercurial", (Object)stringArray);
        stringArray = new String[]{"**/.git", "**/.git/**", "**/.gitignore"};
        pairArray[13] = TuplesKt.to((Object)"Git", (Object)stringArray);
        stringArray = new String[]{"**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**"};
        pairArray[14] = TuplesKt.to((Object)"Bitkeeper", (Object)stringArray);
        stringArray = new String[]{"**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/****/-darcs-backup*", "**/.darcs-temp-mail"};
        pairArray[15] = TuplesKt.to((Object)"Darcs", (Object)stringArray);
        DEFAULTEXCLUDES = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J*\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/utils/MavenFilteredJarUtils$Companion;", "", "<init>", "()V", "getAllFilteredConfigurations", "", "Lorg/jetbrains/jps/maven/model/impl/MavenFilteredJarConfiguration;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "loadConfiguration", "element", "Lorg/jdom/Element;", "goal", "", "GOALS", "", "DEFAULTEXCLUDES", "", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenFilteredJarUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenFilteredJarUtils.kt\norg/jetbrains/idea/maven/utils/MavenFilteredJarUtils$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,93:1\n1869#2:94\n1869#2,2:95\n1870#2:97\n13472#3,2:98\n*S KotlinDebug\n*F\n+ 1 MavenFilteredJarUtils.kt\norg/jetbrains/idea/maven/utils/MavenFilteredJarUtils$Companion\n*L\n21#1:94\n22#1:95,2\n21#1:97\n51#1:98,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<MavenFilteredJarConfiguration> getAllFilteredConfigurations(@NotNull MavenProjectsManager mavenProjectsManager, @NotNull MavenProject mavenProject) {
            Intrinsics.checkNotNullParameter((Object)mavenProjectsManager, (String)"mavenProjectsManager");
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            if ("pom".equals(mavenProject.getPackaging())) {
                return CollectionsKt.emptyList();
            }
            HashMap result2 = new HashMap();
            MavenPlugin plugin = MavenProject.findPlugin$default(mavenProject, "org.apache.maven.plugins", "maven-jar-plugin", false, 4, null);
            if (plugin == null) {
                return CollectionsKt.emptyList();
            }
            List list = plugin.getExecutions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExecutions(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenPlugin.Execution exec = (MavenPlugin.Execution)element$iv;
                boolean bl = false;
                List list2 = exec.getGoals();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getGoals(...)");
                Iterable $this$forEach$iv2 = list2;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    MavenFilteredJarConfiguration mavenFilteredJarConfiguration;
                    String g = (String)element$iv2;
                    boolean bl2 = false;
                    Element configuration = exec.getConfigurationElement();
                    if (configuration == null) continue;
                    Intrinsics.checkNotNull((Object)g);
                    if (Companion.loadConfiguration(mavenProjectsManager, mavenProject, configuration, g) == null) continue;
                    MavenFilteredJarConfiguration it = mavenFilteredJarConfiguration;
                    boolean bl3 = false;
                    ((Map)result2).put(it.name, it);
                }
            }
            Collection collection = result2.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            return CollectionsKt.toList((Iterable)collection);
        }

        private final MavenFilteredJarConfiguration loadConfiguration(MavenProjectsManager mavenProjectsManager, MavenProject mavenProject, Element element, String goal) {
            String classifier;
            List includes = CollectionsKt.toMutableList((Collection)MavenJDOMUtil.findChildrenValuesByPath(element, "includes", "include"));
            List excludes = CollectionsKt.toMutableList((Collection)MavenJDOMUtil.findChildrenValuesByPath(element, "excludes", "exclude"));
            if (excludes.isEmpty() && includes.isEmpty()) {
                return null;
            }
            String string = element.getChildTextTrim("classifier");
            if (string == null && (string = (String)GOALS.get(goal)) == null) {
                string = "";
            }
            if (((CharSequence)(classifier = string)).length() == 0) {
                return null;
            }
            boolean excludeDefaults = false;
            excludeDefaults = !StringsKt.equals((String)"false", (String)element.getChildTextTrim("addDefaultExcludes"), (boolean)true);
            if (excludeDefaults) {
                DEFAULTEXCLUDES.forEach((arg_0, arg_1) -> Companion.loadConfiguration$lambda$4((arg_0, arg_1) -> Companion.loadConfiguration$lambda$3(excludes, arg_0, arg_1), arg_0, arg_1));
            }
            Module module = mavenProjectsManager.findModule(mavenProject);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            MavenFilteredJarConfiguration configuration = new MavenFilteredJarConfiguration();
            boolean tests = Intrinsics.areEqual((Object)goal, (Object)"test-jar");
            configuration.classifier = classifier;
            configuration.excludes = CollectionsKt.toSet((Iterable)excludes);
            configuration.includes = CollectionsKt.toSet((Iterable)includes);
            configuration.moduleName = module2.getName();
            configuration.isTest = tests;
            configuration.originalOutput = tests ? mavenProject.getTestOutputDirectory() : mavenProject.getOutputDirectory();
            configuration.jarOutput = configuration.originalOutput + "-jar-" + classifier;
            configuration.name = mavenProject.getMavenId() + "-" + classifier;
            return configuration;
        }

        private static final Unit loadConfiguration$lambda$3(List $excludes, String string, String[] v) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            String[] $this$forEach$iv = v;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                String element$iv;
                String p0 = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                $excludes.add(p0);
            }
            return Unit.INSTANCE;
        }

        private static final void loadConfiguration$lambda$4(Function2 $tmp0, Object p0, Object p1) {
            $tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

