/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.tomcat;

import com.intellij.DynamicBundle;
import com.intellij.javaee.appServers.appServerIntegrations.ApplicationServer;
import com.intellij.javaee.appServers.run.configuration.ApplicationServerSelectionListener;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeeServerVersionProvider;
import com.intellij.javaee.oss.transport.MultiTargetRemoteServerModel;
import com.intellij.javaee.oss.transport.MultiTargetRemoteStagingEditor;
import com.intellij.javaee.oss.util.Version;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.tomcat.server.TomcatRemoteModel;
import org.jetbrains.idea.tomcat.server.TomcatRunSettingsEditor;

public class TomcatRemoteRunConfigurationEditor
extends TomcatRunSettingsEditor<TomcatRemoteModel>
implements ApplicationServerSelectionListener {
    private JTextField myJndiPortField;
    private MultiTargetRemoteStagingEditor myRemoteStagingEditor;
    private JPanel myMainPanel;
    private JPanel myJndiPortPanel;

    public TomcatRemoteRunConfigurationEditor(JavaeeIntegration integration) {
        super(integration);
        this.$$$setupUI$$$();
    }

    public void serverSelected(@Nullable ApplicationServer server) {
        this.updateUI(server);
    }

    public void serverProbablyEdited(@Nullable ApplicationServer server) {
    }

    private void updateUI(@Nullable ApplicationServer server) {
        boolean showDeployOptions = server == null ? true : new Version(new JavaeeServerVersionProvider(server).getValue()).getMajor() >= 5;
        this.myMainPanel.setVisible(showDeployOptions);
    }

    @NotNull
    protected JComponent getEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            TomcatRemoteRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    protected void resetEditorFrom(TomcatRemoteModel serverModel) {
        this.updateUI(serverModel.getApplicationServer());
        this.myJndiPortPanel.setVisible(serverModel.isUseJmx());
        this.myJndiPortField.setText(String.valueOf(serverModel.getJndiPort()));
        this.myRemoteStagingEditor.resetEditorFrom((MultiTargetRemoteServerModel)serverModel);
    }

    protected void applyEditorTo(TomcatRemoteModel serverModel) throws ConfigurationException {
        serverModel.setJndiPort(this.getJndiPort(this.myJndiPortField, serverModel));
        this.myRemoteStagingEditor.applyEditorTo((MultiTargetRemoteServerModel)serverModel);
    }

    private void createUIComponents() {
        this.myRemoteStagingEditor = new MultiTargetRemoteStagingEditor(Arrays.asList(TomcatRemoteModel.CONTEXT_TARGET_DEFINITION, TomcatRemoteModel.STAGING_TARGET_DEFINITION)){

            public void resetEditorFrom(MultiTargetRemoteServerModel model) {
                super.resetEditorFrom(model);
                TomcatRemoteModel remoteModel = (TomcatRemoteModel)model;
                this.setTargetVisible("CONTEXT_XML", !remoteModel.isTomEE() && remoteModel.isContextDescriptorExist());
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myJndiPortPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/TomcatBundle", TomcatRemoteRunConfigurationEditor.class).getString("label.jmx.port"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myJndiPortField = jTextField = new JTextField();
        jTextField.setColumns(4);
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        MultiTargetRemoteStagingEditor multiTargetRemoteStagingEditor = this.myRemoteStagingEditor;
        JComponent jComponent = multiTargetRemoteStagingEditor.$$$getRootComponent$$$();
        jPanel2.add((Component)jComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/tomcat/TomcatRemoteRunConfigurationEditor", "getEditor"));
    }
}

