/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.microservices.jvm.url.UastUrlAttributeUtils;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlQueryParameter;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.PsiElement;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.mvc.jam.RequestMethod;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.SpringMvcUrlResolverKt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0016\u0010$\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lcom/intellij/spring/mvc/model/SpringMvcUrlTargetInfo;", "Lcom/intellij/microservices/url/UrlTargetInfo;", "schemes", "", "", "urlMapping", "Lcom/intellij/spring/mvc/mapping/UrlMappingElement;", "authorities", "Lcom/intellij/microservices/url/Authority;", "<init>", "(Ljava/util/List;Lcom/intellij/spring/mvc/mapping/UrlMappingElement;Ljava/util/List;)V", "getSchemes", "()Ljava/util/List;", "getUrlMapping", "()Lcom/intellij/spring/mvc/mapping/UrlMappingElement;", "getAuthorities", "path", "Lcom/intellij/microservices/url/UrlPath;", "getPath", "()Lcom/intellij/microservices/url/UrlPath;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "isDeprecated", "", "()Z", "resolveToPsiElement", "Lcom/intellij/psi/PsiElement;", "methods", "", "getMethods", "()Ljava/util/Set;", "source", "getSource", "()Ljava/lang/String;", "documentationPsiElement", "getDocumentationPsiElement", "()Lcom/intellij/psi/PsiElement;", "queryParameters", "", "Lcom/intellij/microservices/url/UrlQueryParameter;", "getQueryParameters", "()Ljava/lang/Iterable;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nSpringMvcUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringMvcUrlResolver.kt\ncom/intellij/spring/mvc/model/SpringMvcUrlTargetInfo\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,133:1\n11563#2,3:134\n*S KotlinDebug\n*F\n+ 1 SpringMvcUrlResolver.kt\ncom/intellij/spring/mvc/model/SpringMvcUrlTargetInfo\n*L\n123#1:134,3\n*E\n"})
public final class SpringMvcUrlTargetInfo
implements UrlTargetInfo {
    @NotNull
    private final List<String> schemes;
    @NotNull
    private final UrlMappingElement urlMapping;
    @NotNull
    private final List<Authority> authorities;
    @NotNull
    private final UrlPath path;
    @NotNull
    private final Set<String> methods;

    /*
     * WARNING - void declaration
     */
    public SpringMvcUrlTargetInfo(@NotNull List<String> schemes, @NotNull UrlMappingElement urlMapping, @NotNull List<? extends Authority> authorities) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(schemes, (String)"schemes");
        Intrinsics.checkNotNullParameter((Object)urlMapping, (String)"urlMapping");
        Intrinsics.checkNotNullParameter(authorities, (String)"authorities");
        this.schemes = schemes;
        this.urlMapping = urlMapping;
        this.authorities = authorities;
        UrlPath urlPath = this.urlMapping.getUrlPath();
        Intrinsics.checkNotNullExpressionValue((Object)urlPath, (String)"getUrlPath(...)");
        this.path = urlPath;
        RequestMethod[] requestMethodArray = this.urlMapping.getMethod();
        Intrinsics.checkNotNullExpressionValue((Object)requestMethodArray, (String)"getMethod(...)");
        Object[] objectArray = (Object[])requestMethodArray;
        Collection collection = new LinkedHashSet();
        SpringMvcUrlTargetInfo springMvcUrlTargetInfo = this;
        boolean $i$f$mapTo = false;
        for (void item$iv : $this$mapTo$iv) {
            void rm;
            RequestMethod requestMethod = (RequestMethod)item$iv;
            void var13_13 = destination$iv;
            boolean bl = false;
            String string = rm.name().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            var13_13.add(string);
        }
        springMvcUrlTargetInfo.methods = (Set)destination$iv;
    }

    @NotNull
    public List<String> getSchemes() {
        return this.schemes;
    }

    @NotNull
    public final UrlMappingElement getUrlMapping() {
        return this.urlMapping;
    }

    @NotNull
    public List<Authority> getAuthorities() {
        return this.authorities;
    }

    @NotNull
    public UrlPath getPath() {
        return this.path;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.RequestMapping;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"RequestMapping");
        return icon;
    }

    public boolean isDeprecated() {
        return UastUrlAttributeUtils.isUastDeclarationDeprecated((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public PsiElement resolveToPsiElement() {
        return this.urlMapping.getNavigationTarget();
    }

    @NotNull
    public Set<String> getMethods() {
        return this.methods;
    }

    @NotNull
    public String getSource() {
        return UastUrlAttributeUtils.getUastDeclaringLocation((PsiElement)this.resolveToPsiElement());
    }

    @Nullable
    public PsiElement getDocumentationPsiElement() {
        return this.urlMapping.getDocumentationPsiElement();
    }

    @NotNull
    public Iterable<UrlQueryParameter> getQueryParameters() {
        return SpringMvcUrlResolverKt.getSpringQueryParameterSupport().getParametersFromDeclarationContext(this.resolveToPsiElement());
    }
}

