/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.pathVariables;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.jvm.pathvars.PathVariableMethodInspection;
import com.intellij.microservices.url.parameters.PathVariableUtils;
import com.intellij.microservices.url.references.UrlPathContext;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.model.SpringUrlPathSpecificationProviderKt;
import com.intellij.spring.mvc.model.jam.MVCPathVariable;
import com.intellij.spring.mvc.model.jam.RequestMapping;
import com.intellij.spring.mvc.model.jam.SpringMVCModelAttribute;
import com.intellij.spring.mvc.webClient.exchange.SpringExchangeUrlPathSpecification;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J+\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/intellij/spring/mvc/pathVariables/MVCPathVariableInspection;", "Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection;", "<init>", "()V", "isApplicable", "", "module", "Lcom/intellij/openapi/module/Module;", "getUrlPathContext", "Lcom/intellij/microservices/url/references/UrlPathContext;", "method", "Lorg/jetbrains/uast/UMethod;", "pathVariableAnnotationFQN", "", "getPathVariableAnnotationFQN", "()Ljava/lang/String;", "checkMethod", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "(Lorg/jetbrains/uast/UMethod;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getConsumedPathVariables", "", "Lcom/intellij/microservices/jvm/pathvars/PathVariableMethodInspection$PathVariableConsumerInfo;", "getClassLevelVariables", "containingClass", "Lorg/jetbrains/uast/UClass;", "extractPathVariableUsageFromTheParameter", "uParameter", "Lorg/jetbrains/uast/UParameter;", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nMVCPathVariableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MVCPathVariableInspection.kt\ncom/intellij/spring/mvc/pathVariables/MVCPathVariableInspection\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,110:1\n216#2,2:111\n1#3:113\n19#4:114\n*S KotlinDebug\n*F\n+ 1 MVCPathVariableInspection.kt\ncom/intellij/spring/mvc/pathVariables/MVCPathVariableInspection\n*L\n64#1:111,2\n91#1:114\n*E\n"})
public final class MVCPathVariableInspection
extends PathVariableMethodInspection {
    public boolean isApplicable(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return SpringCommonUtils.isSpringConfigured((Module)module);
    }

    @NotNull
    public UrlPathContext getUrlPathContext(@NotNull UMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiMethod psiMethod = method.getJavaPsi();
        UrlPathContext urlPathContext = SpringUrlPathSpecificationProviderKt.getSpringFrameworkUrlPathSpecification().getUrlPathContext((PsiElement)psiMethod);
        if (!urlPathContext.isEmpty()) {
            return urlPathContext;
        }
        return SpringExchangeUrlPathSpecification.INSTANCE.getUrlPathContext((PsiElement)psiMethod);
    }

    @NotNull
    public String getPathVariableAnnotationFQN() {
        return "org.springframework.web.bind.annotation.PathVariable";
    }

    @NotNull
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Object[] baseProblems = super.checkMethod(method, manager, isOnTheFly);
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
        if (uClass == null) {
            return baseProblems;
        }
        UClass containingClass = uClass;
        PsiMethod psiMethod = method.getJavaPsi();
        if (SpringMVCModelAttribute.METHOD_META.getJamElement((PsiModifierListOwner)psiMethod) == null) {
            return baseProblems;
        }
        PsiParameter[] psiParameterArray = psiMethod.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        Map variables = MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])psiParameterArray), MVCPathVariableInspection::checkMethod$lambda$1));
        if (variables.isEmpty()) {
            return baseProblems;
        }
        HashMap undeclaredUsages = new HashMap();
        HashSet unusedDeclarations = new HashSet();
        for (UMethod uMethod : containingClass.getMethods()) {
            UrlPathContext urlPathContext = this.getUrlPathContext(uMethod);
            if (urlPathContext.isEmpty()) continue;
            Set allDeclaredPathVariableNamesForContext = CollectionsKt.toSet((Iterable)PathVariableUtils.getPathVariablesFromContext((UrlPathContext)urlPathContext));
            unusedDeclarations.addAll(SetsKt.minus((Set)allDeclaredPathVariableNamesForContext, (Iterable)variables.keySet()));
            Map $this$forEach$iv = variables;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
                String name = (String)k;
                PathVariableMethodInspection.PathVariableConsumerInfo info = (PathVariableMethodInspection.PathVariableConsumerInfo)entry.getValue();
                if (allDeclaredPathVariableNamesForContext.contains(name)) continue;
                ((Map)undeclaredUsages).put(name, info);
            }
        }
        PsiElement psiElement = method.getSourcePsi();
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptor.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, (PsiFile)psiElement, isOnTheFly);
        for (Map.Entry entry : ((Map)undeclaredUsages).entrySet()) {
            String pathVariableName = (String)entry.getKey();
            PathVariableMethodInspection.PathVariableConsumerInfo consumerInfo = (PathVariableMethodInspection.PathVariableConsumerInfo)entry.getValue();
            PsiElement anchor = consumerInfo.getAnchor();
            if (anchor == null || !consumerInfo.getReportIfNotDeclared()) continue;
            Object[] objectArray = new Object[]{pathVariableName};
            String string = MicroservicesBundle.message((String)"PathVariableInspection.cannot.resolve", (Object[])objectArray);
            objectArray = LocalQuickFix.notNullElements((LocalQuickFix)this.createRenameQuickfix(anchor, pathVariableName, unusedDeclarations));
            holder.registerProblem(anchor, string, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        }
        ProblemDescriptor[] problemDescriptorArray = holder.getResultsArray();
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptorArray, (String)"getResultsArray(...)");
        return (ProblemDescriptor[])ArraysKt.plus((Object[])baseProblems, (Object[])problemDescriptorArray);
    }

    @NotNull
    protected Map<String, PathVariableMethodInspection.PathVariableConsumerInfo> getConsumedPathVariables(@NotNull UMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Map consumedPathVariables = super.getConsumedPathVariables(method);
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)method));
        if (uClass == null) {
            return consumedPathVariables;
        }
        UClass containingClass = uClass;
        return MapsKt.plus((Map)consumedPathVariables, this.getClassLevelVariables(containingClass));
    }

    private final Map<String, PathVariableMethodInspection.PathVariableConsumerInfo> getClassLevelVariables(UClass containingClass) {
        List list = RequestMapping.MODEL_ATTRIBUTE_METHODS_QUERY.findChildren(PsiElementRef.real((PsiElement)((PsiElement)containingClass.getJavaPsi())));
        Object object = list != null ? CollectionsKt.asSequence((Iterable)list) : null;
        if (object == null) {
            object = SequencesKt.emptySequence();
        }
        return MapsKt.toMap((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.mapNotNull((Sequence)object, MVCPathVariableInspection::getClassLevelVariables$lambda$3), MVCPathVariableInspection::getClassLevelVariables$lambda$4), MVCPathVariableInspection::getClassLevelVariables$lambda$6));
    }

    @Nullable
    protected PathVariableMethodInspection.PathVariableConsumerInfo extractPathVariableUsageFromTheParameter(@NotNull UParameter uParameter) {
        Intrinsics.checkNotNullParameter((Object)uParameter, (String)"uParameter");
        PathVariableMethodInspection.PathVariableConsumerInfo pathVariableConsumerInfo = super.extractPathVariableUsageFromTheParameter(uParameter);
        if (pathVariableConsumerInfo != null) {
            PathVariableMethodInspection.PathVariableConsumerInfo it = pathVariableConsumerInfo;
            boolean bl = false;
            return it;
        }
        UAnnotation uAnnotation = uParameter.findAnnotation("org.springframework.web.bind.annotation.MatrixVariable");
        if (uAnnotation == null) {
            return null;
        }
        UAnnotation matrixVariableUAnno = uAnnotation;
        UExpression pathVariableNameExpression = matrixVariableUAnno.findDeclaredAttributeValue("pathVar");
        Object object = pathVariableNameExpression;
        if (object == null || (object = UastUtils.evaluateString((UExpression)object)) == null) {
            return null;
        }
        Object pathVarName = object;
        return new PathVariableMethodInspection.PathVariableConsumerInfo((String)pathVarName, pathVariableNameExpression.getSourcePsi(), true);
    }

    private static final Pair checkMethod$lambda$1(PsiParameter param) {
        Pair pair;
        MVCPathVariable mVCPathVariable = (MVCPathVariable)MVCPathVariable.META.getJamElement((PsiModifierListOwner)param);
        if (mVCPathVariable != null) {
            MVCPathVariable pv = mVCPathVariable;
            boolean bl = false;
            String string = pv.getName();
            String string2 = pv.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-name>(...)");
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)param));
            pair = TuplesKt.to((Object)string, (Object)new PathVariableMethodInspection.PathVariableConsumerInfo(string2, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), true));
        } else {
            pair = null;
        }
        return pair;
    }

    private static final PsiMethod getClassLevelVariables$lambda$3(SpringMVCModelAttribute springMVCModelAttribute) {
        PsiElement $this$asSafely$iv = springMVCModelAttribute.getPsiElement();
        boolean $i$f$asSafely = false;
        PsiElement psiElement = $this$asSafely$iv;
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        return (PsiMethod)psiElement;
    }

    private static final Sequence getClassLevelVariables$lambda$4(PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
        return ArraysKt.asSequence((Object[])psiParameterArray);
    }

    private static final Pair getClassLevelVariables$lambda$6(PsiParameter param) {
        Pair pair;
        MVCPathVariable mVCPathVariable = (MVCPathVariable)MVCPathVariable.META.getJamElement((PsiModifierListOwner)param);
        if (mVCPathVariable != null) {
            MVCPathVariable pv = mVCPathVariable;
            boolean bl = false;
            String string = pv.getName();
            String string2 = pv.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-name>(...)");
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)param));
            pair = TuplesKt.to((Object)string, (Object)new PathVariableMethodInspection.PathVariableConsumerInfo(string2, (PsiElement)(uElement != null ? uElement.getSourcePsi() : null), false));
        } else {
            pair = null;
        }
        return pair;
    }
}

