/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.services;

import com.intellij.javaee.web.CommonServletMapping;
import com.intellij.javaee.web.ServletMappingInfo;
import com.intellij.javaee.web.ServletMappingType;
import com.intellij.javaee.web.WebDirectoryElement;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.mvc.SpringControllerClassInfo;
import com.intellij.spring.mvc.functional.utils.SpringMvcFunctionalUtil;
import com.intellij.spring.mvc.mapping.UrlMappingElement;
import com.intellij.spring.mvc.model.PerformanceTracker;
import com.intellij.spring.mvc.model.jam.SpringMvcUrlPathSpecification;
import com.intellij.spring.mvc.model.mappings.processors.AnnotatedRequestMappingsProcessor;
import com.intellij.spring.mvc.model.mappings.processors.WebMvcConfigurationRequestMappingProcessor;
import com.intellij.spring.mvc.model.mappings.processors.XmlDefinitionMappingProcessor;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.spring.mvc.views.ViewResolver;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Plow;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class SpringMvcUtils {
    private static final Key<CachedValue<List<UrlMappingElement>>> ANNOTATED_MAPPINGS_CACHE_KEY = Key.create((String)"spring.annotated.mappings");
    private static final Key<CachedValue<List<UrlMappingElement>>> FUNCTIONAL_MAPPINGS_CACHE_KEY = Key.create((String)"spring.functional.mappings");

    public static boolean processVariables(PsiElement viewContext, Processor<? super PsiVariable> processor, @Nullable String nameHint) {
        return SpringMvcUtils.processVariables(processor, viewContext.getContainingFile().getOriginalFile(), nameHint);
    }

    public static boolean processVariables(@NotNull Processor<? super PsiVariable> processor, @NotNull PsiFile psiFile, @Nullable String nameHint) {
        Module module;
        if (processor == null) {
            SpringMvcUtils.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            SpringMvcUtils.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)psiFile)) == null) {
            return true;
        }
        Set<SpringBeanPointer<?>> controllers = SpringMvcService.getInstance().getControllers(module);
        if (controllers.isEmpty()) {
            return true;
        }
        Set<ViewResolver> resolvers = SpringMvcService.getInstance().getViewResolvers(module);
        Promise emptyVariablesPromise = Promises.resolvedPromise((Object)MultiMap.empty());
        List promises = ContainerUtil.map(controllers, pointer -> {
            ProgressManager.checkCanceled();
            PsiClass beanClass = pointer.getBeanClass();
            if (beanClass == null || beanClass instanceof PsiCompiledElement) {
                return emptyVariablesPromise;
            }
            return SpringControllerClassInfo.getVariablesAsync(beanClass);
        });
        List allCollectedResults = (List)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)Promises.asCompletableFuture((Promise)Promises.collectResults((Collection)promises)));
        for (MultiMap controllerVariables : allCollectedResults) {
            if (nameHint != null && !ContainerUtil.exists((Iterable)controllerVariables.values(), variable -> nameHint.equals(variable.getName()))) continue;
            for (String view : controllerVariables.keySet()) {
                for (ViewResolver resolver : resolvers) {
                    ProgressManager.checkCanceled();
                    for (PsiElement resolvedView : resolver.resolveView(view)) {
                        Collection variables;
                        if (!psiFile.equals(resolvedView) || ContainerUtil.process((Iterable)(variables = controllerVariables.get((Object)view)), processor)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @NotNull
    public static Set<WebDirectoryElement> findWebDirectoryElements(@NotNull String path, Module module) {
        if (path == null) {
            SpringMvcUtils.$$$reportNull$$$0(2);
        }
        HashSet<WebDirectoryElement> elements = new HashSet<WebDirectoryElement>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            ContainerUtil.addIfNotNull(elements, (Object)WebUtil.getWebUtil().findWebDirectoryElement(path, webFacet));
        }
        HashSet<WebDirectoryElement> hashSet = elements;
        if (hashSet == null) {
            SpringMvcUtils.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    @NotNull
    public static Set<ServletMappingInfo> getServletMappingInfos(@NotNull Module module) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(4);
        }
        HashSet<ServletMappingInfo> infos = new HashSet<ServletMappingInfo>();
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            for (CommonServletMapping mapping : webFacet.getWebModel().getServletMappings()) {
                infos.addAll(ServletMappingInfo.createMappingInfos((CommonServletMapping)mapping));
            }
        }
        HashSet<ServletMappingInfo> hashSet = infos;
        if (hashSet == null) {
            SpringMvcUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    public static List<UrlMappingElement> getUrlMappings(@NotNull Module module) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(6);
        }
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ModificationTracker tracker = SpringModificationTrackersManager.getInstance((Project)module.getProject()).getEndpointsModificationTracker();
            List<UrlMappingElement> mappings = SpringMvcUtils.getUrlMappings(module, SpringManager.getInstance((Project)module.getProject()).getAllModels(module));
            return CachedValueProvider.Result.create(mappings, (Object[])new Object[]{tracker, SpringModificationTrackersManager.getInstance((Project)module.getProject()).getOuterModelsDependencies()});
        });
    }

    @NotNull
    public static List<UrlMappingElement> getUrlMappings(@NotNull Module module, @NotNull Collection<SpringModel> models) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(7);
        }
        if (models == null) {
            SpringMvcUtils.$$$reportNull$$$0(8);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        SpringMvcUtils.processMappingDefinitions(module, models, (CommonProcessors.CollectProcessor<UrlMappingElement>)processor);
        return new ArrayList<UrlMappingElement>(processor.getResults());
    }

    @NotNull
    public static Iterable<UrlMappingElement> getUrlMappingsWithoutSpringModel(@NotNull Module module, @NotNull BiConsumer<? super Long, ? super Integer> listener) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(9);
        }
        if (listener == null) {
            SpringMvcUtils.$$$reportNull$$$0(10);
        }
        PerformanceTracker tracker = new PerformanceTracker(listener, 2);
        CachedValue<List<UrlMappingElement>> annotationListMapping = SpringMvcUtils.getAnnotatedMappingsCacheValue(module);
        CachedValue<List<UrlMappingElement>> functionalRouterMapping = SpringMvcUtils.getFunctionalMappingsCacheValue(module);
        StreamEx streamEx = StreamEx.of((Object[])new Supplier[]{() -> (List)PerformanceTracker.weakTrack(tracker, Collection::size, annotationListMapping), () -> (List)PerformanceTracker.weakTrack(tracker, Collection::size, functionalRouterMapping)}).flatMap(provider -> ((List)provider.get()).stream());
        if (streamEx == null) {
            SpringMvcUtils.$$$reportNull$$$0(11);
        }
        return streamEx;
    }

    @NotNull
    private static CachedValue<List<UrlMappingElement>> getFunctionalMappingsCacheValue(@NotNull Module module) {
        CachedValue existingCache;
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(12);
        }
        if ((existingCache = (CachedValue)module.getUserData(FUNCTIONAL_MAPPINGS_CACHE_KEY)) != null) {
            CachedValue cachedValue = existingCache;
            if (cachedValue == null) {
                SpringMvcUtils.$$$reportNull$$$0(13);
            }
            return cachedValue;
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)Plow.of(processor -> SpringMvcFunctionalUtil.processRouterFunctionUrlMappingsWithoutSpringModel((Processor<UrlMappingElement>)processor, module)).toList(), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject())}));
        module.putUserData(FUNCTIONAL_MAPPINGS_CACHE_KEY, (Object)cachedValue);
        CachedValue cachedValue2 = cachedValue;
        if (cachedValue2 == null) {
            SpringMvcUtils.$$$reportNull$$$0(14);
        }
        return cachedValue2;
    }

    @NotNull
    private static CachedValue<List<UrlMappingElement>> getAnnotatedMappingsCacheValue(@NotNull Module module) {
        CachedValue existingCache;
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(15);
        }
        if ((existingCache = (CachedValue)module.getUserData(ANNOTATED_MAPPINGS_CACHE_KEY)) != null) {
            CachedValue cachedValue = existingCache;
            if (cachedValue == null) {
                SpringMvcUtils.$$$reportNull$$$0(16);
            }
            return cachedValue;
        }
        CachedValue cachedValue = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)Plow.of(processor -> AnnotatedRequestMappingsProcessor.processAnnotationMappings((Processor<UrlMappingElement>)processor, module)).toList(), (Object[])new Object[]{UastModificationTracker.getInstance((Project)module.getProject())}));
        module.putUserData(ANNOTATED_MAPPINGS_CACHE_KEY, (Object)cachedValue);
        CachedValue cachedValue2 = cachedValue;
        if (cachedValue2 == null) {
            SpringMvcUtils.$$$reportNull$$$0(17);
        }
        return cachedValue2;
    }

    private static boolean processMappingDefinitions(@NotNull Module module, @NotNull Collection<SpringModel> models, @NotNull CommonProcessors.CollectProcessor<UrlMappingElement> processor) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(18);
        }
        if (models == null) {
            SpringMvcUtils.$$$reportNull$$$0(19);
        }
        if (processor == null) {
            SpringMvcUtils.$$$reportNull$$$0(20);
        }
        if (!XmlDefinitionMappingProcessor.processXmlDefinitions(module, models, processor)) {
            return false;
        }
        if (!AnnotatedRequestMappingsProcessor.processAnnotationMappings(processor, module)) {
            return false;
        }
        if (!WebMvcConfigurationRequestMappingProcessor.processWebMvcSupport(processor, module, models)) {
            return false;
        }
        return SpringMvcFunctionalUtil.processRouterFunctionUrlMappings(processor, module, models);
    }

    @ApiStatus.Internal
    public static Collection<UrlMappingElement> getMatchingUrlMappings(@NotNull Module module, @NotNull UrlPath urlPath) {
        if (module == null) {
            SpringMvcUtils.$$$reportNull$$$0(21);
        }
        if (urlPath == null) {
            SpringMvcUtils.$$$reportNull$$$0(22);
        }
        List<UrlMappingElement> urlMappings = SpringMvcUtils.getUrlMappings(module);
        String url = urlPath.getPresentation(UrlPath.FULL_PATH_VARIABLE_PRESENTATION);
        SmartList results = new SmartList(SpringMvcUtils.getResolvedResults(urlMappings, urlPath));
        for (ServletMappingInfo info : SpringMvcUtils.getServletMappingInfos(module)) {
            String servletInfoUrl;
            if (!results.isEmpty() || info.getType() != ServletMappingType.EXTENSION || info.matches(url) || (servletInfoUrl = info.addMapping(url)) == null || servletInfoUrl.equals(url)) continue;
            results.addAll(SpringMvcUtils.getResolvedResults(urlMappings, SpringMvcUrlPathSpecification.INSTANCE.parsePath(servletInfoUrl)));
        }
        return results;
    }

    @NotNull
    private static List<UrlMappingElement> getResolvedResults(@NotNull List<UrlMappingElement> urlMappings, @NotNull UrlPath urlPath) {
        if (urlMappings == null) {
            SpringMvcUtils.$$$reportNull$$$0(23);
        }
        if (urlPath == null) {
            SpringMvcUtils.$$$reportNull$$$0(24);
        }
        SmartList results = new SmartList();
        for (UrlMappingElement mapping : urlMappings) {
            if (!mapping.getUrlPath().isCompatibleWith(urlPath)) continue;
            ContainerUtil.addIfNotNull((Collection)results, (Object)mapping);
        }
        SmartList smartList = results;
        if (smartList == null) {
            SpringMvcUtils.$$$reportNull$$$0(25);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 11, 13, 14, 16, 17, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/services/SpringMvcUtils";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPath";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/services/SpringMvcUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findWebDirectoryElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getServletMappingInfos";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrlMappingsWithoutSpringModel";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionalMappingsCacheValue";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedMappingsCacheValue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedResults";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processVariables";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findWebDirectoryElements";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 25: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServletMappingInfos";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUrlMappings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUrlMappingsWithoutSpringModel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalMappingsCacheValue";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedMappingsCacheValue";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processMappingDefinitions";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingUrlMappings";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedResults";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 11, 13, 14, 16, 17, 25 -> new IllegalStateException(string);
        };
    }
}

