/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.action.creation.entity;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jpa.jpb.model.action.creation.entity.ReferenceType;
import com.intellij.jpa.jpb.model.backend.ed.EntityDesignHelper;
import com.intellij.jpa.jpb.model.backend.ed.EntityWriter;
import com.intellij.jpa.jpb.model.backend.ed.FqnResolverManagerKt;
import com.intellij.jpa.jpb.model.backend.ed.indexing.EntitySearch;
import com.intellij.jpa.jpb.model.backend.events.EntityAddedEvent;
import com.intellij.jpa.jpb.model.backend.events.ExceptionEvent;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.multilanguage.LanguageServiceManager;
import com.intellij.jpa.jpb.model.model.BaseEntity;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.model.SourceLanguage;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class EntityCreator {
    public static final @NlsContexts.Command String COMMAND_NAME = JpaModelBundle.message("command.name.create.entity", new Object[0]);
    private static final String JPA_PACKAGE = "JPA_PACKAGE";
    private static final String IS_DB_VIEW = "IS_DB_VIEW";
    private final Application application = ApplicationManager.getApplication();
    private final Project project;
    private final JpaPluginProjectConfig pluginProjectConfig;

    public EntityCreator(Project project) {
        this.project = project;
        this.pluginProjectConfig = JpaPluginProjectConfig.getInstance(project);
    }

    public static EntityCreator getInstance(Project project) {
        return (EntityCreator)project.getService(EntityCreator.class);
    }

    @Nullable
    public EntityCreateResult create(@Nullable XmlFile configXml, @NotNull EntityModel entityModel, @NotNull PsiDirectory targetDirectory, @Nullable SourceLanguage generationLanguage) {
        if (entityModel == null) {
            EntityCreator.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            EntityCreator.$$$reportNull$$$0(1);
        }
        return this.application.isWriteAccessAllowed() ? this.doCreate(configXml, entityModel, targetDirectory, generationLanguage) : (EntityCreateResult)WriteCommandAction.writeCommandAction((Project)this.project).withName(JpaModelBundle.message("EntityCreator.write.command.create", new Object[0])).withGlobalUndo().compute(() -> this.doCreate(configXml, entityModel, targetDirectory, generationLanguage));
    }

    @Nullable
    private EntityCreateResult doCreate(@Nullable XmlFile configXml, @NotNull EntityModel entityModel, @NotNull PsiDirectory targetDirectory, @Nullable SourceLanguage generationLanguage) {
        PsiClassOwner entityFile;
        if (entityModel == null) {
            EntityCreator.$$$reportNull$$$0(2);
        }
        if (targetDirectory == null) {
            EntityCreator.$$$reportNull$$$0(3);
        }
        if ((entityFile = this.createEntity(configXml, entityModel, targetDirectory, generationLanguage)) == null) {
            return null;
        }
        VirtualFile virtualFile = entityFile.getVirtualFile();
        if (virtualFile != null) {
            FileBasedIndex.getInstance().requestReindex(virtualFile);
        }
        new EntityAddedEvent(entityModel).post(this.project.getMessageBus());
        return new EntityCreateResult(entityFile, new PsiFile[]{entityFile});
    }

    @Nullable
    private PsiClassOwner createEntity(@Nullable XmlFile configXml, @NotNull EntityModel entityModel, @NotNull PsiDirectory targetDirectory, @Nullable SourceLanguage generationLanguage) {
        if (entityModel == null) {
            EntityCreator.$$$reportNull$$$0(4);
        }
        if (targetDirectory == null) {
            EntityCreator.$$$reportNull$$$0(5);
        }
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Properties props = templateManager.getDefaultProperties();
        props.setProperty("NAME", entityModel.getClassName());
        props.setProperty("PACKAGE_NAME", entityModel.getPackageName());
        props.setProperty(IS_DB_VIEW, String.valueOf(entityModel.isDbView()));
        props.setProperty(JPA_PACKAGE, FqnResolverManagerKt.getJpaPrefix(this.project, entityModel.getModule()));
        FileTemplate template = templateManager.getJ2eeTemplate(EntityCreator.getTemplate(generationLanguage));
        try {
            PsiElement element = FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)entityModel.getClassName(), (Properties)props, (PsiDirectory)targetDirectory);
            EntitySearch entitySearch = EntitySearch.getInstance(this.project);
            EntityWriter parser = LanguageServiceManager.getInstance(this.project).getService(element.getContainingFile(), EntityWriter.class);
            assert (parser != null);
            this.prepareModel(entityModel);
            PsiClass entityClass = EntityCreator.createdElementToEntityPsi(element);
            if (entityClass == null) {
                return null;
            }
            parser.commitEntityToPsi(entityModel, entityClass);
            Entity compKeyType = entityModel.getCompKeyType();
            if (compKeyType != null && compKeyType.isEmbeddable() && !(compKeyType instanceof BaseEntity) && !compKeyType.hasEqualsAndHashCode()) {
                EntityModel compKeyTypeModel = compKeyType.getModel();
                EntityDesignHelper.addEqualsAndHasCodeMethods(compKeyTypeModel);
                PsiClass parentClass = entitySearch.findEntityPsiClass(compKeyTypeModel);
                parser.commitEntityToPsi(compKeyTypeModel, parentClass);
            }
            ProjectState state = JpaPluginProjectConfig.getInstance(this.project).getState();
            if (state.generateSerialVersionUID) {
                parser.addSerializableParentIfNeeded(entityClass);
                parser.addSerialVersionUID(entityClass);
            }
            if (configXml != null) {
                EntityUtil.registerEntity(entityClass, configXml);
            }
            return (PsiClassOwner)element.getContainingFile();
        }
        catch (PsiInvalidElementAccessException e) {
            return null;
        }
        catch (Exception e) {
            new ExceptionEvent("Exception while trying to create entity: '" + entityModel.getClassName() + "'", e).post(this.project);
            return null;
        }
    }

    private void prepareModel(EntityModel entityModel) {
        ProjectState projectState = this.pluginProjectConfig.getState();
        entityModel.setLombokGetter(projectState.isLombokGetterAndSetter);
        entityModel.setLombokSetter(projectState.isLombokGetterAndSetter);
        entityModel.setLombokToString(projectState.isLombokToString);
        entityModel.setLombokOnlyExplicitlyIncluded(projectState.isLombokOnlyExplicitlyIncluded);
        entityModel.setLombokBuilder(projectState.isLombokBuilder);
        entityModel.setLombokAllArgsConstructor(projectState.isLombokAllArgsConstructor);
        entityModel.setLombokNoArgsConstructor(projectState.isLombokNoArgsConstructor);
    }

    @Nullable
    private static PsiClass createdElementToEntityPsi(PsiElement element) {
        if (element instanceof PsiClassOwner && ((PsiClassOwner)element).getClasses().length != 0) {
            return ((PsiClassOwner)element).getClasses()[0];
        }
        if (element instanceof PsiClass) {
            return (PsiClass)element;
        }
        return null;
    }

    @NotNull
    private static String getTemplate(SourceLanguage generationLanguage) {
        return generationLanguage == SourceLanguage.KOTLIN ? "com.intellij.jpb.JpaEntity.kt" : "com.intellij.jpb.JpaEntity.java";
    }

    @NotNull
    public static EntityModel createEntityModel(@NotNull Project project, @NotNull EntityInfo info) {
        if (project == null) {
            EntityCreator.$$$reportNull$$$0(6);
        }
        if (info == null) {
            EntityCreator.$$$reportNull$$$0(7);
        }
        String className = info.getClassName();
        EntityModel entityModel = new EntityModel();
        entityModel.setPackageName(info.getPackageName());
        entityModel.setClassName(className);
        entityModel.setPersistentEntity(true);
        Entity parentEntity = info.getParentEntity();
        entityModel.setParent(parentEntity);
        Entity.EntityType entityType = info.getEntityType();
        if (entityType == Entity.EntityType.PERSISTENT) {
            EntityDesignHelper entityDesignHelper = EntityDesignHelper.getInstance(project);
            entityModel.setName(entityDesignHelper.generateEntityName(className));
            entityModel.setTable(entityDesignHelper.generateTableName(className));
            entityModel.setPersistentEntity(true);
            if (parentEntity != null && EntityDesignHelper.getInheritanceType(parentEntity) == Entity.InheritanceType.SINGLE_TABLE && EntityDesignHelper.getPersistentParent(entityModel) != null && !parentEntity.isMappedSuperclass()) {
                entityModel.setTable(null);
            }
        } else if (entityType == Entity.EntityType.MAPPED_SUPERCLASS) {
            entityModel.setMappedSuperclass(true);
            entityModel.setPersistentEntity(false);
        } else if (entityType == Entity.EntityType.EMBEDDABLE) {
            entityModel.setEmbeddable(true);
            entityModel.setPersistentEntity(false);
        }
        EntityModel entityModel2 = entityModel;
        if (entityModel2 == null) {
            EntityCreator.$$$reportNull$$$0(8);
        }
        return entityModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityModel";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/action/creation/entity/EntityCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/action/creation/entity/EntityCreator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntityModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCreate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEntity";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createEntityModel";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    public static class EntityCreateResult {
        public final PsiClassOwner entity;
        public final PsiFile[] affectedFiles;
        private EntityAttribute.Cardinality cardinality;
        private ReferenceType referenceType;

        public EntityCreateResult(PsiClassOwner entity, PsiFile ... affectedFiles) {
            this.entity = entity;
            this.affectedFiles = affectedFiles;
        }

        public EntityAttribute.Cardinality getCardinality() {
            return this.cardinality;
        }

        public void setCardinality(EntityAttribute.Cardinality cardinality) {
            this.cardinality = cardinality;
        }

        public ReferenceType getReferenceType() {
            return this.referenceType;
        }

        public void setReferenceType(ReferenceType referenceType) {
            this.referenceType = referenceType;
        }
    }

    public static interface EntityInfo {
        @NotNull
        public String getClassName();

        @NotNull
        public String getPackageName();

        @Nullable
        public Entity getParentEntity();

        @NotNull
        public Entity.EntityType getEntityType();
    }

    public static enum IdType {
        LONG("Long", Datatypes.BasicDatatype.Long),
        INTEGER("Integer", Datatypes.BasicDatatype.Integer),
        STRING("String", Datatypes.BasicDatatype.String),
        UUID("UUID", Datatypes.BasicDatatype.UUID),
        EMBEDDED("Embedded");

        private final Datatypes.BasicDatatype dataType;
        private final String value;

        private IdType(String value) {
            this(value, null);
        }

        private IdType(String value, Datatypes.BasicDatatype datatype) {
            this.value = value;
            this.dataType = datatype;
        }

        public Datatypes.BasicDatatype getDataType() {
            return this.dataType;
        }

        public String toString() {
            return this.value;
        }

        @Nullable
        public static IdType getByDatatype(Datatypes.BasicDatatype datatype) {
            return (IdType)((Object)ContainerUtil.find((Object[])IdType.values(), it -> it.dataType == datatype));
        }
    }
}

