/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation;

import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationInfo {
    private String annotationFqn;
    private AnnotationAttribute[] attributes;

    public AnnotationInfo(String annotationFqn, AnnotationAttribute ... attributes) {
        this.annotationFqn = annotationFqn;
        this.attributes = attributes;
    }

    public String getAnnotationFqn() {
        return this.annotationFqn;
    }

    public AnnotationAttribute[] getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.attributes.length == 0 ? "@" + this.annotationFqn : StreamEx.of((Object[])this.attributes).joining((CharSequence)",\n", (CharSequence)("@" + this.annotationFqn + "("), (CharSequence)")");
    }

    public static abstract class AnnotationAttribute {
        protected String name;

        public AnnotationAttribute(@Nullable String name) {
            this.name = name;
        }

        public String toString() {
            return this.name == null ? "" : this.name + " = ";
        }
    }

    public static class ArrayValueAttribute
    extends AnnotationAttribute {
        private Object[] value;

        public ArrayValueAttribute(@NotNull Object[] value) {
            if (value == null) {
                ArrayValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public ArrayValueAttribute(@Nullable String name, @NotNull Object[] value) {
            if (value == null) {
                ArrayValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String toString() {
            return super.toString() + StreamEx.of((Object[])this.value).joining((CharSequence)",\n", (CharSequence)"{\n", (CharSequence)"}");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$ArrayValueAttribute", "<init>"));
        }
    }

    public static class AnnotationValueAttribute
    extends AnnotationAttribute {
        private AnnotationInfo value;

        public AnnotationValueAttribute(@NotNull AnnotationInfo value) {
            if (value == null) {
                AnnotationValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public AnnotationValueAttribute(@Nullable String name, @NotNull AnnotationInfo value) {
            if (value == null) {
                AnnotationValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String toString() {
            return super.toString() + this.value.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$AnnotationValueAttribute", "<init>"));
        }
    }

    public static class ClassValueAttribute
    extends AnnotationAttribute {
        private String value;

        public ClassValueAttribute(@NotNull String value) {
            if (value == null) {
                ClassValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public ClassValueAttribute(@Nullable String name, @NotNull String value) {
            if (value == null) {
                ClassValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String toString() {
            return super.toString() + this.value;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$ClassValueAttribute", "<init>"));
        }
    }

    public static class BooleanValueAttribute
    extends AnnotationAttribute {
        private boolean value;

        public BooleanValueAttribute(boolean value) {
            super(null);
            this.value = value;
        }

        public BooleanValueAttribute(@Nullable String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public String toString() {
            return super.toString() + this.value;
        }
    }

    public static class StringValueAttribute
    extends AnnotationAttribute {
        protected final String value;

        public StringValueAttribute(@NotNull String value) {
            if (value == null) {
                StringValueAttribute.$$$reportNull$$$0(0);
            }
            super(null);
            this.value = value;
        }

        public StringValueAttribute(@Nullable String name, @NotNull String value) {
            if (value == null) {
                StringValueAttribute.$$$reportNull$$$0(1);
            }
            super(name);
            this.value = value;
        }

        @Override
        public String toString() {
            return super.toString() + "\"" + this.value + "\"";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jpa/jpb/model/backend/ed/annotation/AnnotationInfo$StringValueAttribute", "<init>"));
        }
    }
}

