/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.swing;

import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.ui.swing.SFieldWithActions;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TextAccessor;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u000fB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/ui/swing/JpbSelectFileField;", "Lcom/intellij/jpa/jpb/model/ui/swing/SFieldWithActions;", "Ljavax/swing/JTextField;", "Lcom/intellij/ui/TextAccessor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "setText", "", "text", "", "getText", "ChooseFileActionListener", "intellij.javaee.jpa.jpb.model.ui"})
public class JpbSelectFileField
extends SFieldWithActions<JTextField>
implements TextAccessor {
    @NotNull
    private final Project project;

    public JpbSelectFileField(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((JComponent)new JTextField(), new SFieldWithActions.FieldAction[0]);
        this.project = project;
        Object f = this.getField();
        Intrinsics.checkNotNullExpressionValue(f, (String)"getField(...)");
        this.addAction(new ChooseFileActionListener((JTextField)f, this.project));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void setText(@Nullable String text) {
        ((JTextField)this.getField()).setText(text);
    }

    @NotNull
    public String getText() {
        String string = ((JTextField)this.getField()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jpa/jpb/model/ui/swing/JpbSelectFileField$ChooseFileActionListener;", "Lcom/intellij/jpa/jpb/model/ui/swing/SFieldWithActions$FieldAction;", "field", "Ljavax/swing/JTextField;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljavax/swing/JTextField;Lcom/intellij/openapi/project/Project;)V", "getField", "()Ljavax/swing/JTextField;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.javaee.jpa.jpb.model.ui"})
    @SourceDebugExtension(value={"SMAP\nJpbSelectFileField.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JpbSelectFileField.kt\ncom/intellij/jpa/jpb/model/ui/swing/JpbSelectFileField$ChooseFileActionListener\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n37#2:75\n36#2,3:76\n37#2:79\n36#2,3:80\n*S KotlinDebug\n*F\n+ 1 JpbSelectFileField.kt\ncom/intellij/jpa/jpb/model/ui/swing/JpbSelectFileField$ChooseFileActionListener\n*L\n36#1:75\n36#1:76,3\n37#1:79\n37#1:80,3\n*E\n"})
    public static final class ChooseFileActionListener
    extends SFieldWithActions.FieldAction {
        @NotNull
        private final JTextField field;
        @NotNull
        private final Project project;

        public ChooseFileActionListener(@NotNull JTextField field, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super("ChooseFileActionListener", JpaModelBundle.message("action.browse.text", new Object[0]), AllIcons.General.OpenDiskHover);
            this.field = field;
            this.project = project;
        }

        @NotNull
        public final JTextField getField() {
            return this.field;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            VirtualFile rootFile;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Module module = (Module)ArraysKt.firstOrNull((Object[])ModuleManager.Companion.getInstance(this.project).getModules());
            if (module == null) {
                return;
            }
            Module module2 = module;
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module2);
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            List list = rootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSourceRoots(...)");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new VirtualFile[0]));
            List list2 = rootManager.getSourceRoots(JavaModuleSourceRootTypes.SOURCES);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSourceRoots(...)");
            $this$toTypedArray$iv = list2;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new VirtualFile[0]));
            List roots = CollectionsKt.mutableListOf((Object[])spreadBuilder.toArray((Object[])new VirtualFile[spreadBuilder.size()]));
            String string = this.field.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String pathValue = ((Object)StringsKt.trim((CharSequence)string)).toString();
            thisCollection$iv = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"xml").withRoots(roots).withTreeRootVisible(true);
            Collection $this$actionPerformed_u24lambda_u240 = thisCollection$iv;
            boolean bl = false;
            $this$actionPerformed_u24lambda_u240.setForcedToUseIdeaFileChooser(true);
            Collection collection = thisCollection$iv;
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"apply(...)");
            Collection chooserDescriptor = collection;
            VirtualFile currentSelectedFile = null;
            if (((CharSequence)pathValue).length() > 0) {
                thisCollection$iv = roots.iterator();
                while (thisCollection$iv.hasNext() && (currentSelectedFile = (rootFile = (VirtualFile)thisCollection$iv.next()).findFileByRelativePath(pathValue)) == null) {
                }
            }
            VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)chooserDescriptor, (Project)this.project, currentSelectedFile);
            if (virtualFile == null) {
                return;
            }
            VirtualFile chosenFile = virtualFile;
            VirtualFile[] virtualFileArray = rootManager.getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            rootFile = (VirtualFile)ArraysKt.firstOrNull((Object[])virtualFileArray);
            if (rootFile != null) {
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)chosenFile, (VirtualFile)rootFile);
                String string2 = relativePath;
                if (string2 == null) {
                    string2 = "";
                }
                this.field.setText(string2);
            }
        }
    }
}

