/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run.before;

import com.intellij.execution.BeforeRunTaskProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.ide.scratch.ScratchFileTypeIcon;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openRewrite.OpenRewriteBundle;
import com.intellij.openRewrite.OpenRewriteIcons;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeService;
import com.intellij.openRewrite.run.OpenRewriteExternalSystemBridge;
import com.intellij.openRewrite.run.OpenRewriteRunConfiguration;
import com.intellij.openRewrite.run.before.OpenRewriteInstallBeforeRunTask;
import com.intellij.openRewrite.run.before.OpenRewriteInstallBeforeRunTaskDialog;
import com.intellij.openRewrite.run.before.OpenRewriteInstallBeforeRunTaskProviderKt;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.impl.EmptyCompileScopeBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskManagerImpl;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.Compressor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J \u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0002H\u0002J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\bH\u0002J \u0010!\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\bH\u0002J(\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006#"}, d2={"Lcom/intellij/openRewrite/run/before/OpenRewriteInstallBeforeRunTaskProvider;", "Lcom/intellij/execution/BeforeRunTaskProvider;", "Lcom/intellij/openRewrite/run/before/OpenRewriteInstallBeforeRunTask;", "<init>", "()V", "getId", "Lcom/intellij/openapi/util/Key;", "getName", "", "getIcon", "Ljavax/swing/Icon;", "getTaskIcon", "task", "getDescription", "isConfigurable", "", "configureTask", "Lorg/jetbrains/concurrency/Promise;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "canExecuteTask", "createTask", "runConfiguration", "compile", "Lcom/intellij/openRewrite/run/OpenRewriteRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "build", "project", "Lcom/intellij/openapi/project/Project;", "name", "install", "executeTask", "intellij.openRewrite"})
public final class OpenRewriteInstallBeforeRunTaskProvider
extends BeforeRunTaskProvider<OpenRewriteInstallBeforeRunTask> {
    @NotNull
    public Key<OpenRewriteInstallBeforeRunTask> getId() {
        return OpenRewriteInstallBeforeRunTaskProviderKt.getINSTALL_BEFORE_RUN_TASK_KEY();
    }

    @NotNull
    public String getName() {
        String string = OpenRewriteBundle.message("open.rewrite.install.before.run.task.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public Icon getIcon() {
        return (Icon)new ScratchFileTypeIcon(OpenRewriteIcons.OpenRewrite);
    }

    @NotNull
    public Icon getTaskIcon(@NotNull OpenRewriteInstallBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        return this.getIcon();
    }

    @NotNull
    public String getDescription(@NotNull OpenRewriteInstallBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        String string = task.getScratchFileUrl();
        if (string == null || (string = StringsKt.substringAfterLast$default((String)string, (String)"/", null, (int)2, null)) == null || (string = StringsKt.substringAfterLast$default((String)string, (char)'\\', null, (int)2, null)) == null) {
            string = "";
        }
        String fileName = string;
        Object[] objectArray = new Object[]{StringsKt.substringBeforeLast$default((String)fileName, (String)".", null, (int)2, null)};
        String string2 = OpenRewriteBundle.message("open.rewrite.install.before.run.task.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    public boolean isConfigurable() {
        return true;
    }

    @NotNull
    public Promise<Boolean> configureTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull OpenRewriteInstallBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = OpenRewriteBundle.message("open.rewrite.install.before.run.task.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        OpenRewriteInstallBeforeRunTaskDialog dialog = new OpenRewriteInstallBeforeRunTaskDialog(project, string, task);
        return Promises.resolvedPromise((Object)dialog.showAndGet());
    }

    public boolean canExecuteTask(@NotNull RunConfiguration configuration, @NotNull OpenRewriteInstallBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        if (!(configuration instanceof OpenRewriteRunConfiguration)) {
            return false;
        }
        String string = task.getScratchFileUrl();
        if (string == null) {
            return false;
        }
        String scratchFileUrl = string;
        return StringsKt.endsWith$default((String)scratchFileUrl, (String)".java", (boolean)false, (int)2, null);
    }

    @Nullable
    public OpenRewriteInstallBeforeRunTask createTask(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        if (!(runConfiguration instanceof OpenRewriteRunConfiguration)) {
            return null;
        }
        return new OpenRewriteInstallBeforeRunTask();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean compile(OpenRewriteRunConfiguration configuration, ExecutionEnvironment environment, OpenRewriteInstallBeforeRunTask task) {
        ApplicationManager.getApplication().invokeAndWait(OpenRewriteInstallBeforeRunTaskProvider::compile$lambda$0);
        EmptyCompileScopeBuildTaskImpl projectTask = new EmptyCompileScopeBuildTaskImpl(true);
        ProjectTaskContext context = new ProjectTaskContext(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY.get((UserDataHolder)environment), (RunConfiguration)configuration);
        environment.copyUserDataTo((UserDataHolderBase)context);
        configuration.putUserData(OpenRewriteInstallBeforeRunTaskProviderKt.getINSTALL_BEFORE_RUN_TASK_KEY(), (Object)task);
        try {
            CompletableFuture result = new CompletableFuture();
            ProjectTaskManagerImpl.putBuildOriginator((Project)configuration.getProject(), OpenRewriteInstallBeforeRunTaskProvider.class);
            ProjectTaskManager.getInstance((Project)configuration.getProject()).run(context, (ProjectTask)projectTask).onProcessed(arg_0 -> OpenRewriteInstallBeforeRunTaskProvider.compile$lambda$1(result, arg_0));
            Object t = result.get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            boolean bl = (Boolean)t;
            return bl;
        }
        finally {
            configuration.putUserData(OpenRewriteInstallBeforeRunTaskProviderKt.getINSTALL_BEFORE_RUN_TASK_KEY(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean build(Project project, String name) {
        Comparable<File> comparable = OpenRewriteInstallBeforeRunTaskProviderKt.getScratchOutputDirectory(project);
        if (comparable == null || (comparable = ((File)comparable).toPath()) == null) {
            return false;
        }
        Comparable<File> path = comparable;
        try {
            Compressor.Jar jar = new Compressor.Jar(path.getParent().resolve(name));
            Closeable closeable = (Closeable)jar;
            Throwable throwable = null;
            try {
                Compressor.Jar it = (Compressor.Jar)closeable;
                boolean bl = false;
                jar.addDirectory(path);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return true;
        }
        catch (IOException e) {
            ApplicationManager.getApplication().invokeAndWait(() -> OpenRewriteInstallBeforeRunTaskProvider.build$lambda$3(project));
            return false;
        }
    }

    private final boolean install(RunConfiguration configuration, OpenRewriteInstallBeforeRunTask task, String name) {
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Comparable<File> comparable = OpenRewriteInstallBeforeRunTaskProviderKt.getScratchOutputDirectory(project);
        if (comparable == null || (comparable = ((File)comparable).toPath()) == null || (comparable = comparable.getParent()) == null) {
            return false;
        }
        Comparable<File> parentPath = comparable;
        Path artifactPath = parentPath.resolve(name);
        MavenCoordinates coordinates = task.getCoordinates();
        StringBuilder commandLineBuilder = new StringBuilder("install:install-file");
        Intrinsics.checkNotNull((Object)artifactPath);
        commandLineBuilder.append(" -Dfile=" + ((Object)artifactPath).toString());
        commandLineBuilder.append(" -DgroupId=" + coordinates.getGroupId());
        commandLineBuilder.append(" -DartifactId=" + coordinates.getArtifactId());
        commandLineBuilder.append(" -Dversion=" + coordinates.getVersion());
        commandLineBuilder.append(" -Dpackaging=" + coordinates.getPackaging());
        String string = commandLineBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String commandLine = string;
        for (OpenRewriteExternalSystemBridge bridge : OpenRewriteExternalSystemBridge.Companion.getEP_NAME$intellij_openRewrite().getExtensionList()) {
            Project project2 = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!bridge.installFile(project2, commandLine)) continue;
            return true;
        }
        return false;
    }

    public boolean executeTask(@NotNull DataContext context, @NotNull RunConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull OpenRewriteInstallBeforeRunTask task) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        if (!(configuration instanceof OpenRewriteRunConfiguration)) {
            return false;
        }
        try {
            Promise reload2;
            Project project = environment.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Job job = OpenRewriteRecipeService.reload$default(OpenRewriteRecipeService.Companion.getInstance(project), null, 1, null);
            Object object = reload2 = job != null ? Promises.asPromise((Job)job) : null;
            if (reload2 != null) {
                Semaphore done = new Semaphore(1);
                reload2.onProcessed(arg_0 -> OpenRewriteInstallBeforeRunTaskProvider.executeTask$lambda$4(new Function1(done){
                    final /* synthetic */ Semaphore $done;
                    {
                        this.$done = $done;
                    }

                    public final void invoke(Object it) {
                        this.$done.up();
                    }
                }, arg_0));
                done.waitFor();
            }
            if (!this.compile((OpenRewriteRunConfiguration)configuration, environment, task)) {
                return false;
            }
            MavenCoordinates coordinates = task.getCoordinates();
            String name = coordinates.getArtifactId() + "-" + coordinates.getVersion() + ".jar";
            Project project2 = ((OpenRewriteRunConfiguration)configuration).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
            if (!this.build(project2, name)) {
                return false;
            }
            return this.install(configuration, task, name);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(OpenRewriteInstallBeforeRunTaskProvider.class).error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static final void compile$lambda$0() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNull((Object)fileDocumentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl");
        ((FileDocumentManagerImpl)fileDocumentManager).saveAllDocuments(false);
    }

    private static final void compile$lambda$1(CompletableFuture $result, ProjectTaskManager.Result it) {
        $result.complete(it != null && !it.hasErrors() && !it.isAborted());
    }

    private static final void build$lambda$3(Project $project) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("OpenRewrite");
        String string = OpenRewriteBundle.message("open.rewrite.install.before.run.task.failed.to.build.artifact", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        notificationGroup.createNotification(string, NotificationType.ERROR).setDisplayId("openRewrite.install.class.recipe").setIcon(OpenRewriteIcons.OpenRewrite).notify($project);
    }

    private static final void executeTask$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

