/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run.before;

import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openRewrite.run.OpenRewriteRunConfiguration;
import com.intellij.openRewrite.run.OpenRewriteRunConfigurationTypeKt;
import com.intellij.openRewrite.run.OpenRewriteRunUtilsKt;
import com.intellij.openRewrite.run.OpenRewriteWorkingDirectoryConfigurator;
import com.intellij.openRewrite.run.before.OpenRewriteInstallBeforeRunTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openRewrite/run/before/OpenRewriteScratchClassRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/openRewrite/run/OpenRewriteRunConfiguration;", "<init>", "()V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "setupConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "intellij.openRewrite"})
@SourceDebugExtension(value={"SMAP\nOpenRewriteScratchClassRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRewriteScratchClassRunConfigurationProducer.kt\ncom/intellij/openRewrite/run/before/OpenRewriteScratchClassRunConfigurationProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,56:1\n1761#2,3:57\n*S KotlinDebug\n*F\n+ 1 OpenRewriteScratchClassRunConfigurationProducer.kt\ncom/intellij/openRewrite/run/before/OpenRewriteScratchClassRunConfigurationProducer\n*L\n54#1:57,3\n*E\n"})
public final class OpenRewriteScratchClassRunConfigurationProducer
extends LazyRunConfigurationProducer<OpenRewriteRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return OpenRewriteRunConfigurationTypeKt.openRewriteRunConfigurationType().getConfigurationFactories()[0];
    }

    protected boolean setupConfigurationFromContext(@NotNull OpenRewriteRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElement2 = psiElement;
        if (!(psiElement2 instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement psiElement3 = ((PsiIdentifier)psiElement2).getParent();
        if (psiElement3 == null) {
            return false;
        }
        PsiElement parent = psiElement3;
        if (!(parent instanceof PsiClass)) {
            return false;
        }
        PsiFile psiFile = ((PsiIdentifier)psiElement2).getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (!ScratchUtil.isScratch((VirtualFile)virtualFile2)) {
            return false;
        }
        if (!OpenRewriteRunUtilsKt.isRecipe((PsiClass)parent)) {
            return false;
        }
        String string = ((PsiClass)parent).getQualifiedName();
        if (string == null) {
            return false;
        }
        configuration.setActiveRecipes(string);
        configuration.setGeneratedName();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement2);
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        configuration.setWorkingDirectory(new OpenRewriteWorkingDirectoryConfigurator(project, module).getWorkingDirectory());
        OpenRewriteInstallBeforeRunTask task = new OpenRewriteInstallBeforeRunTask();
        task.setScratchFileUrl(FileUtil.toSystemDependentName((String)virtualFile2.getPath()));
        configuration.setBeforeRunTasks(CollectionsKt.listOf((Object)((Object)task)));
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull OpenRewriteRunConfiguration configuration, @NotNull ConfigurationContext context) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiElement psiElement = context.getPsiLocation();
            PsiElement psiElement2 = psiElement != null ? psiElement.getParent() : null;
            PsiClass psiClass = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            PsiFile psiFile = psiClass2.getContainingFile();
            if (psiFile == null || (psiFile = psiFile.getOriginalFile()) == null || (psiFile = psiFile.getVirtualFile()) == null) {
                return false;
            }
            PsiFile virtualFile = psiFile;
            String string = FileUtil.toSystemDependentName((String)virtualFile.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
            String fileUrl = string;
            List<String> activeRecipes = OpenRewriteRunUtilsKt.splitConfigurationValue(configuration.getActiveRecipes());
            if (!CollectionsKt.contains((Iterable)activeRecipes, (Object)psiClass2.getQualifiedName())) {
                return false;
            }
            List list = configuration.getBeforeRunTasks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getBeforeRunTasks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BeforeRunTask it = (BeforeRunTask)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof OpenRewriteInstallBeforeRunTask && Intrinsics.areEqual((Object)((OpenRewriteInstallBeforeRunTask)it).getScratchFileUrl(), (Object)fileUrl))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }
}

