/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.yaml;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openRewrite.OpenRewriteIcons;
import com.intellij.openRewrite.OpenRewriteUtilKt;
import com.intellij.openRewrite.recipe.OpenRewriteOptionDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteOptionPsiElement;
import com.intellij.openRewrite.recipe.OpenRewriteType;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000f"}, d2={"RECIPE_YAML_CONDITION", "Lcom/intellij/patterns/PatternCondition;", "Lcom/intellij/psi/PsiElement;", "getRECIPE_YAML_CONDITION", "()Lcom/intellij/patterns/PatternCondition;", "getKeyValueType", "Lcom/intellij/openRewrite/recipe/OpenRewriteType;", "yamlKeyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getSequenceItemType", "element", "getOptionLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "descriptor", "Lcom/intellij/openRewrite/recipe/OpenRewriteOptionDescriptor;", "intellij.openRewrite"})
public final class OpenRewriteYamlUtilsKt {
    @NotNull
    private static final PatternCondition<PsiElement> RECIPE_YAML_CONDITION = (PatternCondition)new PatternCondition<PsiElement>(){

        public boolean accepts(PsiElement element, ProcessingContext context) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return false;
            }
            PsiFile containingFile = psiFile;
            PsiFile psiFile2 = containingFile.getOriginalFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
            return OpenRewriteUtilKt.isRecipe(psiFile2);
        }
    };

    @NotNull
    public static final PatternCondition<PsiElement> getRECIPE_YAML_CONDITION() {
        return RECIPE_YAML_CONDITION;
    }

    @Nullable
    public static final OpenRewriteType getKeyValueType(@NotNull YAMLKeyValue yamlKeyValue) {
        Intrinsics.checkNotNullParameter((Object)yamlKeyValue, (String)"yamlKeyValue");
        PsiElement psiElement = yamlKeyValue.getParent();
        return OpenRewriteYamlUtilsKt.getSequenceItemType((PsiElement)(psiElement != null ? psiElement.getParent() : null));
    }

    @Nullable
    public static final OpenRewriteType getSequenceItemType(@Nullable PsiElement element) {
        PsiElement parentKeyValue;
        if (!(element instanceof YAMLSequenceItem)) {
            return null;
        }
        PsiElement psiElement = ((YAMLSequenceItem)element).getParent();
        Object object = parentKeyValue = psiElement != null ? psiElement.getParent() : null;
        if (!(parentKeyValue instanceof YAMLKeyValue)) {
            return null;
        }
        PsiElement psiElement2 = ((YAMLKeyValue)parentKeyValue).getParent();
        if (!((psiElement2 != null ? psiElement2.getParent() : null) instanceof YAMLDocument)) {
            return null;
        }
        String string = ((YAMLKeyValue)parentKeyValue).getKeyText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getKeyText(...)");
        String keyText = string;
        for (OpenRewriteType type : OpenRewriteType.getEntries()) {
            if (!Intrinsics.areEqual((Object)type.getListKey(), (Object)keyText) && !type.getAdditionalListKeys().contains(keyText)) continue;
            return type;
        }
        return null;
    }

    @NotNull
    public static final LookupElement getOptionLookupElement(@NotNull OpenRewriteOptionDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)descriptor.getName()).withIcon(OpenRewriteIcons.OpenRewrite).withPsiElement((PsiElement)new OpenRewriteOptionPsiElement(descriptor));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withPsiElement(...)");
        LookupElementBuilder builder = lookupElementBuilder;
        if (descriptor.getDisplayName() != null) {
            LookupElementBuilder lookupElementBuilder2 = builder.withLookupString(descriptor.getDisplayName()).withTypeText(descriptor.getDisplayName());
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withTypeText(...)");
            builder = lookupElementBuilder2;
        }
        TailTypeDecorator tailTypeDecorator = TailTypeDecorator.withTail((LookupElement)((LookupElement)builder), (TailType)ConfigYamlUtils.getValueTailType());
        Intrinsics.checkNotNullExpressionValue((Object)tailTypeDecorator, (String)"withTail(...)");
        return (LookupElement)tailTypeDecorator;
    }
}

