/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.dependencies;

import com.intellij.microservices.jvm.dependencies.FrameworkDependenciesModificationContextKt;
import com.intellij.microservices.jvm.dependencies.FrameworkDependency;
import com.intellij.microservices.jvm.dependencies.FrameworkDependencyCoordinates;
import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006J\u0014\u0010\u001f\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u0006J\u001a\u0010\u001d\u001a\u00020\u00152\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150!J\u001a\u0010\u001f\u001a\u00020\u00152\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150!J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010%\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0004J(\u0010&\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u0017H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/intellij/microservices/jvm/dependencies/FrameworkDependenciesModificationContext;", "", "dependencies", "", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "existingDependencies", "", "addedDependencies", "", "removedDependencies", "frameworkVersion", "Lcom/intellij/microservices/jvm/dependencies/Version;", "<init>", "(Ljava/util/Collection;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lcom/intellij/microservices/jvm/dependencies/Version;)V", "getExistingDependencies", "()Ljava/util/List;", "getAddedDependencies", "getRemovedDependencies", "getFrameworkVersion", "()Lcom/intellij/microservices/jvm/dependencies/Version;", "has", "", "id", "", "isAdded", "isRemoved", "find", "findAdded", "findRemoved", "isFirstAdded", "ids", "isLastRemoved", "condition", "Lkotlin/Function1;", "addDependency", "", "dependency", "removeDependency", "substitute", "newId", "groupId", "artifactId", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nFrameworkDependenciesModificationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameworkDependenciesModificationContext.kt\ncom/intellij/microservices/jvm/dependencies/FrameworkDependenciesModificationContext\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1#2:139\n1761#3,3:140\n2746#3,3:143\n1761#3,3:146\n2746#3,3:149\n1761#3,3:152\n2746#3,3:155\n2746#3,3:158\n2746#3,3:161\n*S KotlinDebug\n*F\n+ 1 FrameworkDependenciesModificationContext.kt\ncom/intellij/microservices/jvm/dependencies/FrameworkDependenciesModificationContext\n*L\n89#1:140,3\n89#1:143,3\n93#1:146,3\n93#1:149,3\n97#1:152,3\n97#1:155,3\n101#1:158,3\n106#1:161,3\n*E\n"})
public class FrameworkDependenciesModificationContext {
    @NotNull
    private final Collection<WebStarterDependency> dependencies;
    @NotNull
    private final List<WebStarterDependency> existingDependencies;
    @NotNull
    private final List<WebStarterDependency> addedDependencies;
    @NotNull
    private final List<WebStarterDependency> removedDependencies;
    @NotNull
    private final Version frameworkVersion;

    public FrameworkDependenciesModificationContext(@NotNull Collection<? extends WebStarterDependency> dependencies, @NotNull List<? extends WebStarterDependency> existingDependencies, @NotNull List<WebStarterDependency> addedDependencies, @NotNull List<WebStarterDependency> removedDependencies, @NotNull Version frameworkVersion) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(existingDependencies, (String)"existingDependencies");
        Intrinsics.checkNotNullParameter(addedDependencies, (String)"addedDependencies");
        Intrinsics.checkNotNullParameter(removedDependencies, (String)"removedDependencies");
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        this.dependencies = dependencies;
        this.existingDependencies = existingDependencies;
        this.addedDependencies = addedDependencies;
        this.removedDependencies = removedDependencies;
        this.frameworkVersion = frameworkVersion;
    }

    @NotNull
    public final List<WebStarterDependency> getExistingDependencies() {
        return this.existingDependencies;
    }

    @NotNull
    public final List<WebStarterDependency> getAddedDependencies() {
        return this.addedDependencies;
    }

    @NotNull
    public final List<WebStarterDependency> getRemovedDependencies() {
        return this.removedDependencies;
    }

    @NotNull
    public final Version getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public final boolean has(@NotNull String id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.existingDependencies;
            for (Object t : iterable) {
                WebStarterDependency it = (WebStarterDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        WebStarterDependency existing = v0;
        if (existing == null) {
            return this.isAdded(id);
        }
        return !this.isRemoved(id);
    }

    public final boolean isAdded(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.findAdded(id) != null;
    }

    public final boolean isRemoved(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.findRemoved(id) != null;
    }

    @Nullable
    public final WebStarterDependency find(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.dependencies;
            for (Object t : iterable) {
                WebStarterDependency it = (WebStarterDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final WebStarterDependency findAdded(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.addedDependencies;
            for (Object t : iterable) {
                WebStarterDependency it = (WebStarterDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final WebStarterDependency findRemoved(@NotNull String id) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.removedDependencies;
            for (Object t : iterable) {
                WebStarterDependency it = (WebStarterDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFirstAdded(@NotNull List<String> ids) {
        Object element$iv;
        Object it;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$any$iv = ids;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!this.isAdded((String)it));
        boolean bl = true;
        if (!bl) return false;
        if (ids.size() == 1) return true;
        Iterable $this$none$iv = this.existingDependencies;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (WebStarterDependency)element$iv;
            boolean bl2 = false;
        } while (!ids.contains(((WebStarterDependency)it).getId()));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isLastRemoved(@NotNull List<String> ids) {
        Object element$iv;
        String it;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable $this$any$iv = ids;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl = false;
        } while (!this.isRemoved(it));
        boolean bl = true;
        if (!bl) return false;
        if (ids.size() == 1) return true;
        Iterable $this$none$iv = ids;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (!this.has(it));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isFirstAdded(@NotNull Function1<? super WebStarterDependency, Boolean> condition) {
        Object element$iv;
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        Iterable $this$any$iv = this.addedDependencies;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
        } while (!((Boolean)condition.invoke(element$iv = iterator.next())).booleanValue());
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$none$iv = this.existingDependencies;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
        } while (!((Boolean)condition.invoke(element$iv = iterator.next())).booleanValue());
        return false;
    }

    public final boolean isLastRemoved(@NotNull Function1<? super WebStarterDependency, Boolean> condition) {
        boolean bl;
        block8: {
            boolean bl2;
            block7: {
                Intrinsics.checkNotNullParameter(condition, (String)"condition");
                Iterable $this$none$iv = this.removedDependencies;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        if (!((Boolean)condition.invoke(element$iv)).booleanValue()) continue;
                        bl2 = false;
                        break block7;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return false;
            }
            ArrayList remaining = new ArrayList(this.existingDependencies);
            remaining.removeAll(CollectionsKt.toSet((Iterable)this.removedDependencies));
            remaining.addAll(this.addedDependencies);
            Iterable $this$none$iv = remaining;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    if (!((Boolean)condition.invoke(element$iv)).booleanValue()) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final void addDependency(@NotNull WebStarterDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.addedDependencies.add(dependency);
        this.removedDependencies.remove(dependency);
    }

    public final void addDependency(@NotNull String id) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Iterable iterable = this.dependencies;
            for (Object t : iterable) {
                WebStarterDependency it = (WebStarterDependency)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        WebStarterDependency dependency = v0;
        if (dependency != null) {
            this.addDependency(dependency);
        }
    }

    public final void removeDependency(@NotNull WebStarterDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.addedDependencies.remove(dependency);
        this.removedDependencies.add(dependency);
    }

    public void substitute(@NotNull String id, @NotNull String newId, @NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)newId, (String)"newId");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        WebStarterDependency webStarterDependency = this.find(id);
        FrameworkDependency frameworkDependency = webStarterDependency instanceof FrameworkDependency ? (FrameworkDependency)webStarterDependency : null;
        if (frameworkDependency == null) {
            return;
        }
        FrameworkDependency dependency = frameworkDependency;
        if (!this.addedDependencies.remove(dependency)) {
            this.removedDependencies.add(dependency);
        }
        FrameworkDependencyCoordinates frameworkDependencyCoordinates = dependency.getCoordinates();
        if (frameworkDependencyCoordinates == null) {
            return;
        }
        FrameworkDependencyCoordinates coordinates = frameworkDependencyCoordinates;
        WebStarterDependency newDependency = FrameworkDependenciesModificationContextKt.createStarterDependency(newId, groupId, artifactId, coordinates.getVersion(), coordinates.getScope());
        this.addedDependencies.add(newDependency);
    }
}

