/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.microservices.mime.MimeTypeReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLanguageInjectionHostVisitor;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/microservices/jvm/inspection/UastIncorrectMimeTypeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.microservices.jvm"})
public final class UastIncorrectMimeTypeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new PsiLanguageInjectionHostVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                if (!(element instanceof PsiLanguageInjectionHost)) {
                    return;
                }
                UInjectionHost uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)element, UInjectionHost.class);
                if (uInjectionHost == null) {
                    return;
                }
                UInjectionHost expression = uInjectionHost;
                if (expression.getUastParent() instanceof UPolyadicExpression) {
                    return;
                }
                for (PsiReference reference : ((PsiLanguageInjectionHost)element).getReferences()) {
                    TextRange range;
                    if (!(reference instanceof MimeTypeReference) || ((MimeTypeReference)reference).isInjected() || ((MimeTypeReference)reference).resolve() != null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((MimeTypeReference)reference).getRangeInElement(), (String)"getRangeInElement(...)");
                    if (range.isEmpty() && range.getStartOffset() == 1 && Intrinsics.areEqual((Object)"\"\"", (Object)((PsiLanguageInjectionHost)element).getText())) {
                        String message;
                        Intrinsics.checkNotNullExpressionValue((Object)ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference), (String)"unresolvedReferenceMessage(...)");
                        this.$holder.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, TextRange.create((int)0, (int)2), new LocalQuickFix[0]);
                        continue;
                    }
                    this.$holder.registerProblem(reference);
                }
            }
        };
    }
}

