/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.starters;

import com.intellij.ide.starters.shared.StarterAppPackaging;
import com.intellij.ide.starters.shared.StarterAppType;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.microservices.jvm.starters.UnexpectedArchiveStructureException;
import com.intellij.openapi.util.Key;
import com.intellij.util.io.Decompressor;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\"\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0004\"\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0004\"\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0004\"\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0004\"\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0004\"\u001d\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0004\"\u001d\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0004\"\u001d\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0004\"\u001d\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u000e0\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0004\u00a8\u0006$"}, d2={"SERVER_NAME_KEY", "Lcom/intellij/openapi/util/Key;", "", "getSERVER_NAME_KEY", "()Lcom/intellij/openapi/util/Key;", "SERVER_GROUP_KEY", "getSERVER_GROUP_KEY", "SERVER_ARTIFACT_KEY", "getSERVER_ARTIFACT_KEY", "SERVER_VERSION_KEY", "getSERVER_VERSION_KEY", "SERVER_PACKAGE_NAME_KEY", "getSERVER_PACKAGE_NAME_KEY", "SERVER_LANGUAGES", "", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getSERVER_LANGUAGES", "SERVER_LANGUAGE_LEVEL_KEY", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getSERVER_LANGUAGE_LEVEL_KEY", "SERVER_LANGUAGE_LEVELS_KEY", "getSERVER_LANGUAGE_LEVELS_KEY", "SERVER_PROJECT_TYPES", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getSERVER_PROJECT_TYPES", "SERVER_APPLICATION_TYPES", "Lcom/intellij/ide/starters/shared/StarterAppType;", "getSERVER_APPLICATION_TYPES", "SERVER_PACKAGING_TYPES", "Lcom/intellij/ide/starters/shared/StarterAppPackaging;", "getSERVER_PACKAGING_TYPES", "unzipSubfolder", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "intellij.microservices.jvm"})
@JvmName(name="WebStarterSettings")
public final class WebStarterSettings {
    @NotNull
    private static final Key<String> SERVER_NAME_KEY;
    @NotNull
    private static final Key<String> SERVER_GROUP_KEY;
    @NotNull
    private static final Key<String> SERVER_ARTIFACT_KEY;
    @NotNull
    private static final Key<String> SERVER_VERSION_KEY;
    @NotNull
    private static final Key<String> SERVER_PACKAGE_NAME_KEY;
    @NotNull
    private static final Key<List<StarterLanguage>> SERVER_LANGUAGES;
    @NotNull
    private static final Key<StarterLanguageLevel> SERVER_LANGUAGE_LEVEL_KEY;
    @NotNull
    private static final Key<List<StarterLanguageLevel>> SERVER_LANGUAGE_LEVELS_KEY;
    @NotNull
    private static final Key<List<StarterProjectType>> SERVER_PROJECT_TYPES;
    @NotNull
    private static final Key<List<StarterAppType>> SERVER_APPLICATION_TYPES;
    @NotNull
    private static final Key<List<StarterAppPackaging>> SERVER_PACKAGING_TYPES;

    @NotNull
    public static final Key<String> getSERVER_NAME_KEY() {
        return SERVER_NAME_KEY;
    }

    @NotNull
    public static final Key<String> getSERVER_GROUP_KEY() {
        return SERVER_GROUP_KEY;
    }

    @NotNull
    public static final Key<String> getSERVER_ARTIFACT_KEY() {
        return SERVER_ARTIFACT_KEY;
    }

    @NotNull
    public static final Key<String> getSERVER_VERSION_KEY() {
        return SERVER_VERSION_KEY;
    }

    @NotNull
    public static final Key<String> getSERVER_PACKAGE_NAME_KEY() {
        return SERVER_PACKAGE_NAME_KEY;
    }

    @NotNull
    public static final Key<List<StarterLanguage>> getSERVER_LANGUAGES() {
        return SERVER_LANGUAGES;
    }

    @NotNull
    public static final Key<StarterLanguageLevel> getSERVER_LANGUAGE_LEVEL_KEY() {
        return SERVER_LANGUAGE_LEVEL_KEY;
    }

    @NotNull
    public static final Key<List<StarterLanguageLevel>> getSERVER_LANGUAGE_LEVELS_KEY() {
        return SERVER_LANGUAGE_LEVELS_KEY;
    }

    @NotNull
    public static final Key<List<StarterProjectType>> getSERVER_PROJECT_TYPES() {
        return SERVER_PROJECT_TYPES;
    }

    @NotNull
    public static final Key<List<StarterAppType>> getSERVER_APPLICATION_TYPES() {
        return SERVER_APPLICATION_TYPES;
    }

    @NotNull
    public static final Key<List<StarterAppPackaging>> getSERVER_PACKAGING_TYPES() {
        return SERVER_PACKAGING_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void unzipSubfolder(@NotNull File tempZipFile, @NotNull File contentEntryDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        Object rootFolderName = null;
        Closeable closeable = new ZipFile(tempZipFile);
        Throwable throwable = null;
        try {
            ZipFile jar = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> entries = jar.entries();
            if (!entries.hasMoreElements()) {
                throw new UnexpectedArchiveStructureException("The archive is empty");
            }
            HashSet<String> rootFolders = new HashSet<String>();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Path path = Paths.get(entry.getName(), new String[0]);
                if (path.getNameCount() <= 0) continue;
                rootFolders.add(((Object)path.normalize().getName(0)).toString());
            }
            if (rootFolders.size() != 1) {
                throw new UnexpectedArchiveStructureException("The archive should have 1 subdirectory, but has: " + CollectionsKt.joinToString$default((Iterable)rootFolders, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            }
            Object e = rootFolders.iterator().next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            rootFolderName = e;
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        new Decompressor.Zip(tempZipFile).removePrefixPath((String)rootFolderName).extract(contentEntryDir);
    }

    static {
        Key key = Key.create((String)"name");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SERVER_NAME_KEY = key;
        Key key2 = Key.create((String)"group");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SERVER_GROUP_KEY = key2;
        Key key3 = Key.create((String)"artifact");
        Intrinsics.checkNotNullExpressionValue((Object)key3, (String)"create(...)");
        SERVER_ARTIFACT_KEY = key3;
        Key key4 = Key.create((String)"version");
        Intrinsics.checkNotNullExpressionValue((Object)key4, (String)"create(...)");
        SERVER_VERSION_KEY = key4;
        Key key5 = Key.create((String)"packageName");
        Intrinsics.checkNotNullExpressionValue((Object)key5, (String)"create(...)");
        SERVER_PACKAGE_NAME_KEY = key5;
        Key key6 = Key.create((String)"languages");
        Intrinsics.checkNotNullExpressionValue((Object)key6, (String)"create(...)");
        SERVER_LANGUAGES = key6;
        Key key7 = Key.create((String)"languageLevel");
        Intrinsics.checkNotNullExpressionValue((Object)key7, (String)"create(...)");
        SERVER_LANGUAGE_LEVEL_KEY = key7;
        Key key8 = Key.create((String)"languageLevels");
        Intrinsics.checkNotNullExpressionValue((Object)key8, (String)"create(...)");
        SERVER_LANGUAGE_LEVELS_KEY = key8;
        Key key9 = Key.create((String)"projectTypes");
        Intrinsics.checkNotNullExpressionValue((Object)key9, (String)"create(...)");
        SERVER_PROJECT_TYPES = key9;
        Key key10 = Key.create((String)"appTypes");
        Intrinsics.checkNotNullExpressionValue((Object)key10, (String)"create(...)");
        SERVER_APPLICATION_TYPES = key10;
        Key key11 = Key.create((String)"packagingTypes");
        Intrinsics.checkNotNullExpressionValue((Object)key11, (String)"create(...)");
        SERVER_PACKAGING_TYPES = key11;
    }
}

