/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.associations.impl;

import com.intellij.ide.projectView.NodeSortKey;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.GroupByTypeComparator;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import icons.XpathIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.associations.FileAssociationsManager;
import org.intellij.lang.xpath.xslt.associations.impl.AddAssociationAction;
import org.intellij.lang.xpath.xslt.associations.impl.FileAssociationsManagerImpl;
import org.intellij.lang.xpath.xslt.associations.impl.TransactionalManager;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AssociationsEditor
implements Disposable {
    @NotNull
    private final StructureTreeModel<MyProjectStructure> myModel;
    private JPanel myComponent;
    private JBList<PsiFile> myList;
    private Tree myTree;
    private final AssociationsModel myListModel;
    private final TransactionalManager myManager;

    AssociationsEditor(@NotNull Project project, @Nullable TreeState oldState) {
        if (project == null) {
            AssociationsEditor.$$$reportNull$$$0(0);
        }
        this.myManager = ((FileAssociationsManagerImpl)FileAssociationsManager.getInstance(project)).getTempManager();
        this.initUI();
        this.myModel = new StructureTreeModel((AbstractTreeStructure)new MyProjectStructure(project), (Disposable)this);
        this.myModel.setComparator((Comparator)((Object)new MyGroupByTypeComparator()));
        this.myTree.setModel((TreeModel)new AsyncTreeModel(this.myModel, (Disposable)this));
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new MyNodeRenderer(this.myManager)));
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        if (!project.isDefault()) {
            SwingUtilities.invokeLater(() -> ApplicationManager.getApplication().invokeLater(() -> {
                if (oldState == null) {
                    this.expandTree();
                } else {
                    oldState.applyTo((JTree)this.myTree);
                }
            }));
        }
        this.myListModel = new AssociationsModel(this.myTree, this.myManager);
        this.myListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                AssociationsEditor.this.myTree.invalidate();
                AssociationsEditor.this.myTree.repaint();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                AssociationsEditor.this.myTree.invalidate();
                AssociationsEditor.this.myTree.repaint();
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.myList.setModel((ListModel)this.myListModel);
    }

    private void initUI() {
        this.myComponent = new JPanel(new BorderLayout());
        JBSplitter splitter = new JBSplitter("AssociationsEditor.dividerProportion", 0.3f);
        this.myComponent.add((Component)splitter, "Center");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)XPathBundle.message("border.title.project.xslt.files", new Object[0]), (boolean)false, (Insets)JBInsets.emptyInsets()).setShowLine(false));
        this.myTree = new Tree();
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(false);
        leftPanel.add((Component)new JBScrollPane((Component)this.myTree), "Center");
        splitter.setFirstComponent((JComponent)leftPanel);
        this.myList = new JBList();
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        this.myList.setMinimumSize(new Dimension(120, 200));
        this.myList.getEmptyText().setText(XPathBundle.message("status.text.no.associated.files", new Object[0]));
        JPanel rightPanel = ToolbarDecorator.createDecorator(this.myList).addExtraAction((AnAction)new AddAssociationActionWrapper()).addExtraAction((AnAction)new RemoveAssociationAction()).disableUpDownActions().disableAddAction().disableRemoveAction().createPanel();
        IdeaTitledBorder border = IdeBorderFactory.createTitledBorder((String)XPathBundle.message("border.title.associated.files", new Object[0]), (boolean)false, (Insets)JBInsets.emptyInsets());
        UIUtil.addBorder((JComponent)rightPanel, (Border)border.setShowLine(false));
        splitter.setSecondComponent((JComponent)rightPanel);
    }

    private void expandTree() {
        TreeNode rootNode = this.myModel.getRoot();
        if (rootNode == null) {
            return;
        }
        MyProjectStructure treeStructure = (MyProjectStructure)this.myModel.getTreeStructure();
        Object element = treeStructure.getRootElement();
        this.myModel.expand(element, (JTree)this.myTree, path -> {});
        for (Object childElement : treeStructure.getChildElements(element)) {
            this.myModel.expand(childElement, (JTree)this.myTree, path -> {});
        }
        this.myTree.setSelectionPath(new TreePath(rootNode));
        this.myTree.scrollRectToVisible(new Rectangle(new Point(0, 0)));
    }

    public TreeState getState() {
        return TreeState.createOn((JTree)this.myTree);
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            AssociationsEditor.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Nullable
    static Object getTreeSelection(JTree tree) {
        TreePath[] selectionPath = tree.getSelectionPaths();
        if (selectionPath == null || selectionPath.length != 1) {
            return null;
        }
        Object component = selectionPath[0].getLastPathComponent();
        return AssociationsEditor.getObject(component);
    }

    @Nullable
    private static Object getObject(Object component) {
        if (!(component instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
        Object userObject = node.getUserObject();
        if (!(userObject instanceof ProjectViewNode)) {
            return null;
        }
        return ((ProjectViewNode)userObject).getValue();
    }

    public boolean isModified() {
        return this.myManager.isModified();
    }

    public void apply() {
        this.myManager.applyChanges();
    }

    public void reset() {
        this.myManager.reset();
        Object selection = AssociationsEditor.getTreeSelection((JTree)this.myTree);
        this.myListModel.update(selection instanceof PsiFile ? (PsiFile)selection : null);
    }

    public void dispose() {
        this.myManager.dispose();
    }

    public void select(@NotNull PsiFile file) {
        if (file == null) {
            AssociationsEditor.$$$reportNull$$$0(2);
        }
        this.myModel.select((Object)file, (JTree)this.myTree, path -> {});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static final class MyProjectStructure
    extends AbstractProjectTreeStructure {
        public MyProjectStructure(@NotNull Project project) {
            if (project == null) {
                MyProjectStructure.$$$reportNull$$$0(0);
            }
            super(project);
        }

        public List getProviders() {
            return Collections.EMPTY_LIST;
        }

        @NotNull
        public Object[] getChildElements(@NotNull Object obj) {
            if (obj == null) {
                MyProjectStructure.$$$reportNull$$$0(1);
            }
            Object[] childElements = super.getChildElements(obj);
            ArrayList<Object> l = new ArrayList<Object>(childElements.length);
            for (Object o : childElements) {
                if (!(o instanceof ProjectViewNode)) continue;
                ProjectViewNode node = (ProjectViewNode)o;
                Object element = node.getValue();
                if (element instanceof PsiFile) {
                    if (!XsltSupport.isXsltFile((PsiFile)element)) continue;
                    l.add(o);
                    continue;
                }
                l.add(o);
            }
            Object[] objectArray = l.size() != childElements.length ? l.toArray(new Object[l.size()]) : childElements;
            if (objectArray == null) {
                MyProjectStructure.$$$reportNull$$$0(2);
            }
            return objectArray;
        }

        public boolean isFlattenPackages() {
            return true;
        }

        public boolean isHideEmptyMiddlePackages() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "obj";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$MyProjectStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$MyProjectStructure";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChildElements";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class MyGroupByTypeComparator
    extends GroupByTypeComparator {
        MyGroupByTypeComparator() {
            super(true);
        }

        @NotNull
        protected NodeSortKey getSortKey() {
            NodeSortKey nodeSortKey = NodeSortKey.BY_NAME;
            if (nodeSortKey == null) {
                MyGroupByTypeComparator.$$$reportNull$$$0(0);
            }
            return nodeSortKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$MyGroupByTypeComparator", "getSortKey"));
        }
    }

    private static final class MyNodeRenderer
    extends NodeRenderer {
        private final DefaultMutableTreeNode myTemp = new DefaultMutableTreeNode();
        private final FileAssociationsManager myManager;

        MyNodeRenderer(FileAssociationsManager manager) {
            this.myManager = manager;
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object object;
            if (tree == null) {
                MyNodeRenderer.$$$reportNull$$$0(0);
            }
            if ((object = AssociationsEditor.getObject(value)) instanceof PsiFile) {
                PsiFile file = (PsiFile)object;
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (this.myManager.getAssociationsFor(file).length > 0) {
                    this.myTemp.setUserObject((Object)new MyNodeDescriptor((NodeDescriptor<PsiFileNode>)((NodeDescriptor)userObject)));
                    super.customizeCellRenderer(tree, (Object)this.myTemp, selected, expanded, leaf, row, hasFocus);
                    return;
                }
            }
            super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$MyNodeRenderer", "customizeCellRenderer"));
        }

        private static final class MyNodeDescriptor
        extends NodeDescriptor<PsiFileNode> {
            private final PsiFileNode myNode;

            MyNodeDescriptor(NodeDescriptor<PsiFileNode> nodeDescriptor) {
                super(nodeDescriptor.getProject(), null);
                this.myName = nodeDescriptor.toString();
                this.setIcon(LayeredIcon.create((Icon)nodeDescriptor.getIcon(), (Icon)XpathIcons.Association_small));
                this.myColor = nodeDescriptor.getColor();
                this.myNode = (PsiFileNode)nodeDescriptor.getElement();
            }

            public boolean update() {
                return false;
            }

            public PsiFileNode getElement() {
                return this.myNode;
            }
        }
    }

    static final class AssociationsModel
    extends AbstractListModel<PsiFile>
    implements TreeSelectionListener {
        private final Tree myTree;
        private final FileAssociationsManager myManager;
        private PsiFile[] myFiles;

        AssociationsModel(Tree tree, FileAssociationsManager manager) {
            this.myTree = tree;
            this.myManager = manager;
            this.myFiles = PsiFile.EMPTY_ARRAY;
            this.myTree.addTreeSelectionListener((TreeSelectionListener)this);
        }

        @Override
        public int getSize() {
            return this.myFiles.length;
        }

        @Override
        public PsiFile getElementAt(int index) {
            return this.myFiles[index];
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            Object selection = AssociationsEditor.getTreeSelection((JTree)this.myTree);
            if (selection instanceof PsiFile) {
                this.update((PsiFile)selection);
            } else {
                this.update(null);
            }
        }

        public void update(@Nullable PsiFile selection) {
            int oldSize = this.myFiles.length;
            this.myFiles = PsiFile.EMPTY_ARRAY;
            if (this.myFiles.length != oldSize) {
                this.fireIntervalRemoved(this, 0, oldSize - 1);
            }
            if (selection != null) {
                this.myFiles = this.myManager.getAssociationsFor(selection);
                if (this.myFiles.length > 0) {
                    this.fireIntervalAdded(this, 0, this.myFiles.length - 1);
                }
            }
        }
    }

    private static final class MyCellRenderer
    extends PsiElementListCellRenderer<PsiFile> {
        private MyCellRenderer() {
        }

        public String getElementText(PsiFile file) {
            return file.getName();
        }

        protected String getContainerText(PsiFile psiElement, String string) {
            return "(" + psiElement.getVirtualFile().getParent().getPresentableUrl() + ")";
        }
    }

    class AddAssociationActionWrapper
    extends AddAssociationAction {
        AddAssociationActionWrapper() {
            super(AssociationsEditor.this.myManager);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAssociationActionWrapper.$$$reportNull$$$0(0);
            }
            PsiFile selection = (PsiFile)AssociationsEditor.getTreeSelection((JTree)AssociationsEditor.this.myTree);
            this.addAssociation(selection);
            AssociationsEditor.this.myListModel.update(selection);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AddAssociationActionWrapper.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(AssociationsEditor.getTreeSelection((JTree)AssociationsEditor.this.myTree) instanceof PsiFile);
        }

        @Override
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                AddAssociationActionWrapper.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$AddAssociationActionWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$AddAssociationActionWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    class RemoveAssociationAction
    extends AnAction {
        RemoveAssociationAction() {
            super(XPathBundle.message("action.remove.association.text", new Object[0]), XPathBundle.message("action.remove.association.description", new Object[0]), IconUtil.getRemoveIcon());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAssociationAction.$$$reportNull$$$0(0);
            }
            PsiFile selection = (PsiFile)AssociationsEditor.getTreeSelection((JTree)AssociationsEditor.this.myTree);
            PsiFile listSelection = (PsiFile)this.getListSelection();
            AssociationsEditor.this.myManager.removeAssociation(selection, listSelection);
            AssociationsEditor.this.myListModel.update(selection);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RemoveAssociationAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(this.getListSelection() instanceof PsiFile);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RemoveAssociationAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private Object getListSelection() {
            return AssociationsEditor.this.myList.getSelectedValue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$RemoveAssociationAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/xpath/xslt/associations/impl/AssociationsEditor$RemoveAssociationAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

