/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.provider.http;

import com.intellij.ide.presentation.Presentation;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.MnHttpModel;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.provider.http.MnHttpUrlTargetInfo;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.url.HttpUrlResolver;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.java.ultimate.icons.JavaUltimateIcons.Web.RequestMapping", typeName="Micronaut HTTP")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpUrlResolver;", "Lcom/intellij/microservices/url/HttpUrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "Factory", "intellij.micronaut"})
public final class MnHttpUrlResolver
extends HttpUrlResolver {
    @NotNull
    private final Project myProject;

    public MnHttpUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request.getPath()), arg_0 -> MnHttpUrlResolver.resolve$lambda$1(this, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        Sequence<MnHttpMappingInfo> sequence = MnHttpModel.getHttpMethodMappings(this.myProject);
        Intrinsics.checkNotNullExpressionValue(sequence, (String)"getHttpMethodMappings(...)");
        return SequencesKt.asIterable((Sequence)SequencesKt.map(sequence, arg_0 -> MnHttpUrlResolver.getVariants$lambda$2(this, arg_0)));
    }

    private static final MnHttpUrlTargetInfo resolve$lambda$1$lambda$0(MnHttpUrlResolver this$0, MnHttpMappingInfo resolved) {
        Intrinsics.checkNotNull((Object)resolved);
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnHttpUtils.getHttpResourcePath(resolved));
        return new MnHttpUrlTargetInfo(this$0.getSupportedSchemes(), urlPath, resolved, null, 8, null);
    }

    private static final Sequence resolve$lambda$1(MnHttpUrlResolver this$0, UrlPath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Sequence<MnHttpMappingInfo> sequence = MnHttpModel.resolveUrl(this$0.myProject, path);
        Intrinsics.checkNotNullExpressionValue(sequence, (String)"resolveUrl(...)");
        return SequencesKt.map(sequence, arg_0 -> MnHttpUrlResolver.resolve$lambda$1$lambda$0(this$0, arg_0));
    }

    private static final MnHttpUrlTargetInfo getVariants$lambda$2(MnHttpUrlResolver this$0, MnHttpMappingInfo mapping) {
        Intrinsics.checkNotNull((Object)mapping);
        UrlPath urlPath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnHttpUtils.getHttpResourcePath(mapping));
        return new MnHttpUrlTargetInfo(this$0.getSupportedSchemes(), urlPath, mapping, null, 8, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/micronaut/provider/http/MnHttpUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.micronaut"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!MnHttpUtils.hasHttpClientLibrary(project) && !MnHttpUtils.hasHttpServerLibrary(project)) {
                return null;
            }
            return (UrlResolver)new MnHttpUrlResolver(project);
        }
    }
}

