/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentExtKt;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.micronaut.MicronautUtils;
import com.intellij.micronaut.config.MnConfigValueSearcher;
import com.intellij.micronaut.run.MnRunConfiguration;
import com.intellij.micronaut.run.MnRunConfigurationService;
import com.intellij.micronaut.run.MnServerConfiguration;
import com.intellij.microservices.http.request.NavigatorHttpRequest;
import com.intellij.microservices.jvm.util.PortBindingNotificationPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.task.RunConfigurationTaskState;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J0\u0010 \u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020\u0012H\u0003J\u001a\u0010(\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0019H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0019H\u0003J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00190-2\u0006\u0010)\u001a\u00020\bH\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010\u00192\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/micronaut/run/MnRunConfigurationTaskState;", "Lcom/intellij/task/RunConfigurationTaskState;", "configuration", "Lcom/intellij/micronaut/run/MnRunConfiguration;", "delegate", "", "javaParameters", "Ljava/util/function/Supplier;", "Lcom/intellij/execution/configurations/JavaParameters;", "<init>", "(Lcom/intellij/micronaut/run/MnRunConfiguration;ZLjava/util/function/Supplier;)V", "serverConfigurationPrepared", "Ljava/util/concurrent/atomic/AtomicBoolean;", "serverConfiguration", "Lcom/intellij/micronaut/run/MnServerConfiguration;", "resolvedEnvironment", "Lcom/intellij/execution/target/TargetEnvironment;", "prepareAfterTarget", "", "prepareTargetEnvironmentRequest", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "targetProgressIndicator", "Lcom/intellij/execution/target/TargetProgressIndicator;", "handleCreatedTargetEnvironment", "", "environment", "processExecutionResult", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "console", "Lcom/intellij/execution/ui/ExecutionConsole;", "addPortBindingPanel", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "processHandler", "applicationUrl", "applicationPort", "", "resolvedPort", "detectServerHttpPort", "findPropertyValue", "javaParams", "propertyKey", "findPropertyValueInConfigs", "getActiveEnvironments", "", "findPropertyValueInConfigUnderWithReadAction", "intellij.micronaut"})
public final class MnRunConfigurationTaskState
implements RunConfigurationTaskState {
    @NotNull
    private final MnRunConfiguration configuration;
    private final boolean delegate;
    @NotNull
    private final Supplier<JavaParameters> javaParameters;
    @NotNull
    private final AtomicBoolean serverConfigurationPrepared;
    @Nullable
    private volatile MnServerConfiguration serverConfiguration;
    @Nullable
    private TargetEnvironment resolvedEnvironment;

    public MnRunConfigurationTaskState(@NotNull MnRunConfiguration configuration, boolean delegate, @NotNull Supplier<JavaParameters> javaParameters) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter(javaParameters, (String)"javaParameters");
        this.configuration = configuration;
        this.delegate = delegate;
        this.javaParameters = javaParameters;
        this.serverConfigurationPrepared = new AtomicBoolean(false);
    }

    public final void prepareAfterTarget() {
        this.detectServerHttpPort();
    }

    public void prepareTargetEnvironmentRequest(@NotNull TargetEnvironmentRequest request, @NotNull TargetProgressIndicator targetProgressIndicator) throws ExecutionException {
        Integer serverPort;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        this.detectServerHttpPort();
        MnServerConfiguration mnServerConfiguration = this.serverConfiguration;
        Integer n = serverPort = mnServerConfiguration != null ? Integer.valueOf(mnServerConfiguration.getServerPort()) : null;
        if (serverPort != null && !(request instanceof LocalTargetEnvironmentRequest)) {
            request.getTargetPortBindings().add(new TargetEnvironment.TargetPortBinding(null, serverPort.intValue()));
        }
    }

    @Nullable
    public String handleCreatedTargetEnvironment(@NotNull TargetEnvironment environment, @NotNull TargetProgressIndicator targetProgressIndicator) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        this.resolvedEnvironment = environment;
        return null;
    }

    public void processExecutionResult(@NotNull ProcessHandler handler, @NotNull ExecutionConsole console) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        MnServerConfiguration mnServerConfiguration = this.serverConfiguration;
        if (mnServerConfiguration == null) {
            return;
        }
        int serverPort = mnServerConfiguration.getServerPort();
        TargetEnvironment targetEnvironment = this.resolvedEnvironment;
        int localPortForServer = targetEnvironment != null && (targetEnvironment = TargetEnvironmentExtKt.findTargetPortBinding((TargetEnvironment)targetEnvironment, (int)serverPort)) != null ? ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)targetEnvironment) : serverPort;
        MnServerConfiguration mnServerConfiguration2 = this.serverConfiguration;
        Intrinsics.checkNotNull((Object)mnServerConfiguration2);
        MnServerConfiguration resolvedConfiguration = new MnServerConfiguration(localPortForServer, mnServerConfiguration2.getSslEnabled());
        handler.putUserData(MnRunConfigurationService.Companion.getSERVER_CONFIGURATION_KEY$intellij_micronaut(), (Object)resolvedConfiguration);
        if (localPortForServer != serverPort && console instanceof ConsoleViewImpl) {
            this.addPortBindingPanel((ConsoleViewImpl)console, handler, resolvedConfiguration.getApplicationUrl(), serverPort, localPortForServer);
        }
        RunDashboardManager.getInstance((Project)this.configuration.getProject()).updateDashboard(false);
    }

    private final void addPortBindingPanel(ConsoleViewImpl console, ProcessHandler processHandler, String applicationUrl, int applicationPort, int resolvedPort) {
        ApplicationManager.getApplication().invokeLater(() -> MnRunConfigurationTaskState.addPortBindingPanel$lambda$0(applicationUrl, this, applicationPort, resolvedPort, processHandler, console), arg_0 -> MnRunConfigurationTaskState.addPortBindingPanel$lambda$1(console, arg_0));
    }

    @RequiresBackgroundThread
    private final void detectServerHttpPort() {
        int n;
        if (!this.serverConfigurationPrepared.compareAndSet(false, true)) {
            return;
        }
        Boolean hasMicronautHttpServer = (Boolean)ReadAction.compute(() -> MnRunConfigurationTaskState.detectServerHttpPort$lambda$2(this));
        if (!hasMicronautHttpServer.booleanValue()) {
            return;
        }
        JavaParameters javaParameters = this.javaParameters.get();
        Intrinsics.checkNotNullExpressionValue((Object)javaParameters, (String)"get(...)");
        JavaParameters javaParams = javaParameters;
        String string = this.findPropertyValue(javaParams, "micronaut.server.ssl.enabled");
        boolean sslEnabled = string != null ? Boolean.parseBoolean(string) : false;
        String string2 = this.findPropertyValue(javaParams, "micronaut.ssl.enabled");
        boolean deprecatedSslEnabled = string2 != null ? Boolean.parseBoolean(string2) : false;
        String portProperty = null;
        int defaultPort = 0;
        if (sslEnabled) {
            portProperty = "micronaut.server.ssl.port";
            defaultPort = 8443;
        } else if (deprecatedSslEnabled) {
            portProperty = "micronaut.ssl.port";
            defaultPort = 8443;
        } else {
            portProperty = "micronaut.server.port";
            defaultPort = 8080;
        }
        try {
            String string3 = this.findPropertyValue(javaParams, portProperty);
            n = string3 != null ? Integer.parseInt(string3) : defaultPort;
        }
        catch (NumberFormatException e) {
            n = defaultPort;
        }
        int serverPort = n;
        this.serverConfiguration = new MnServerConfiguration(serverPort, sslEnabled || deprecatedSslEnabled);
    }

    private final String findPropertyValue(JavaParameters javaParams, String propertyKey) {
        String fromVmOptions = javaParams.getVMParametersList().getPropertyValue(propertyKey);
        CharSequence charSequence = fromVmOptions;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            return fromVmOptions;
        }
        Project project = this.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            try {
                Project project2 = this.configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                charSequence = (String)DumbService.Companion.getInstance(project2).computeWithAlternativeResolveEnabled(() -> MnRunConfigurationTaskState.findPropertyValue$lambda$3(this, javaParams, propertyKey));
            }
            catch (IndexNotReadyException e) {
                charSequence = null;
            }
            return charSequence;
        }
        return this.findPropertyValueInConfigUnderWithReadAction(javaParams, propertyKey);
    }

    @RequiresReadLock
    private final String findPropertyValueInConfigs(JavaParameters javaParams, String propertyKey) {
        Set<String> environments = this.getActiveEnvironments(javaParams);
        Module module = ((JavaRunConfigurationModule)this.configuration.getConfigurationModule()).getModule();
        if (module == null) {
            return null;
        }
        Module module2 = module;
        MnConfigValueSearcher searcher = new MnConfigValueSearcher(module2, false, propertyKey, true, environments, 0, 32, null);
        String value = searcher.findValueText();
        CharSequence charSequence = value;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : value;
    }

    private final Set<String> getActiveEnvironments(JavaParameters javaParams) {
        char[] cArray;
        Object object = javaParams.getVMParametersList().getPropertyValue("micronaut.environments");
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (char[])(cArray = new char[]{','}), (boolean)false, (int)0, (int)6, null)) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    private final String findPropertyValueInConfigUnderWithReadAction(JavaParameters javaParams, String propertyKey) {
        return (String)ReadAction.compute(() -> MnRunConfigurationTaskState.findPropertyValueInConfigUnderWithReadAction$lambda$4(this, javaParams, propertyKey));
    }

    private static final void addPortBindingPanel$lambda$0(String $applicationUrl, MnRunConfigurationTaskState this$0, int $applicationPort, int $resolvedPort, ProcessHandler $processHandler, ConsoleViewImpl $console) {
        NavigatorHttpRequest request = new NavigatorHttpRequest($applicationUrl, "GET", CollectionsKt.emptyList(), CollectionsKt.emptyList());
        Project project = this$0.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = this$0.configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        PortBindingNotificationPanel panel = new PortBindingNotificationPanel(project, request, string, $applicationPort, $resolvedPort);
        panel.registerProcessListener($processHandler, (Disposable)$console);
        JPanel jPanel = ServiceViewUIUtils.getServicesAlignedPanelWrapper((JComponent)((JComponent)panel));
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getServicesAlignedPanelWrapper(...)");
        JPanel wrapper = jPanel;
        if (this$0.delegate) {
            wrapper.setBorder(IdeBorderFactory.createBorder((int)12));
        } else {
            wrapper.setBorder(IdeBorderFactory.createBorder((int)8));
        }
        $console.addNotificationComponent((JComponent)wrapper);
    }

    private static final boolean addPortBindingPanel$lambda$1(ConsoleViewImpl $console, Object it) {
        return Disposer.isDisposed((Disposable)((Disposable)$console));
    }

    private static final Boolean detectServerHttpPort$lambda$2(MnRunConfigurationTaskState this$0) {
        return MicronautUtils.hasMicronautHttpServerJar(((JavaRunConfigurationModule)this$0.configuration.getConfigurationModule()).getModule());
    }

    private static final String findPropertyValue$lambda$3(MnRunConfigurationTaskState this$0, JavaParameters $javaParams, String $propertyKey) {
        return this$0.findPropertyValueInConfigUnderWithReadAction($javaParams, $propertyKey);
    }

    private static final String findPropertyValueInConfigUnderWithReadAction$lambda$4(MnRunConfigurationTaskState this$0, JavaParameters $javaParams, String $propertyKey) {
        return this$0.findPropertyValueInConfigs($javaParams, $propertyKey);
    }
}

