/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.rename;

import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSComponentCustomUsageSearcherKt;
import com.intellij.lang.javascript.hints.JSComponentUsageProvider;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.JSRefactoringSettings;
import com.intellij.lang.javascript.refactoring.rename.JSComponentRenamePsiElementProcessor;
import com.intellij.lang.javascript.refactoring.rename.JSComponentRenamePsiElementProcessorKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.BindablePsiReference;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenamePsiFileProcessor;
import com.intellij.refactoring.rename.RenameUsagesCollector;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J(\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0006\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J4\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u001b0\u001d2\u0006\u0010\u001e\u001a\u00020\u0013H\u0016J5\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0012\u0010'\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J \u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J#\u0010,\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010+\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010-J\u001a\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u00072\b\u00100\u001a\u0004\u0018\u00010\u001bH\u0002J$\u00101\u001a\u0004\u0018\u00010\u001b2\u0006\u0010/\u001a\u00020\u00072\b\u00100\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u001b2\u0006\u0010/\u001a\u00020\u0007H\u0002J\u001e\u00103\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u00162\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J$\u00104\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u00105\u001a\u00020\u0005H\u0002J(\u00106\u001a\n\u0018\u000107j\u0004\u0018\u0001`82\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00109\u001a\u00020$H\u0016\u00a8\u0006;"}, d2={"Lcom/intellij/lang/javascript/refactoring/rename/JSComponentRenamePsiElementProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiFileProcessor;", "<init>", "()V", "canProcessElement", "", "element", "Lcom/intellij/psi/PsiElement;", "createRenameDialog", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "findNonReachableReferences", "Lcom/intellij/psi/PsiFile;", "prepareRenaming", "", "file", "newName", "", "allRenames", "", "scope", "renameElement", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "isDirectImportUsage", "isNamedElementToRename", "adjustElementToRename", "renameReference", "reference", "namedElement", "reportRenamedUsages", "([Lcom/intellij/usageView/UsageInfo;Lcom/intellij/psi/PsiElement;)V", "nameConformsToComponentName", "elementToRename", "oldName", "adjustElementName", "getComponentNameToMatch", "fileToComponentName", "generateDefaultComponentName", "allowModal", "getPostRenameCallback", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "elementListener", "JSComponentRenameDialog", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSComponentRenamePsiElementProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSComponentRenamePsiElementProcessor.kt\ncom/intellij/lang/javascript/refactoring/rename/JSComponentRenamePsiElementProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n1869#2,2:324\n774#2:326\n865#2,2:327\n1761#2,3:329\n1#3:332\n*S KotlinDebug\n*F\n+ 1 JSComponentRenamePsiElementProcessor.kt\ncom/intellij/lang/javascript/refactoring/rename/JSComponentRenamePsiElementProcessor\n*L\n88#1:324,2\n94#1:326\n94#1:327,2\n165#1:329,3\n*E\n"})
public final class JSComponentRenamePsiElementProcessor
extends RenamePsiFileProcessor {
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return super.canProcessElement(element2) && element2 instanceof PsiFile && JSComponentUsageProvider.Companion.isComponent((PsiFile)element2);
    }

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element2, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return (RenameDialog)new JSComponentRenameDialog(project, element2, nameSuggestionContext, editor);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        List list;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        if (!(element2 instanceof PsiFile) || !JSRefactoringSettings.getInstance().RENAME_SEARCH_FOR_COMPONENT_USAGES) {
            Collection collection = super.findReferences(element2, searchScope, searchInCommentsAndStrings);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findReferences(...)");
            return collection;
        }
        List $this$findReferences_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Collection collection = super.findReferences(element2, searchScope, searchInCommentsAndStrings);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findReferences(...)");
        $this$findReferences_u24lambda_u240.addAll(collection);
        $this$findReferences_u24lambda_u240.addAll(this.findNonReachableReferences((PsiFile)element2, searchScope));
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<PsiReference> findNonReachableReferences(PsiFile element2, SearchScope searchScope) {
        void $this$filterTo$iv$iv;
        PsiReference it;
        Iterable referenceElement;
        ArrayList result2 = new ArrayList();
        JSComponentCustomUsageSearcherKt.processComponentReferences(element2, searchScope, (Processor<? super PsiReference>)((Processor)arg_0 -> JSComponentRenamePsiElementProcessor.findNonReachableReferences$lambda$2(arg_0 -> JSComponentRenamePsiElementProcessor.findNonReachableReferences$lambda$1(result2, arg_0), arg_0)));
        HashSet elementsToSkip = new HashSet();
        Iterator iterator = result2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            PsiReference reference = (PsiReference)e;
            Intrinsics.checkNotNullExpressionValue((Object)reference.getElement(), (String)"getElement(...)");
            if (!this.isNamedElementToRename((PsiElement)referenceElement)) continue;
            elementsToSkip.add(referenceElement);
            Iterable $this$forEach$iv = ReferencesSearch.search((PsiElement)this.adjustElementToRename((PsiElement)referenceElement), (SearchScope)searchScope).asIterable();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PsiReference)element$iv;
                boolean bl = false;
                elementsToSkip.add(it.getElement());
            }
        }
        Iterable $this$filter$iv = result2;
        boolean $i$f$filter = false;
        referenceElement = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (PsiReference)element$iv$iv;
            boolean bl = false;
            if (!(!elementsToSkip.contains(it.getElement()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public void prepareRenaming(@NotNull PsiElement file, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (!(file instanceof PsiFile) || !JSRefactoringSettings.getInstance().RENAME_SEARCH_FOR_COMPONENT_USAGES) {
            super.prepareRenaming(file, newName, allRenames, scope2);
            return;
        }
        ArrayList<PsiElement> additionalElements = new ArrayList<PsiElement>();
        Project project = ((PsiFile)file).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = JavaScriptBundle.message("js.searching.for.component.usages", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, scope2, this, additionalElements, null){
            int label;
            final /* synthetic */ PsiElement $file;
            final /* synthetic */ SearchScope $scope;
            final /* synthetic */ JSComponentRenamePsiElementProcessor this$0;
            final /* synthetic */ ArrayList<PsiElement> $additionalElements;
            {
                this.$file = $file;
                this.$scope = $scope;
                this.this$0 = $receiver;
                this.$additionalElements = $additionalElements;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        JSComponentCustomUsageSearcherKt.processComponentReferences((PsiFile)this.$file, this.$scope, (Processor<? super PsiReference>)((Processor)arg_0 -> prepareRenaming.1.invokeSuspend$lambda$1(arg_0 -> prepareRenaming.1.invokeSuspend$lambda$0(this.this$0, this.$additionalElements, arg_0), arg_0)));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(JSComponentRenamePsiElementProcessor this$0, ArrayList $additionalElements, PsiReference it) {
                PsiElement psiElement = it.getElement();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
                PsiElement element2 = psiElement;
                if (JSComponentRenamePsiElementProcessor.access$isNamedElementToRename(this$0, element2)) {
                    $additionalElements.add(element2);
                }
                return true;
            }

            private static final boolean invokeSuspend$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        }));
        String oldName = JSComponentRenamePsiElementProcessor.fileToComponentName$default(this, (PsiFile)file, null, 2, null);
        String string2 = this.generateDefaultComponentName((PsiFile)file, newName, true);
        if (string2 == null) {
            return;
        }
        String newDefaultName = string2;
        Iterator<PsiElement> iterator = additionalElements.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<PsiElement> iterator2 = iterator;
        while (iterator2.hasNext()) {
            String adjustedName;
            PsiElement element2;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            PsiElement adjustedElement = this.adjustElementToRename(element2);
            if (!this.nameConformsToComponentName(adjustedElement, oldName) && !this.isDirectImportUsage((PsiFile)file, element2) || this.adjustElementName(adjustedElement, oldName, newDefaultName) == null) continue;
            allRenames.put(adjustedElement, adjustedName);
        }
    }

    public void renameElement(@NotNull PsiElement file, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
            if (!(file instanceof PsiFile) || !JSRefactoringSettings.getInstance().RENAME_SEARCH_FOR_COMPONENT_USAGES) {
                super.renameElement(file, newName, usages, listener2);
                return;
            }
            this.reportRenamedUsages(usages, file);
            String oldName = JSComponentRenamePsiElementProcessor.fileToComponentName$default(this, (PsiFile)file, null, 2, null);
            String string = JSComponentRenamePsiElementProcessor.generateDefaultComponentName$default(this, (PsiFile)file, newName, false, 4, null);
            if (string == null) {
                return;
            }
            String newDefaultName = string;
            ((PsiFile)file).setName(newName);
            for (UsageInfo usage : usages) {
                String adjustedName;
                PsiElement element2;
                PsiReference reference;
                if (usage.getReference() == null) continue;
                if (reference instanceof PsiFileReference) {
                    this.renameReference(reference, (PsiFile)file, newName);
                    continue;
                }
                if (usage.getElement() == null || this.isNamedElementToRename(element2) || this.adjustElementName(element2, oldName, newDefaultName) == null) continue;
                this.renameReference(reference, (PsiFile)file, adjustedName);
            }
            RefactoringElementListener refactoringElementListener = listener2;
            if (refactoringElementListener == null) break block4;
            refactoringElementListener.elementRenamed(file);
        }
    }

    private final boolean isDirectImportUsage(PsiFile file, PsiElement element2) {
        boolean bl;
        block6: {
            if (!(element2 instanceof ES6ImportExportDeclarationPart)) {
                return false;
            }
            ES6ImportExportDeclaration eS6ImportExportDeclaration = ((ES6ImportExportDeclarationPart)element2).getDeclaration();
            if (eS6ImportExportDeclaration == null) {
                return false;
            }
            ES6ImportExportDeclaration declaration = eS6ImportExportDeclaration;
            Object object = declaration.getFromClause();
            if (object == null || (object = object.resolveReferencedElements()) == null) {
                return false;
            }
            Object resolved = object;
            Iterable $this$any$iv = (Iterable)resolved;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getContainingFile(), (Object)file)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isNamedElementToRename(PsiElement element2) {
        return element2 instanceof JSElement && element2 instanceof PsiNamedElement;
    }

    private final PsiElement adjustElementToRename(PsiElement element2) {
        PsiElement psiElement;
        if (element2 instanceof ES6ImportExportSpecifier) {
            ES6ImportExportSpecifierAlias eS6ImportExportSpecifierAlias = ((ES6ImportExportSpecifier)element2).getAlias();
            psiElement = (PsiElement)(eS6ImportExportSpecifierAlias != null ? (JSPsiNamedElementBase)eS6ImportExportSpecifierAlias : (JSPsiNamedElementBase)element2);
        } else {
            psiElement = element2;
        }
        return psiElement;
    }

    private final void renameReference(PsiReference reference, PsiFile namedElement, String newName) {
        boolean fallback = true;
        if (reference instanceof BindablePsiReference) {
            try {
                reference.bindToElement((PsiElement)namedElement);
                fallback = false;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (fallback) {
            reference.handleElementRename(newName);
        }
    }

    private final void reportRenamedUsages(UsageInfo[] usages, PsiElement namedElement) {
        HashSet reportedClasses = new HashSet();
        for (UsageInfo usage : usages) {
            PsiReference reference = usage.getReference();
            if (reference == null || !reportedClasses.add(reference.getClass())) continue;
            RenameUsagesCollector.referenceProcessed.log(namedElement.getProject(), reference.getClass());
        }
    }

    private final boolean nameConformsToComponentName(PsiElement elementToRename, String oldName) {
        if (oldName == null) {
            return true;
        }
        String string = this.getComponentNameToMatch(elementToRename);
        if (string == null) {
            return true;
        }
        String currentName = string;
        if (StringUtil.equalsIgnoreCase((CharSequence)currentName, (CharSequence)oldName)) {
            return true;
        }
        return StringsKt.contains$default((CharSequence)currentName, (CharSequence)oldName, (boolean)false, (int)2, null);
    }

    private final String adjustElementName(PsiElement elementToRename, String oldName, String newName) {
        if (oldName == null) {
            return newName;
        }
        String string = this.getComponentNameToMatch(elementToRename);
        if (string == null) {
            return newName;
        }
        String currentName = string;
        if (StringUtil.equalsIgnoreCase((CharSequence)currentName, (CharSequence)oldName)) {
            return newName;
        }
        return StringsKt.contains$default((CharSequence)currentName, (CharSequence)oldName, (boolean)false, (int)2, null) ? StringsKt.replace$default((String)currentName, (String)oldName, (String)newName, (boolean)false, (int)4, null) : newName;
    }

    private final String getComponentNameToMatch(PsiElement elementToRename) {
        String string;
        String componentName;
        PsiElement psiElement = elementToRename;
        String string2 = componentName = psiElement instanceof PsiNamedElement ? ((PsiNamedElement)elementToRename).getName() : (psiElement instanceof JSReferenceExpression ? ((JSReferenceExpression)elementToRename).getReferenceName() : null);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = JSStringUtil.toPascalCase(it);
        } else {
            string = null;
        }
        return string;
    }

    private final String fileToComponentName(PsiFile file, String newName) {
        String componentName = newName == null ? JSNameSuggestionsUtil.fileNameToElementName((PsiNamedElement)file, file) : JSNameSuggestionsUtil.fileNameToElementName((PsiNamedElement)file, newName);
        return JSStringUtil.toPascalCase(componentName);
    }

    static /* synthetic */ String fileToComponentName$default(JSComponentRenamePsiElementProcessor jSComponentRenamePsiElementProcessor, PsiFile psiFile, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return jSComponentRenamePsiElementProcessor.fileToComponentName(psiFile, string);
    }

    private final String generateDefaultComponentName(PsiFile file, String newName, boolean allowModal) {
        String componentName = (String)JSComponentRenamePsiElementProcessorKt.access$getCOMPONENT_NAME_KEY$p().get((UserDataHolder)file);
        if (componentName == null) {
            componentName = this.fileToComponentName(file, newName);
        }
        if (allowModal && componentName == null) {
            String suggestedName = JSFileReferencesUtil.getFileNameWithoutExtension(newName, JSFileReferencesUtil.IMPLICIT_EXTENSIONS);
            componentName = Messages.showInputDialog((Project)file.getProject(), (String)JavaScriptBundle.message("js.rename.component.usage.provide.name.message", new Object[0]), (String)JavaScriptBundle.message("js.rename.component.usage.provide.name.title", new Object[0]), null, (String)suggestedName, (InputValidator)((InputValidator)new InputValidatorEx(file){
                final /* synthetic */ PsiFile $file;
                {
                    this.$file = $file;
                }

                public boolean checkInput(String inputString) {
                    Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                    return JSNamesValidation.isIdentifier(inputString, (PsiElement)this.$file);
                }

                public boolean canClose(String inputString) {
                    Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                    return this.checkInput(inputString);
                }

                public String getErrorText(String inputString) {
                    Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                    return this.checkInput(inputString) ? null : JavaScriptBundle.message("js.rename.component.usage.provide.name.error", new Object[0]);
                }
            }));
        }
        JSComponentRenamePsiElementProcessorKt.access$getCOMPONENT_NAME_KEY$p().set((UserDataHolder)file, (Object)componentName);
        return componentName;
    }

    static /* synthetic */ String generateDefaultComponentName$default(JSComponentRenamePsiElementProcessor jSComponentRenamePsiElementProcessor, PsiFile psiFile, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jSComponentRenamePsiElementProcessor.generateDefaultComponentName(psiFile, string, bl);
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element2, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)elementListener, (String)"elementListener");
        return () -> JSComponentRenamePsiElementProcessor.getPostRenameCallback$lambda$7(element2);
    }

    private static final boolean findNonReachableReferences$lambda$1(ArrayList $result, PsiReference it) {
        $result.add(it);
        return true;
    }

    private static final boolean findNonReachableReferences$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void getPostRenameCallback$lambda$7(PsiElement $element) {
        JSComponentRenamePsiElementProcessorKt.access$getCOMPONENT_NAME_KEY$p().set((UserDataHolder)$element, null);
    }

    public static final /* synthetic */ boolean access$isNamedElementToRename(JSComponentRenamePsiElementProcessor $this, PsiElement element2) {
        return $this.isNamedElementToRename(element2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u000eH\u0014R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/refactoring/rename/JSComponentRenamePsiElementProcessor$JSComponentRenameDialog;", "Lcom/intellij/refactoring/rename/RenamePsiFileProcessor$PsiFileRenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "nameSuggestionContext", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "myCbSearchForComponentUsages", "Lcom/intellij/ui/NonFocusableCheckBox;", "createSearchForReferencesCheckbox", "", "panel", "Ljavax/swing/JPanel;", "gbConstraints", "Ljava/awt/GridBagConstraints;", "setComponentUsagesCheckboxVisibility", "doAction", "value", "", "searchForComponentUsages", "getSearchForComponentUsages", "()Z", "setSearchForComponentUsages", "(Z)V", "intellij.javascript.impl"})
    private static final class JSComponentRenameDialog
    extends RenamePsiFileProcessor.PsiFileRenameDialog {
        private NonFocusableCheckBox myCbSearchForComponentUsages;

        public JSComponentRenameDialog(@NotNull Project project, @NotNull PsiElement element2, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            super(project, element2, nameSuggestionContext, editor);
        }

        protected void createSearchForReferencesCheckbox(@NotNull JPanel panel, @NotNull GridBagConstraints gbConstraints) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)gbConstraints, (String)"gbConstraints");
            super.createSearchForReferencesCheckbox(panel, gbConstraints);
            if (!JSComponentCustomUsageSearcherKt.isSearchForComponentUsagesEnabled()) {
                return;
            }
            gbConstraints.insets = (Insets)JBUI.insetsBottom((int)4);
            gbConstraints.gridwidth = 1;
            gbConstraints.gridx = 0;
            gbConstraints.weighty = 0.0;
            gbConstraints.weightx = 1.0;
            gbConstraints.fill = 1;
            this.myCbSearchForComponentUsages = new NonFocusableCheckBox(JavaScriptBundle.message("js.rename.search.for.component.usages", new Object[0]));
            NonFocusableCheckBox nonFocusableCheckBox = this.myCbSearchForComponentUsages;
            if (nonFocusableCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForComponentUsages");
                nonFocusableCheckBox = null;
            }
            nonFocusableCheckBox.setSelected(this.getSearchForComponentUsages());
            NonFocusableCheckBox nonFocusableCheckBox2 = this.myCbSearchForComponentUsages;
            if (nonFocusableCheckBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForComponentUsages");
                nonFocusableCheckBox2 = null;
            }
            panel.add((Component)nonFocusableCheckBox2, gbConstraints);
            this.setComponentUsagesCheckboxVisibility();
            this.getCbSearchForReferences().addChangeListener(arg_0 -> JSComponentRenameDialog.createSearchForReferencesCheckbox$lambda$0(this, arg_0));
        }

        private final void setComponentUsagesCheckboxVisibility() {
            NonFocusableCheckBox nonFocusableCheckBox;
            boolean shouldSearchForReferences = this.getCbSearchForReferences().isSelected();
            NonFocusableCheckBox nonFocusableCheckBox2 = this.myCbSearchForComponentUsages;
            if (nonFocusableCheckBox2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForComponentUsages");
                nonFocusableCheckBox2 = null;
            }
            NonFocusableCheckBox $this$setComponentUsagesCheckboxVisibility_u24lambda_u241 = nonFocusableCheckBox = nonFocusableCheckBox2;
            boolean bl = false;
            $this$setComponentUsagesCheckboxVisibility_u24lambda_u241.setEnabled(shouldSearchForReferences);
            if (!shouldSearchForReferences) {
                $this$setComponentUsagesCheckboxVisibility_u24lambda_u241.setSelected(false);
            }
        }

        protected void doAction() {
            NonFocusableCheckBox nonFocusableCheckBox = this.myCbSearchForComponentUsages;
            if (nonFocusableCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myCbSearchForComponentUsages");
                nonFocusableCheckBox = null;
            }
            this.setSearchForComponentUsages(nonFocusableCheckBox.isSelected());
            super.doAction();
        }

        private final boolean getSearchForComponentUsages() {
            return JSRefactoringSettings.getInstance().RENAME_SEARCH_FOR_COMPONENT_USAGES;
        }

        private final void setSearchForComponentUsages(boolean value) {
            JSRefactoringSettings.getInstance().RENAME_SEARCH_FOR_COMPONENT_USAGES = value;
        }

        private static final void createSearchForReferencesCheckbox$lambda$0(JSComponentRenameDialog this$0, ChangeEvent it) {
            this$0.setComponentUsagesCheckboxVisibility();
        }
    }
}

